/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.extensions;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.sreg.SRegRequest;
import org.openid4java.message.sreg.SRegResponse;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.provider.dto.OpenIDAuthRequestDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDClaimDTO;
import org.wso2.carbon.identity.provider.openid.extensions.OpenIDExtension;
import org.wso2.carbon.identity.provider.openid.handlers.OpenIDAuthenticationRequest;

public class OpenIDSimpleReg
extends OpenIDExtension {
    private static final Log log = LogFactory.getLog(OpenIDSimpleReg.class);
    private OpenIDAuthenticationRequest request;

    public OpenIDSimpleReg(OpenIDAuthenticationRequest request) throws IdentityException {
        if (request == null) {
            log.debug((Object)"Request cannot be null while initializing OpenIDSimpleReg");
            throw IdentityException.error((String)"Request cannot be null while initializing OpenIDSimpleReg");
        }
        this.request = request;
    }

    @Override
    public void addRequiredAttributes(List<String> requiredAttributes) throws IdentityException {
        AuthRequest authRequest = null;
        MessageExtension extension = null;
        try {
            authRequest = this.request.getAuthRequest();
            if (authRequest != null) {
                if (authRequest.hasExtension("http://openid.net/sreg/1.0")) {
                    extension = authRequest.getExtension("http://openid.net/sreg/1.0");
                } else if (authRequest.hasExtension("http://openid.net/extensions/sreg/1.1")) {
                    extension = authRequest.getExtension("http://openid.net/extensions/sreg/1.1");
                } else if (authRequest.hasExtension("http://openid.net/srv/ax/1.0")) {
                    extension = authRequest.getExtension("http://openid.net/srv/ax/1.0");
                }
                if (extension instanceof SRegRequest) {
                    SRegRequest sregReq = null;
                    List required = null;
                    List optional = null;
                    sregReq = (SRegRequest)extension;
                    required = sregReq.getAttributes(true);
                    optional = sregReq.getAttributes();
                    if (optional != null && !optional.isEmpty()) {
                        for (Object attr : optional) {
                            if (required.contains(attr)) continue;
                            required.add(attr);
                        }
                    }
                    for (String claimUri : required) {
                        if (requiredAttributes.contains(claimUri)) continue;
                        requiredAttributes.add(claimUri);
                    }
                }
            }
        }
        catch (MessageException e) {
            log.error((Object)"Failed to add required attributes of OpenID Simple Registration", (Throwable)e);
            throw IdentityException.error((String)"Failed to add required attributes of OpenID Simple Registration", (Throwable)e);
        }
    }

    @Override
    public MessageExtension getMessageExtension(String userId, String profileName, OpenIDAuthRequestDTO requestDTO) throws IdentityException {
        MessageExtension extension = null;
        AuthRequest authRequest = null;
        SRegResponse response = null;
        try {
            authRequest = this.request.getAuthRequest();
            if (authRequest.hasExtension("http://openid.net/sreg/1.0")) {
                extension = authRequest.getExtension("http://openid.net/sreg/1.0");
            } else if (authRequest.hasExtension("http://openid.net/extensions/sreg/1.1")) {
                extension = authRequest.getExtension("http://openid.net/extensions/sreg/1.1");
            } else if (authRequest.hasExtension("http://openid.net/srv/ax/1.0")) {
                extension = authRequest.getExtension("http://openid.net/srv/ax/1.0");
            }
            if (log.isDebugEnabled()) {
                if (extension == null) {
                    log.info((Object)"SReg extension is null");
                } else {
                    log.info((Object)("SReg extension: " + extension.getTypeUri()));
                }
            }
            if (extension instanceof SRegRequest) {
                SRegRequest sregReq = null;
                List required = null;
                List optional = null;
                HashMap userDataSReg = null;
                Map<String, OpenIDClaimDTO> claimValues = null;
                sregReq = (SRegRequest)extension;
                required = sregReq.getAttributes(true);
                optional = sregReq.getAttributes();
                if (optional != null && !optional.isEmpty()) {
                    for (Object attr : optional) {
                        if (required.contains(attr)) continue;
                        required.add(attr);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.info((Object)("Required attributes for SReg request: " + required.toString()));
                }
                userDataSReg = new HashMap();
                response = SRegResponse.createSRegResponse((SRegRequest)sregReq, userDataSReg);
                claimValues = this.populateAttributeValues(required, userId, profileName, requestDTO);
                this.setSimpleAttributeRegistrationValues(response, claimValues);
            }
            return response;
        }
        catch (MessageException e) {
            log.error((Object)"Failed to create message extension for OpenID Simple Registration", (Throwable)e);
            throw IdentityException.error((String)"Failed to create message extension for OpenID Simple Registration", (Throwable)e);
        }
    }

    protected void setSimpleAttributeRegistrationValues(SRegResponse response, Map<String, OpenIDClaimDTO> claimValues) throws MessageException {
        Iterator<Map.Entry<String, OpenIDClaimDTO>> iterator = null;
        OpenIDClaimDTO claim = null;
        Map.Entry<String, OpenIDClaimDTO> entry2 = null;
        for (Map.Entry<String, OpenIDClaimDTO> entry2 : claimValues.entrySet()) {
            claim = entry2.getValue();
            response.addAttribute(claim.getClaimUri(), claim.getClaimValue());
        }
    }
}

