/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.openid4java.message.MessageExtension;
import org.wso2.carbon.identity.application.common.model.ClaimMapping;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.provider.dto.OpenIDAuthRequestDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDClaimDTO;

public abstract class OpenIDExtension {
    public abstract MessageExtension getMessageExtension(String var1, String var2, OpenIDAuthRequestDTO var3) throws IdentityException;

    public abstract void addRequiredAttributes(List<String> var1) throws IdentityException;

    protected Map<String, OpenIDClaimDTO> populateAttributeValues(List<String> requiredClaims, String openId, String profileName, OpenIDAuthRequestDTO requestDTO) {
        HashMap<String, OpenIDClaimDTO> map = new HashMap<String, OpenIDClaimDTO>();
        if (MapUtils.isEmpty(requestDTO.getResponseClaims())) {
            return map;
        }
        OpenIDClaimDTO[] claims = this.getClaimValues(requiredClaims, requestDTO.getResponseClaims());
        if (claims != null) {
            for (int i = 0; i < claims.length; ++i) {
                if (claims[i] == null) continue;
                map.put(claims[i].getClaimUri(), claims[i]);
            }
        }
        return map;
    }

    private OpenIDClaimDTO[] getClaimValues(List<String> requiredClaims, Map<ClaimMapping, String> receivedClaims) {
        ArrayList<OpenIDClaimDTO> claims = new ArrayList<OpenIDClaimDTO>();
        if (requiredClaims.isEmpty()) {
            for (Map.Entry<ClaimMapping, String> entry : receivedClaims.entrySet()) {
                if ("MultiAttributeSeparator".equals(entry.getKey().getRemoteClaim().getClaimUri())) continue;
                OpenIDClaimDTO openIDClaimDTO = new OpenIDClaimDTO();
                openIDClaimDTO.setClaimUri(entry.getKey().getRemoteClaim().getClaimUri());
                openIDClaimDTO.setClaimValue(entry.getValue());
                claims.add(openIDClaimDTO);
            }
        } else {
            for (String requiredClaim : requiredClaims) {
                ClaimMapping mapping = this.getClaimMappingFromMap(receivedClaims, requiredClaim);
                if (mapping == null) continue;
                OpenIDClaimDTO openIDClaimDTO = new OpenIDClaimDTO();
                openIDClaimDTO.setClaimUri(mapping.getRemoteClaim().getClaimUri());
                openIDClaimDTO.setClaimValue(receivedClaims.get(mapping));
                claims.add(openIDClaimDTO);
            }
        }
        return claims.toArray(new OpenIDClaimDTO[claims.size()]);
    }

    private ClaimMapping getClaimMappingFromMap(Map<ClaimMapping, String> claimMappings, String requiredClaimURI) {
        ClaimMapping mapping = null;
        for (ClaimMapping claimMapping : claimMappings.keySet()) {
            if (!claimMapping.getRemoteClaim().getClaimUri().equals(requiredClaimURI)) continue;
            mapping = claimMapping;
            break;
        }
        return mapping;
    }
}

