/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.provider.dto.OpenIDAuthRequestDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDClaimDTO;
import org.wso2.carbon.identity.provider.openid.extensions.OpenIDExtension;
import org.wso2.carbon.identity.provider.openid.handlers.OpenIDAuthenticationRequest;

public class OpenIDAttributeExchange
extends OpenIDExtension {
    private static final Log log = LogFactory.getLog(OpenIDAttributeExchange.class);
    private OpenIDAuthenticationRequest openidAuthnRequest;

    public OpenIDAttributeExchange(OpenIDAuthenticationRequest request) throws IdentityException {
        if (request == null) {
            log.debug((Object)"Request cannot be null while initializing OpenIDAttributeExchange");
            throw IdentityException.error((String)"Request cannot be null while initializing OpenIDAttributeExchange");
        }
        this.openidAuthnRequest = request;
    }

    @Override
    public void addRequiredAttributes(List<String> requiredAttributes) throws IdentityException {
        MessageExtension extensions = null;
        AuthRequest authRequest = null;
        try {
            authRequest = this.openidAuthnRequest.getAuthRequest();
            if (authRequest != null) {
                if (authRequest.hasExtension("http://openid.net/srv/ax/1.0")) {
                    extensions = authRequest.getExtension("http://openid.net/srv/ax/1.0");
                } else if (authRequest.hasExtension("http://openid.net/srv/ax/1.0")) {
                    extensions = authRequest.getExtension("http://openid.net/srv/ax/1.0");
                }
                if (extensions instanceof FetchRequest) {
                    Map.Entry entry2;
                    Iterator iterator;
                    Map required = null;
                    Map optional = null;
                    FetchRequest fetchRequest = null;
                    fetchRequest = (FetchRequest)extensions;
                    required = fetchRequest.getAttributes(true);
                    optional = fetchRequest.getAttributes();
                    if (optional != null && !optional.isEmpty()) {
                        iterator = optional.entrySet().iterator();
                        entry2 = null;
                        while (iterator.hasNext()) {
                            entry2 = iterator.next();
                            if (required.containsKey(entry2.getKey())) continue;
                            required.put(entry2.getKey(), entry2.getValue());
                        }
                    }
                    iterator = null;
                    entry2 = null;
                    for (Map.Entry entry2 : required.entrySet()) {
                        if (requiredAttributes.contains((String)entry2.getValue())) continue;
                        requiredAttributes.add((String)entry2.getValue());
                    }
                }
            }
        }
        catch (MessageException e) {
            log.error((Object)"Failed to add required attributes of Attribute Exchange", (Throwable)e);
            throw IdentityException.error((String)"Failed to add required attributes of Attribute Exchange", (Throwable)e);
        }
    }

    @Override
    public MessageExtension getMessageExtension(String userId, String profileName, OpenIDAuthRequestDTO requestDTO) throws IdentityException {
        MessageExtension extensions = null;
        AuthRequest authRequest = null;
        FetchResponse fetchResponse = null;
        try {
            authRequest = this.openidAuthnRequest.getAuthRequest();
            if (authRequest.hasExtension("http://openid.net/srv/ax/1.0")) {
                extensions = authRequest.getExtension("http://openid.net/srv/ax/1.0");
            } else if (authRequest.hasExtension("http://openid.net/srv/ax/1.0")) {
                extensions = authRequest.getExtension("http://openid.net/srv/ax/1.0");
            }
            if (extensions instanceof FetchRequest) {
                Map.Entry entry;
                Iterator iterator;
                Map required = null;
                Map optional = null;
                FetchRequest fetchRequest = null;
                Map<String, OpenIDClaimDTO> claimValues = null;
                fetchRequest = (FetchRequest)extensions;
                required = fetchRequest.getAttributes(true);
                optional = fetchRequest.getAttributes();
                if (optional != null && !optional.isEmpty()) {
                    iterator = optional.entrySet().iterator();
                    entry = null;
                    while (iterator.hasNext()) {
                        entry = iterator.next();
                        if (required.containsKey(entry.getKey())) continue;
                        required.put(entry.getKey(), entry.getValue());
                    }
                }
                iterator = null;
                entry = null;
                iterator = required.entrySet().iterator();
                ArrayList<String> requiredAttributes = null;
                requiredAttributes = new ArrayList<String>();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    if (requiredAttributes.contains((String)entry.getValue())) continue;
                    requiredAttributes.add((String)entry.getValue());
                }
                fetchResponse = FetchResponse.createFetchResponse((FetchRequest)fetchRequest, new HashMap());
                claimValues = this.populateAttributeValues(requiredAttributes, userId, profileName, requestDTO);
                if (MapUtils.isNotEmpty(claimValues)) {
                    this.setAttributeExchangeValues(fetchResponse, claimValues);
                }
            }
            return fetchResponse;
        }
        catch (MessageException e) {
            log.error((Object)"Failed to create message extension for Attribute Exchange", (Throwable)e);
            throw IdentityException.error((String)"Failed to create message extension for Attribute Exchange", (Throwable)e);
        }
    }

    protected void setAttributeExchangeValues(FetchResponse response, Map<String, OpenIDClaimDTO> claimValues) throws MessageException {
        Iterator<Map.Entry<String, OpenIDClaimDTO>> iterator = null;
        Map.Entry<String, OpenIDClaimDTO> entry2 = null;
        OpenIDClaimDTO claim = null;
        for (Map.Entry<String, OpenIDClaimDTO> entry2 : claimValues.entrySet()) {
            claim = entry2.getValue();
            response.addAttribute(claim.getClaimUri(), claim.getClaimValue());
        }
    }
}

