/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.model.OpenIDRememberMeDO;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.provider.IdentityProviderException;

public class OpenIDRememberMeTokenDAO {
    private static final Log log = LogFactory.getLog(OpenIDRememberMeTokenDAO.class);

    public void updateTokenData(OpenIDRememberMeDO rememberMe) throws IdentityProviderException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            if (this.isTokenExist(connection, rememberMe)) {
                prepStmt = connection.prepareStatement("UPDATE IDN_OPENID_REMEMBER_ME SET COOKIE_VALUE = ? WHERE USER_NAME = ? AND TENANT_ID = ?");
                prepStmt.setString(2, rememberMe.getUserName());
                prepStmt.setInt(3, IdentityTenantUtil.getTenantIdOfUser((String)rememberMe.getUserName()));
                prepStmt.setString(1, rememberMe.getToken());
                prepStmt.execute();
                connection.commit();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RememberMe token of " + rememberMe.getUserName() + " successfully updated in the database."));
                }
            } else {
                prepStmt = connection.prepareStatement("INSERT INTO IDN_OPENID_REMEMBER_ME (USER_NAME, TENANT_ID, COOKIE_VALUE) VALUES (?,?,?)");
                prepStmt.setString(1, rememberMe.getUserName());
                prepStmt.setInt(2, IdentityTenantUtil.getTenantIdOfUser((String)rememberMe.getUserName()));
                prepStmt.setString(3, rememberMe.getToken());
                prepStmt.execute();
                connection.commit();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RememberMe token of " + rememberMe.getUserName() + " successfully stored in the database."));
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new IdentityProviderException("Unable to update the token for " + rememberMe.getUserName(), e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeStatement(prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
                throw throwable;
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    public OpenIDRememberMeDO getTokenData(OpenIDRememberMeDO rememberMe) throws IdentityProviderException {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("SELECT USER_NAME, TENANT_ID, COOKIE_VALUE, CREATED_TIME FROM IDN_OPENID_REMEMBER_ME WHERE  USER_NAME = ? AND TENANT_ID = ?");
            prepStmt.setString(1, rememberMe.getUserName());
            prepStmt.setInt(2, IdentityTenantUtil.getTenantIdOfUser((String)rememberMe.getUserName()));
            OpenIDRememberMeDO openIDRememberMeDO = this.buildRememberMeDO(prepStmt.executeQuery(), rememberMe.getUserName());
            connection.commit();
            OpenIDRememberMeDO openIDRememberMeDO2 = openIDRememberMeDO;
            return openIDRememberMeDO2;
        }
        catch (SQLException e) {
            throw new IdentityProviderException("Unable to load RememberMe token for " + rememberMe.getUserName(), e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTokenExist(Connection connection, OpenIDRememberMeDO rememberMe) throws SQLException {
        PreparedStatement prepStmt = null;
        ResultSet results = null;
        boolean result = false;
        try {
            prepStmt = connection.prepareStatement("SELECT * FROM IDN_OPENID_REMEMBER_ME WHERE USER_NAME = ? AND TENANT_ID = ?");
            prepStmt.setString(1, rememberMe.getUserName());
            prepStmt.setInt(2, IdentityTenantUtil.getTenantIdOfUser((String)rememberMe.getUserName()));
            results = prepStmt.executeQuery();
            if (results.next()) {
                result = true;
            }
        }
        catch (Throwable throwable) {
            IdentityDatabaseUtil.closeResultSet(results);
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            throw throwable;
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)results);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OpenIDRememberMeDO buildRememberMeDO(ResultSet results, String username) {
        OpenIDRememberMeDO remDO = new OpenIDRememberMeDO();
        try {
            if (!results.next()) {
                log.debug((Object)("RememberMe token not found for the user " + username));
                OpenIDRememberMeDO openIDRememberMeDO = remDO;
                return openIDRememberMeDO;
            }
            remDO.setUserName(results.getString(1));
            remDO.setToken(results.getString(3));
            remDO.setTimestamp(results.getTimestamp(4));
        }
        catch (SQLException e) {
            log.error((Object)("Failed to create RememberMeDO for the user " + username + ". Error while accessing the database"), (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeResultSet((ResultSet)results);
        }
        return remDO;
    }
}

