/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.wso2.carbon.identity.core.util.IdentityDatabaseUtil;

public class OpenIDAssociationDAO {
    private static final Log log = LogFactory.getLog(OpenIDAssociationDAO.class);
    private String associationStore;
    private static OpenIDAssociationDAO privateStore = new OpenIDAssociationDAO("PRIVATE");
    private static OpenIDAssociationDAO sharedStore = new OpenIDAssociationDAO("SHARED");

    private OpenIDAssociationDAO(String storeType) {
        this.associationStore = storeType;
    }

    public static OpenIDAssociationDAO getInstance(String storeType) {
        if (storeType.equals("PRIVATE")) {
            return privateStore;
        }
        return sharedStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeAssociation(Association association) {
        Connection connection = IdentityDatabaseUtil.getDBConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = connection.prepareStatement("INSERT INTO IDN_OPENID_ASSOCIATIONS (HANDLE, ASSOC_TYPE, EXPIRE_IN, MAC_KEY, ASSOC_STORE) VALUES (?,?,?,?,?)");
            prepStmt.setString(1, association.getHandle());
            prepStmt.setString(2, association.getType());
            prepStmt.setTimestamp(3, new Timestamp(association.getExpiry().getTime()));
            prepStmt.setString(4, Base64.encode((byte[])association.getMacKey().getEncoded()));
            prepStmt.setString(5, this.associationStore);
            prepStmt.execute();
            connection.commit();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Association " + association.getHandle() + " successfully stored in the database"));
            }
            connection.commit();
        }
        catch (SQLException e) {
            log.error((Object)("Failed to store the association " + association.getHandle()), (Throwable)e);
        }
        finally {
            IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            IdentityDatabaseUtil.closeConnection((Connection)connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Association loadAssociation(String handle) {
        ResultSet results;
        PreparedStatement prepStmt;
        Connection connection;
        block6: {
            connection = IdentityDatabaseUtil.getDBConnection();
            prepStmt = null;
            results = null;
            prepStmt = connection.prepareStatement("SELECT HANDLE, ASSOC_TYPE, EXPIRE_IN, MAC_KEY, ASSOC_STORE FROM IDN_OPENID_ASSOCIATIONS WHERE HANDLE = ?");
            prepStmt.setString(1, handle);
            results = prepStmt.executeQuery();
            if (!results.next()) break block6;
            log.debug((Object)("Loading association " + handle));
            Association association = this.buildAssociationObject(results);
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)results, (PreparedStatement)prepStmt);
            return association;
        }
        try {
            connection.commit();
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Failed to load the association " + handle), (Throwable)e);
            }
            catch (Throwable throwable) {
                IdentityDatabaseUtil.closeAllConnections((Connection)connection, results, (PreparedStatement)prepStmt);
                throw throwable;
            }
            IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)results, (PreparedStatement)prepStmt);
        }
        IdentityDatabaseUtil.closeAllConnections((Connection)connection, (ResultSet)results, (PreparedStatement)prepStmt);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Failed to load the association " + handle + " from the database"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAssociation(String handle) {
        PreparedStatement prepStmt;
        Connection connection;
        block6: {
            connection = IdentityDatabaseUtil.getDBConnection();
            prepStmt = null;
            try {
                if (this.isAssociationExist(connection, handle)) {
                    prepStmt = connection.prepareStatement("DELETE FROM IDN_OPENID_ASSOCIATIONS WHERE HANDLE = ?");
                    prepStmt.setString(1, handle);
                    prepStmt.execute();
                    connection.commit();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Association " + handle + " successfully removed from the database"));
                    }
                    break block6;
                }
                if (!log.isDebugEnabled()) break block6;
                log.debug((Object)("Association " + handle + " does not exist in the database"));
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Failed to remove the association " + handle), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeStatement(prepStmt);
                    IdentityDatabaseUtil.closeConnection((Connection)connection);
                    throw throwable;
                }
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                IdentityDatabaseUtil.closeConnection((Connection)connection);
            }
        }
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        IdentityDatabaseUtil.closeConnection((Connection)connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAssociationExist(Connection connection, String handle) {
        boolean result;
        ResultSet results;
        PreparedStatement prepStmt;
        block4: {
            prepStmt = null;
            results = null;
            result = false;
            try {
                prepStmt = connection.prepareStatement("SELECT 1 FROM IDN_OPENID_ASSOCIATIONS WHERE HANDLE = ?");
                prepStmt.setString(1, handle);
                results = prepStmt.executeQuery();
                if (!results.next()) break block4;
                result = true;
                log.debug((Object)("Association " + handle + " found"));
            }
            catch (SQLException e) {
                try {
                    log.error((Object)("Failed to load the association " + handle + ". Error while accessing the database. "), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IdentityDatabaseUtil.closeResultSet(results);
                    IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
                    throw throwable;
                }
                IdentityDatabaseUtil.closeResultSet((ResultSet)results);
                IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
            }
        }
        IdentityDatabaseUtil.closeResultSet((ResultSet)results);
        IdentityDatabaseUtil.closeStatement((PreparedStatement)prepStmt);
        log.debug((Object)("Association " + handle + " not found"));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Association buildAssociationObject(ResultSet results) {
        String assocHandle;
        Association assoc;
        block13: {
            assoc = null;
            assocHandle = null;
            try {
                assocHandle = results.getString(1);
                String assocType = results.getString(2);
                Date expireIn = new Date(results.getTimestamp(3).getTime());
                String macKey = results.getString(4);
                String assocStore = results.getString(5);
                if (assocHandle == null || assocType == null || expireIn == null || macKey == null || assocStore == null) {
                    log.error((Object)"Required data missing. Cannot build the Association object");
                    Association association = null;
                    return association;
                }
                if (this.associationStore.equals("PRIVATE") && assocStore.equals("SHARED")) {
                    log.error((Object)"Invalid association data found. Tried to load a Private Association but found a Shared Association");
                    Association association = null;
                    return association;
                }
                if (this.associationStore.equals("SHARED") && assocStore.equals("PRIVATE")) {
                    log.error((Object)"Invalid association data found. Tried to load a Shared Association but found a Private Association");
                    Association association = null;
                    return association;
                }
                if ("HMAC-SHA1".equals(assocType)) {
                    assoc = Association.createHmacSha1((String)assocHandle, (byte[])Base64.decode((String)macKey), (Date)expireIn);
                    break block13;
                }
                if ("HMAC-SHA256".equals(assocType)) {
                    assoc = Association.createHmacSha256((String)assocHandle, (byte[])Base64.decode((String)macKey), (Date)expireIn);
                    break block13;
                }
                log.error((Object)("Invalid association type " + assocType + " loaded from database"));
                Association association = null;
                return association;
            }
            catch (SQLException e) {
                log.error((Object)("Failed to build the Association for " + assocHandle + ". Error while accessing the database."), (Throwable)e);
            }
            finally {
                IdentityDatabaseUtil.closeResultSet((ResultSet)results);
            }
        }
        log.debug((Object)("Association " + assocHandle + " loaded successfully from the database."));
        return assoc;
    }
}

