/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.client;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.message.Parameter;
import org.openid4java.message.ParameterList;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.provider.OpenIDProviderService;
import org.wso2.carbon.identity.provider.dto.OpenIDAuthRequestDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDAuthResponseDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDClaimDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDParameterDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDProviderInfoDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDRememberMeDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDUserProfileDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDUserRPDTO;

public class OpenIDAdminClient {
    public static final String OPENID_ADMIN_COOKIE = "OPENID_ADMIN_COOKIE";
    public static final String OPENID_PROVIDER_SERVICE = "OpenIDProviderService";
    private static Integer sessionTimeout = null;
    private static final Log log = LogFactory.getLog(OpenIDAdminClient.class);
    private String newCookieValue;
    private boolean isUserApprovalBypassEnabled;
    private OpenIDProviderService openIDProviderService = new OpenIDProviderService();

    public OpenIDAdminClient(ConfigurationContext context, String backendServerURL, String cookie) throws AxisFault {
        this.isUserApprovalBypassEnabled = this.openIDProviderService.isOpenIDUserApprovalBypassEnabled();
        if (sessionTimeout == null) {
            sessionTimeout = OpenIDProviderService.getOpenIDSessionTimeout();
        }
    }

    public String getNewCookieValue() {
        return this.newCookieValue;
    }

    public void setNewCookieValue(String newCookieValue) {
        this.newCookieValue = newCookieValue;
    }

    public OpenIDProviderInfoDTO getOpenIDProviderInfo(String userName, String openID) throws IdentityProviderException {
        return this.openIDProviderService.getOpenIDProviderInfo(userName, openID);
    }

    public boolean authenticateWithOpenID(String openId, String password, HttpSession session, HttpServletRequest request, HttpServletResponse response, boolean useRememberMe) {
        boolean isAuthenticated = false;
        OpenIDRememberMeDTO dto = null;
        try {
            Cookie[] cookies = request.getCookies();
            String token = null;
            if (cookies != null) {
                Cookie curCookie = null;
                for (int x = 0; x < cookies.length; ++x) {
                    curCookie = cookies[x];
                    if (!curCookie.getName().equalsIgnoreCase("openidtoken")) continue;
                    token = curCookie.getValue();
                    break;
                }
            }
            if (token != null && !"null".equals(token) || useRememberMe) {
                dto = this.openIDProviderService.authenticateWithOpenIDRememberMe(openId.trim(), password, request.getRemoteAddr(), token);
                if (dto != null && dto.isAuthenticated()) {
                    this.newCookieValue = dto.getNewCookieValue();
                }
                isAuthenticated = dto.isAuthenticated();
            } else {
                isAuthenticated = this.openIDProviderService.authenticateWithOpenID(openId.trim(), password);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to authenticate with Open ID " + openId), (Throwable)e);
            return false;
        }
        return isAuthenticated;
    }

    public Map<String, OpenIDClaimDTO> getClaimValues(String openId, String profileId, ParameterList requiredClaims) throws IdentityProviderException {
        List list = requiredClaims.getParameters();
        OpenIDParameterDTO[] params = new OpenIDParameterDTO[list.size()];
        int i = 0;
        for (Object object : list) {
            Parameter param = (Parameter)object;
            OpenIDParameterDTO openIDParameterDTO = new OpenIDParameterDTO();
            openIDParameterDTO.setName(param.getKey());
            openIDParameterDTO.setValue(param.getValue());
            params[i++] = openIDParameterDTO;
        }
        OpenIDClaimDTO[] claims = this.openIDProviderService.getClaimValues(openId.trim(), profileId, params);
        HashMap<String, OpenIDClaimDTO> map = new HashMap<String, OpenIDClaimDTO>();
        if (claims != null) {
            for (int j = 0; j < claims.length; ++j) {
                if (claims[j] == null) continue;
                map.put(claims[j].getClaimUri(), claims[j]);
            }
        }
        return map;
    }

    public OpenIDAuthResponseDTO getOpenIDAuthResponse(OpenIDAuthRequestDTO authRequest) throws IdentityProviderException {
        return this.openIDProviderService.getOpenIDAuthResponse(authRequest);
    }

    public String getOpenIDAssociationResponse(OpenIDParameterDTO[] params) {
        return this.openIDProviderService.getOpenIDAssociationResponse(params);
    }

    public String verify(OpenIDParameterDTO[] params) throws IdentityProviderException {
        return this.openIDProviderService.verify(params);
    }

    public OpenIDUserProfileDTO[] getUserProfiles(String openid, ParameterList requredClaims) throws IdentityProviderException {
        OpenIDParameterDTO[] params = null;
        List list = null;
        list = requredClaims.getParameters();
        params = new OpenIDParameterDTO[list.size()];
        int i = 0;
        for (Object object : list) {
            Parameter param = (Parameter)object;
            OpenIDParameterDTO openIDParameterDTO = new OpenIDParameterDTO();
            openIDParameterDTO.setName(param.getKey());
            openIDParameterDTO.setValue(param.getValue());
            params[i++] = openIDParameterDTO;
        }
        return this.openIDProviderService.getUserProfiles(openid, params);
    }

    public void updateOpenIDUserRPInfo(String rpUrl, boolean isTrustedAlways, String defaultProfileName, String openID) throws IdentityProviderException {
        if (this.isUserApprovalBypassEnabled) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating RP " + rpUrl + "info for " + openID));
        }
        OpenIDUserRPDTO rpdto = new OpenIDUserRPDTO();
        rpdto.setRpUrl(rpUrl);
        rpdto.setTrustedAlways(isTrustedAlways);
        rpdto.setDefaultProfileName(defaultProfileName);
        rpdto.setOpenID(openID);
        this.openIDProviderService.updateOpenIDUserRPInfo(rpdto);
    }

    public OpenIDUserRPDTO[] getOpenIDUserRPs(String openID) throws IdentityProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting OpenID User RP DTOs for " + openID));
        }
        return this.openIDProviderService.getOpenIDUserRPs(openID);
    }

    public OpenIDUserRPDTO getOpenIDUserRPDTO(String openID, String rpUrl) throws IdentityProviderException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Getting OpenID User RP DTO for " + openID + "for RP " + rpUrl));
        }
        return this.openIDProviderService.getOpenIDUserRPInfo(openID, rpUrl);
    }

    public String[] getOpenIDUserRPInfo(String openID, String rpUrl) throws IdentityProviderException {
        OpenIDUserRPDTO rpdto = null;
        String[] rpInfo = new String[7];
        if (!this.isUserApprovalBypassEnabled) {
            rpdto = this.openIDProviderService.getOpenIDUserRPInfo(openID, rpUrl);
        }
        if (rpdto != null) {
            rpInfo[0] = Boolean.toString(rpdto.isTrustedAlways());
            rpInfo[1] = rpdto.getDefaultProfileName();
            rpInfo[2] = rpdto.getOpenID();
            rpInfo[3] = rpdto.getRpUrl();
            rpInfo[4] = rpdto.getUserName();
            rpInfo[5] = Integer.toString(rpdto.getVisitCount());
            if (rpdto.getLastVisit() == null) {
                rpdto.setLastVisit(new Date());
            }
            rpInfo[6] = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(rpdto.getLastVisit());
        } else {
            rpInfo[0] = "false";
            rpInfo[1] = "default";
        }
        return rpInfo;
    }

    public boolean isOpenIDUserApprovalBypassEnabled() {
        return this.isUserApprovalBypassEnabled;
    }

    public int getOpenIDSessionTimeout() throws IdentityException {
        return sessionTimeout;
    }
}

