/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.cache;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.model.OpenIDRememberMeDO;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.provider.openid.cache.OpenIDBaseCache;
import org.wso2.carbon.identity.provider.openid.cache.OpenIDIdentityCacheEntry;
import org.wso2.carbon.identity.provider.openid.cache.OpenIDIdentityCacheKey;

public class OpenIDRememberMeTokenCache
extends OpenIDBaseCache<OpenIDIdentityCacheKey, OpenIDIdentityCacheEntry> {
    private static final String OPENID_REMEMBER_ME_CACHE = "OPENID_REMEMBER_ME_CACHE";
    private static OpenIDRememberMeTokenCache rememberMeCache = null;
    private static final Log log = LogFactory.getLog(OpenIDRememberMeTokenCache.class);

    protected OpenIDRememberMeTokenCache() {
        super(OPENID_REMEMBER_ME_CACHE);
    }

    public static synchronized OpenIDRememberMeTokenCache getCacheInstance() {
        if (rememberMeCache == null) {
            rememberMeCache = new OpenIDRememberMeTokenCache();
        }
        return rememberMeCache;
    }

    public synchronized void updateTokenData(OpenIDRememberMeDO rememberMe) throws IdentityProviderException {
        OpenIDIdentityCacheKey key;
        String username = rememberMe.getUserName();
        int tenantId = IdentityTenantUtil.getTenantIdOfUser((String)rememberMe.getUserName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating RememberMe token in cache for " + username + " with tenant ID " + tenantId));
        }
        if (rememberMeCache.getValueFromCache(key = new OpenIDIdentityCacheKey(tenantId, username)) != null) {
            rememberMeCache.clearCacheEntry(key);
        }
        Date date = null;
        date = rememberMe.getTimestamp() != null ? new Date(rememberMe.getTimestamp().getTime()) : new Date();
        OpenIDIdentityCacheEntry entry = new OpenIDIdentityCacheEntry(rememberMe.getToken(), null, date);
        rememberMeCache.addToCache(key, entry);
    }

    public synchronized OpenIDRememberMeDO getTokenData(OpenIDRememberMeDO rememberMe) throws IdentityProviderException {
        OpenIDIdentityCacheKey key;
        OpenIDIdentityCacheEntry entry;
        String username = rememberMe.getUserName();
        int tenantId = IdentityTenantUtil.getTenantIdOfUser((String)rememberMe.getUserName());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading RememberMe token in cache for " + username + " with tenant ID " + tenantId));
        }
        if ((entry = (OpenIDIdentityCacheEntry)rememberMeCache.getValueFromCache(key = new OpenIDIdentityCacheKey(tenantId, username))) == null) {
            return null;
        }
        rememberMe.setToken(entry.getCacheEntry());
        Timestamp timestamp = new Timestamp(entry.getDate().getTime());
        rememberMe.setTimestamp(timestamp);
        return rememberMe;
    }
}

