/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.cache;

import java.security.Key;
import java.util.Arrays;
import java.util.Date;
import org.wso2.carbon.identity.provider.openid.cache.OpenIDCacheEntry;

public class OpenIDIdentityCacheEntry
extends OpenIDCacheEntry {
    private static final long serialVersionUID = 3746964700806693258L;
    private String cacheEntry;
    private String[] cacheEntryArray;
    private int hashEntry;
    private long cacheInterval;
    private boolean cacheClearing;
    private Key secretKey;
    private Date date;

    public OpenIDIdentityCacheEntry(String cacheEntry) {
        this.cacheEntry = cacheEntry;
    }

    public OpenIDIdentityCacheEntry(int hashEntry) {
        this.hashEntry = hashEntry;
    }

    public OpenIDIdentityCacheEntry(boolean cacheClearing) {
        this.cacheClearing = cacheClearing;
    }

    public OpenIDIdentityCacheEntry(String cacheEntry, long cacheInterval) {
        this.cacheEntry = cacheEntry;
        this.cacheInterval = cacheInterval;
    }

    public OpenIDIdentityCacheEntry(String[] cacheEntryArray) {
        this.cacheEntryArray = Arrays.copyOf(cacheEntryArray, cacheEntryArray.length);
    }

    public OpenIDIdentityCacheEntry(String cacheEntry, Key secretKey, Date date) {
        this.cacheEntry = cacheEntry;
        this.secretKey = secretKey;
        this.date = date;
    }

    public String getCacheEntry() {
        return this.cacheEntry;
    }

    public int getHashEntry() {
        return this.hashEntry;
    }

    public long getCacheInterval() {
        return this.cacheInterval;
    }

    public boolean isCacheClearing() {
        return this.cacheClearing;
    }

    public String[] getCacheEntryArray() {
        return this.cacheEntryArray;
    }

    public Key getSecretKey() {
        return this.secretKey;
    }

    public Date getDate() {
        return this.date;
    }
}

