/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.cache;

import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import org.wso2.carbon.identity.provider.openid.cache.OpenIDCacheEntry;
import org.wso2.carbon.identity.provider.openid.cache.OpenIDCacheKey;

public abstract class OpenIDBaseCache<K extends OpenIDCacheKey, V extends OpenIDCacheEntry> {
    private static final String OPENID_CACHE_MANAGER = "OpenIDCacheManager";
    private String openidCacheName;

    protected OpenIDBaseCache(String cacheName) {
        this.openidCacheName = cacheName;
    }

    private Cache<K, V> getOpenIDCache() {
        CacheManager cacheManager = Caching.getCacheManagerFactory().getCacheManager(OPENID_CACHE_MANAGER);
        return cacheManager.getCache(this.openidCacheName);
    }

    public void addToCache(K key, V entry) {
        this.clearCacheEntry(key);
        Cache<K, V> cache = this.getOpenIDCache();
        if (cache != null) {
            cache.put(key, entry);
        }
    }

    public V getValueFromCache(K key) {
        Cache<K, V> cache = this.getOpenIDCache();
        if (cache != null && cache.containsKey(key)) {
            return (V)((OpenIDCacheEntry)cache.get(key));
        }
        return null;
    }

    public void clearCacheEntry(K key) {
        Cache<K, V> cache = this.getOpenIDCache();
        if (cache != null && cache.containsKey(key)) {
            cache.remove(key);
        }
    }

    public void clear() {
        Cache<K, V> cache = this.getOpenIDCache();
        if (cache != null) {
            cache.removeAll();
        }
    }
}

