/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid.cache;

import java.security.Key;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.wso2.carbon.identity.base.IdentityRuntimeException;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.openid.cache.OpenIDBaseCache;
import org.wso2.carbon.identity.provider.openid.cache.OpenIDIdentityCacheEntry;
import org.wso2.carbon.identity.provider.openid.cache.OpenIDIdentityCacheKey;

public class OpenIDAssociationCache
extends OpenIDBaseCache<OpenIDIdentityCacheKey, OpenIDIdentityCacheEntry> {
    private static final String OPENID_ASSOCIATION_CACHE = "OPENID_ASSOCIATION_CACHE";
    private static OpenIDAssociationCache associationCache = null;
    private static final Log log = LogFactory.getLog(OpenIDAssociationCache.class);

    private OpenIDAssociationCache() {
        super(OPENID_ASSOCIATION_CACHE);
    }

    public static synchronized OpenIDAssociationCache getCacheInstance() {
        if (associationCache == null) {
            associationCache = new OpenIDAssociationCache();
        }
        return associationCache;
    }

    public void addToCache(Association association) {
        if (association == null) {
            throw new IllegalArgumentException("Association is 'Null'");
        }
        OpenIDIdentityCacheKey cacheKey = new OpenIDIdentityCacheKey(0, association.getHandle());
        OpenIDIdentityCacheEntry cacheEntry = new OpenIDIdentityCacheEntry(association.getType(), association.getMacKey(), association.getExpiry());
        associationCache.addToCache(cacheKey, cacheEntry);
        if (log.isDebugEnabled()) {
            log.debug((Object)("New entry is added to cache for handle : " + association.getHandle()));
        }
    }

    public Association getFromCache(String handle) {
        if (IdentityUtil.isBlank((String)handle)) {
            throw new IllegalArgumentException("Handle is 'NULL'");
        }
        OpenIDIdentityCacheKey cacheKey = new OpenIDIdentityCacheKey(0, handle);
        OpenIDIdentityCacheEntry cacheEntry = (OpenIDIdentityCacheEntry)associationCache.getValueFromCache(cacheKey);
        if (cacheEntry != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cache hit for handle : " + handle));
            }
            Date expiry = cacheEntry.getDate();
            String type = cacheEntry.getCacheEntry();
            Key secretKey = cacheEntry.getSecretKey();
            if ("HMAC-SHA1".equals(type)) {
                return Association.createHmacSha1((String)handle, (byte[])secretKey.getEncoded(), (Date)expiry);
            }
            if ("HMAC-SHA256".equals(type)) {
                return Association.createHmacSha256((String)handle, (byte[])secretKey.getEncoded(), (Date)expiry);
            }
            throw IdentityRuntimeException.error((String)("Invalid algorithm " + type));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Cache miss for handle : " + handle));
        }
        return null;
    }

    public void removeCacheEntry(String handle) {
        if (handle != null) {
            OpenIDIdentityCacheKey cacheKey = new OpenIDIdentityCacheKey(0, handle);
            associationCache.clearCacheEntry(cacheKey);
        }
    }
}

