/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid;

import java.security.SecureRandom;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.server.InMemoryServerAssociationStore;
import org.wso2.carbon.identity.provider.openid.replication.OpenIDAssociationReplicationManager;

public class PrivateAssociationReplicationStore
extends InMemoryServerAssociationStore {
    private int storeId = new SecureRandom().nextInt(9999);
    private String timestamp = Long.toString(new Date().getTime());
    private int counter = 0;
    private String associationStoreType;
    private static final Log log = LogFactory.getLog(PrivateAssociationReplicationStore.class);

    public PrivateAssociationReplicationStore(String associationsType) {
        this.associationStoreType = associationsType;
    }

    public PrivateAssociationReplicationStore() {
    }

    public Association generate(String type, int expiryIn) throws AssociationException {
        String handle = this.storeId + this.timestamp + "-" + this.getCounter();
        Association association = Association.generate((String)type, (String)handle, (int)expiryIn);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing association " + association.getHandle() + " in the map."));
        }
        OpenIDAssociationReplicationManager.getPersistenceManager().addAssociation(association);
        return association;
    }

    private synchronized int getCounter() {
        return this.counter++;
    }

    public Association load(String handle) {
        Association association = OpenIDAssociationReplicationManager.getPersistenceManager().getAssociation(handle);
        if (association == null) {
            log.warn((Object)("Association " + handle + " not found in the map."));
            return null;
        }
        if (association.hasExpired()) {
            log.warn((Object)("Association is expired for handle " + handle));
            this.remove(handle);
            return null;
        }
        return association;
    }

    public void remove(String handle) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing the association" + handle + " from the map"));
        }
        OpenIDAssociationReplicationManager.getPersistenceManager().removeAssociation(handle);
    }
}

