/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid;

import java.security.SecureRandom;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.server.InMemoryServerAssociationStore;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.openid.OpenIDServerManager;

public class PrivateAssociationCryptoStore
extends InMemoryServerAssociationStore {
    private int storeId = new SecureRandom().nextInt(9999);
    private int counter = 0;
    private int expireIn;
    private String serverKey = "jscascasjcwt3276432yvdqwd";
    private static final Log log = LogFactory.getLog(PrivateAssociationCryptoStore.class);

    public PrivateAssociationCryptoStore() {
        String serverKey = IdentityUtil.getProperty((String)"OpenID.OpenIDPrivateAssociationServerKey");
        if (StringUtils.isNotBlank((String)serverKey)) {
            this.serverKey = serverKey;
        }
    }

    public Association load(String handle) {
        if (IdentityUtil.isBlank((String)handle)) {
            throw new IllegalArgumentException("Handle is empty");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Inside load(); handle : " + handle));
        }
        String timeStamp = handle.substring(Integer.toString(this.storeId).length(), handle.indexOf("-"));
        Date expireDate = new Date(Long.parseLong(timeStamp) + (long)this.expireIn);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Calculated Expiry Time : " + expireDate.getTime()));
        }
        return Association.createHmacSha256((String)handle, (byte[])(this.serverKey + handle).getBytes(), (Date)expireDate);
    }

    public Association generate(String type, int expiryIn) throws AssociationException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Inside generate();  type : " + type + " expiryIn  : " + expiryIn));
        }
        long timestamp = new Date().getTime();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Current Time : " + timestamp));
        }
        if (this.expireIn == 0) {
            this.expireIn = expiryIn * 1000;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Expires In : " + this.expireIn));
        }
        Date expireDate = new Date(timestamp + (long)this.expireIn);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Expiry Time : " + expireDate.getTime()));
        }
        String handle = Integer.toString(this.storeId) + Long.toString(timestamp) + "-" + Integer.toString(this.counter++);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Handle generated by crypto store : " + handle));
        }
        Association association = Association.createHmacSha256((String)handle, (byte[])(this.serverKey + handle).getBytes(), (Date)expireDate);
        OpenIDServerManager.setThreadLocalAssociation(association);
        return association;
    }
}

