/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.OpenIDException;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.DirectError;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;
import org.openid4java.message.VerifyRequest;
import org.openid4java.message.VerifyResponse;
import org.openid4java.server.ServerAssociationStore;
import org.openid4java.server.ServerException;
import org.openid4java.server.ServerManager;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.openid.OpenIDServerAssociationStore;

public class OpenIDServerManager
extends ServerManager {
    private static final Log log = LogFactory.getLog(OpenIDServerManager.class);
    private static ThreadLocal<Association> threadLocalAssociation = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OpenIDServerManager() {
        OpenIDServerAssociationStore sharedAssociations = new OpenIDServerAssociationStore("SHARED");
        super.setSharedAssociations((ServerAssociationStore)sharedAssociations);
        OpenIDServerAssociationStore privateAssociations = null;
        Class<?> clazz = Runtime.getRuntime().getClass();
        synchronized (clazz) {
            String privateAssociationStoreClassName = IdentityUtil.getProperty((String)"OpenID.OpenIDPrivateAssociationStoreClass");
            if (privateAssociationStoreClassName != null && !privateAssociationStoreClassName.trim().isEmpty()) {
                privateAssociationStoreClassName = privateAssociationStoreClassName.trim();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Initialising privateAssociation Store : " + privateAssociationStoreClassName));
                }
                try {
                    privateAssociations = (ServerAssociationStore)Class.forName(privateAssociationStoreClassName).newInstance();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Successfully initialized privateAssociation Store : " + privateAssociationStoreClassName));
                    }
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Private association store class : " + privateAssociationStoreClassName + " not found"), (Throwable)e);
                }
                catch (InstantiationException e) {
                    log.error((Object)("Error while initializing association store class : " + privateAssociationStoreClassName), (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    log.error((Object)("Error while initializing association store class : " + privateAssociationStoreClassName), (Throwable)e);
                }
                catch (Exception e) {
                    log.error((Object)"Error while initializing private association store", (Throwable)e);
                }
            }
            if (privateAssociations == null) {
                privateAssociations = new OpenIDServerAssociationStore("PRIVATE");
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Setting default OpenID Server Association Store: " + OpenIDServerAssociationStore.class.getName()));
                }
            }
        }
        super.setPrivateAssociations((ServerAssociationStore)privateAssociations);
    }

    public Message authResponse(AuthRequest authReq, String userSelId, String userSelClaimed, boolean authenticatedAndApproved, String opEndpoint, boolean signNow) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Association handle in AuthRequest : " + authReq.getHandle()));
        }
        return super.authResponse(authReq, userSelId, userSelClaimed, authenticatedAndApproved, opEndpoint, signNow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sign(AuthSuccess authSuccess) throws ServerException, AssociationException {
        String handle = authSuccess.getHandle();
        Association assoc = null;
        try {
            assoc = OpenIDServerManager.getThreadLocalAssociation();
        }
        finally {
            OpenIDServerManager.clearThreadLocalAssociation();
        }
        if (assoc == null) {
            assoc = this.getSharedAssociations().load(handle);
        }
        if (assoc == null) {
            assoc = this.getPrivateAssociations().load(handle);
        }
        if (assoc == null) {
            throw new ServerException("No association found for handle: " + handle);
        }
        authSuccess.setSignature(assoc.sign(authSuccess.getSignedText()));
    }

    public Message verify(ParameterList requestParams) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing verification request...");
        }
        boolean isVersion2 = true;
        try {
            VerifyRequest vrfyReq = VerifyRequest.createVerifyRequest((ParameterList)requestParams);
            isVersion2 = vrfyReq.isVersion2();
            String handle = vrfyReq.getHandle();
            boolean verified = false;
            Association assoc = this.getPrivateAssociations().load(handle);
            String sigMod = null;
            if (assoc != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loaded private association; handle: " + handle));
                }
                sigMod = vrfyReq.getSignature().replaceAll("\\s", "+");
                verified = assoc.verifySignature(vrfyReq.getSignedText(), sigMod);
                this.getPrivateAssociations().remove(handle);
            } else {
                log.error((Object)("No association loaded from the database; handle: " + handle));
            }
            VerifyResponse vrfyResp = VerifyResponse.createVerifyResponse((!vrfyReq.isVersion2() ? 1 : 0) != 0);
            vrfyResp.setSignatureVerified(verified);
            if (verified) {
                String invalidateHandle = vrfyReq.getInvalidateHandle();
                if (invalidateHandle != null && this.getSharedAssociations().load(invalidateHandle) == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Shared association invalidated; handle: " + invalidateHandle));
                    }
                    vrfyResp.setInvalidateHandle(invalidateHandle);
                }
            } else {
                log.error((Object)("Signature verification failed. handle : " + handle + " , signed text : " + vrfyReq.getSignedText() + " , signature : " + sigMod));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Responding with " + (verified ? "positive" : "negative") + " verification response"));
            }
            return vrfyResp;
        }
        catch (OpenIDException e) {
            log.error((Object)"Error processing verification request; responding with verification error", (Throwable)e);
            return DirectError.createDirectError((OpenIDException)e, (!isVersion2 ? 1 : 0) != 0);
        }
    }

    static Association getThreadLocalAssociation() {
        Association association = threadLocalAssociation.get();
        threadLocalAssociation.remove();
        return association;
    }

    static void setThreadLocalAssociation(Association association) {
        threadLocalAssociation.set(association);
    }

    static void clearThreadLocalAssociation() {
        threadLocalAssociation.remove();
    }
}

