/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.Association;
import org.openid4java.association.AssociationException;
import org.openid4java.server.InMemoryServerAssociationStore;
import org.wso2.carbon.identity.provider.openid.cache.OpenIDAssociationCache;
import org.wso2.carbon.identity.provider.openid.dao.OpenIDAssociationDAO;

public class OpenIDServerAssociationStore
extends InMemoryServerAssociationStore {
    private static final Log log = LogFactory.getLog(OpenIDServerAssociationStore.class);
    private static final String SHA_1_PRNG = "SHA1PRNG";
    private int storeId = 0;
    private String timestamp;
    private int counter;
    private volatile OpenIDAssociationCache cache;
    private OpenIDAssociationDAO dao;

    public OpenIDServerAssociationStore(String associationsType) {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance(SHA_1_PRNG);
            this.storeId = secureRandom.nextInt(9999);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA1PRNG algorithm could not be found.", e);
        }
        this.timestamp = Long.toString(new Date().getTime());
        this.counter = 0;
        this.cache = OpenIDAssociationCache.getCacheInstance();
        this.dao = OpenIDAssociationDAO.getInstance(associationsType);
    }

    public Association generate(String type, int expiryIn) throws AssociationException {
        String handle = this.storeId + this.timestamp + "-" + this.getCounter();
        final Association association = Association.generate((String)type, (String)handle, (int)expiryIn);
        this.cache.addToCache(association);
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Storing association " + association.getHandle() + " in the database."));
                }
                OpenIDServerAssociationStore.this.dao.storeAssociation(association);
            }
        };
        thread.start();
        return association;
    }

    private synchronized int getCounter() {
        return this.counter++;
    }

    public Association load(String handle) {
        boolean chacheMiss = false;
        Association association = this.cache.getFromCache(handle);
        if (association == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Association " + handle + " not found in cache. Loading from the database."));
            }
            association = this.dao.loadAssociation(handle);
            chacheMiss = true;
        }
        if (association == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Association " + handle + " not found in the database."));
            }
            return null;
        }
        if (association.hasExpired()) {
            log.warn((Object)("Association is expired for handle " + handle));
            this.remove(handle);
            return null;
        }
        if (chacheMiss) {
            this.cache.addToCache(association);
        }
        return association;
    }

    public void remove(final String handle) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Removing the association" + handle + " from the database"));
                }
                OpenIDServerAssociationStore.this.dao.removeAssociation(handle);
            }
        };
        thread.start();
    }
}

