/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid;

import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.model.OpenIDRememberMeDO;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.provider.openid.cache.OpenIDRememberMeTokenCache;
import org.wso2.carbon.identity.provider.openid.dao.OpenIDRememberMeTokenDAO;

public class OpenIDRememberMeTokenManager {
    private static final Log log = LogFactory.getLog(OpenIDRememberMeTokenManager.class);
    private static OpenIDRememberMeTokenCache cache = OpenIDRememberMeTokenCache.getCacheInstance();
    private OpenIDRememberMeTokenDAO dao = new OpenIDRememberMeTokenDAO();

    public String getToken(OpenIDRememberMeDO rememberMe) throws IdentityProviderException {
        OpenIDRememberMeDO storedDo = cache.getTokenData(rememberMe);
        if (storedDo == null) {
            storedDo = this.dao.getTokenData(rememberMe);
            cache.updateTokenData(rememberMe);
        }
        if (storedDo == null) {
            log.debug((Object)("No rememberMe token found for " + rememberMe.getUserName()));
            return null;
        }
        if (!this.isExpired(storedDo)) {
            return storedDo.getToken();
        }
        return null;
    }

    private boolean isExpired(OpenIDRememberMeDO storedDo) {
        Timestamp timestamp = storedDo.getTimestamp();
        String expiry = IdentityUtil.getProperty((String)"OpenID.OpenIDRememberMeExpiry");
        if (timestamp != null && expiry != null) {
            long delta;
            long t0 = timestamp.getTime();
            long t1 = new Date().getTime();
            if (t1 - t0 > (delta = Long.parseLong(expiry) * 1000L * 60L)) {
                log.debug((Object)("Remember Me token expired for user " + storedDo.getUserName()));
                return true;
            }
        }
        return false;
    }

    public void updateToken(final OpenIDRememberMeDO rememberMe) throws IdentityProviderException {
        cache.updateTokenData(rememberMe);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    OpenIDRememberMeTokenManager.this.dao.updateTokenData(rememberMe);
                }
                catch (Exception e) {
                    log.error((Object)"Failed to update RememberMe token.", (Throwable)e);
                }
            }
        };
        thread.start();
    }
}

