/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.openid;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.server.ServerManager;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.openid.OpenIDServerManager;
import org.wso2.carbon.identity.provider.openid.OpenIDUtil;

public class OpenIDProvider {
    private static final Log log = LogFactory.getLog(OpenIDProvider.class);
    private static volatile OpenIDProvider provider;
    private ServerManager manager = new OpenIDServerManager();
    private String opAddress = OpenIDUtil.getOpenIDServerURL();

    private OpenIDProvider() {
        this.manager.setOPEndpointUrl(this.opAddress);
        int assocExpiryTime = 15;
        String expiryTime = IdentityUtil.getProperty((String)"OpenID.OpenIDAssociationExpiryTime");
        if (expiryTime != null && !expiryTime.trim().isEmpty()) {
            try {
                assocExpiryTime = Integer.parseInt(expiryTime);
            }
            catch (NumberFormatException e) {
                log.warn((Object)("Error while setting association expiry time as " + expiryTime + ". Setting association expiry time to default (" + assocExpiryTime + ")"), (Throwable)e);
            }
        }
        this.manager.setExpireIn(assocExpiryTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OpenIDProvider getInstance() {
        if (provider != null) return provider;
        Class<OpenIDProvider> clazz = OpenIDProvider.class;
        synchronized (OpenIDProvider.class) {
            if (provider != null) return provider;
            provider = new OpenIDProvider();
            // ** MonitorExit[var0] (shouldn't be in output)
            return provider;
        }
    }

    public String getOpAddress() {
        return this.opAddress;
    }

    public ServerManager getManager() {
        return this.manager;
    }
}

