/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.wso2.carbon.identity.provider.openid.OpenIDProviderServlet;
import org.wso2.carbon.identity.provider.openid.OpenIDUserServlet;

public class ServletContextListener
implements ServiceListener {
    private static final Log log = LogFactory.getLog(ServletContextListener.class);
    private BundleContext bundleContext;

    public ServletContextListener(BundleContext bc) {
        this.bundleContext = bc;
    }

    private static void registerServlets(BundleContext bundleContext) {
        Hashtable<String, String> dictionaryResourceParams = null;
        OpenIDUserServlet userServlet = null;
        OpenIDProviderServlet providerServlet = null;
        dictionaryResourceParams = new Hashtable<String, String>(1);
        ((Dictionary)dictionaryResourceParams).put("url-pattern", "/openid");
        userServlet = new OpenIDUserServlet();
        bundleContext.registerService(Servlet.class.getName(), (Object)userServlet, dictionaryResourceParams);
        dictionaryResourceParams = new Hashtable(1);
        ((Dictionary)dictionaryResourceParams).put("url-pattern", "/openidserver");
        providerServlet = new OpenIDProviderServlet();
        bundleContext.registerService(Servlet.class.getName(), (Object)providerServlet, dictionaryResourceParams);
    }

    public void serviceChanged(ServiceEvent event) {
        if (event.getType() == 1) {
            try {
                ServletContextListener.registerServlets(this.bundleContext);
            }
            catch (Exception e) {
                log.error((Object)"Failed to initialize the OpenID UI component", (Throwable)e);
            }
        }
    }
}

