/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider.internal;

import javax.servlet.ServletContext;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.application.mgt.ApplicationManagementService;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.identity.provider.internal.ServletContextListener;
import org.wso2.carbon.identity.provider.openid.listener.IdentityOpenIDUserEventListener;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.listener.UserOperationEventListener;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="identity.provider.component", immediate=true)
public class IdentityProviderServiceComponent {
    private static final Log log = LogFactory.getLog(IdentityProviderServiceComponent.class);
    private static ConfigurationContext configContext;
    private static RealmService realmService;
    private static RegistryService registryService;
    private static ServiceRegistration userEventServiceRegistration;
    private static ApplicationManagementService applicationManagementService;

    public static RealmService getRealmService() {
        return realmService;
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.info((Object)"ReleamService is set in Identity Provider Service Bundle");
        }
        IdentityProviderServiceComponent.realmService = realmService;
    }

    public static ConfigurationContext getConfigContext() {
        return configContext;
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    public static ApplicationManagementService getApplicationManagementService() {
        return applicationManagementService;
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        IdentityProviderServiceComponent.registryService = registryService;
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService set in Identity Provider bundle");
        }
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Provider bundle is activated");
        }
        try {
            IdentityOpenIDUserEventListener openIDUserListener = new IdentityOpenIDUserEventListener();
            userEventServiceRegistration = ctxt.getBundleContext().registerService(UserOperationEventListener.class.getName(), (Object)openIDUserListener, null);
            String filter = "(objectclass=" + ServletContext.class.getName() + ")";
            ctxt.getBundleContext().addServiceListener((ServiceListener)new ServletContextListener(ctxt.getBundleContext()), filter);
        }
        catch (Throwable e) {
            log.error((Object)"Failed to initialize Identity Provider", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        if (userEventServiceRegistration != null) {
            userEventServiceRegistration.unregister();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Identity Provider bundle is deactivated");
        }
    }

    protected void unsetRegistryService(RegistryService registryService) {
        IdentityProviderServiceComponent.registryService = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unset in Identity Provider bundle");
        }
    }

    @Reference(name="identity.application.management.component", service=ApplicationManagementService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetApplicationMgtService")
    protected void setApplicationMgtService(ApplicationManagementService applicationMgtService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ApplicationManagementService set in Identity Provider bundle");
        }
        applicationManagementService = applicationMgtService;
    }

    protected void unsetApplicationMgtService(ApplicationManagementService applicationMgtService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ApplicationManagementService unset in Identity Provider bundle");
        }
        applicationManagementService = null;
    }

    protected void unsetUserRealmDelegating(UserRealm userRealmDelegating) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DelegatingUserRealm set in Identity Provider bundle");
        }
    }

    protected void unsetUserRealmDefault(UserRealm userRealmDefault) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"DefaultUserRealm unset in Identity Provider bundle");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ReleamService is unset in Identity Provider Service Bundle");
        }
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService set in Identity Provider bundle");
        }
        configContext = contextService.getServerConfigContext();
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService unset in Identity Provider bundle");
        }
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }
}

