/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider;

import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import net.minidev.json.JSONArray;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openid4java.association.AssociationException;
import org.openid4java.message.AuthFailure;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.DirectError;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.server.RealmVerifier;
import org.openid4java.server.ServerException;
import org.openid4java.server.ServerManager;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.IdentityClaimManager;
import org.wso2.carbon.identity.core.dao.OpenIDUserRPDAO;
import org.wso2.carbon.identity.core.model.OpenIDRememberMeDO;
import org.wso2.carbon.identity.core.model.OpenIDUserRPDO;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.provider.dto.OpenIDAuthRequestDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDAuthResponseDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDClaimDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDParameterDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDProviderInfoDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDRememberMeDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDUserProfileDTO;
import org.wso2.carbon.identity.provider.dto.OpenIDUserRPDTO;
import org.wso2.carbon.identity.provider.openid.OpenIDProvider;
import org.wso2.carbon.identity.provider.openid.OpenIDRememberMeTokenManager;
import org.wso2.carbon.identity.provider.openid.OpenIDUtil;
import org.wso2.carbon.identity.provider.openid.extensions.OpenIDExtension;
import org.wso2.carbon.identity.provider.openid.handlers.OpenIDAuthenticationRequest;
import org.wso2.carbon.identity.provider.openid.handlers.OpenIDExtensionFactory;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.claim.Claim;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class OpenIDProviderService {
    private static final Log log = LogFactory.getLog(OpenIDProviderService.class);
    private String userAttributeSeparator = ",,,";

    public static int getOpenIDSessionTimeout() {
        if (StringUtils.isNotBlank((String)IdentityUtil.getProperty((String)"OpenID.SessionTimeout"))) {
            return Integer.parseInt(IdentityUtil.getProperty((String)"OpenID.SessionTimeout").trim());
        }
        return 36000;
    }

    public boolean authenticateWithOpenID(String openID, String password) throws IdentityProviderException {
        HttpServletRequest request;
        HttpSession httpSession;
        MessageContext msgContext;
        String userName = null;
        try {
            userName = OpenIDUtil.getUserName(openID);
        }
        catch (MalformedURLException e) {
            throw new IdentityProviderException("Failed to get username from OpenID " + openID, e);
        }
        String domainName = MultitenantUtils.getDomainNameFromOpenId((String)openID);
        String tenantUser = MultitenantUtils.getTenantAwareUsername((String)userName);
        boolean isAuthenticated = false;
        try {
            isAuthenticated = IdentityTenantUtil.getRealm((String)domainName, (String)userName).getUserStoreManager().authenticate(tenantUser, (Object)password);
        }
        catch (IdentityException | UserStoreException e) {
            throw new IdentityProviderException("Error while authenticating with OpenID " + openID, e);
        }
        if (isAuthenticated && (msgContext = MessageContext.getCurrentMessageContext()) != null && (httpSession = (request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)).getSession(false)) != null) {
            httpSession.setAttribute("OPENID_LOGGEDIN_USER", (Object)userName);
        }
        return isAuthenticated;
    }

    public OpenIDRememberMeDTO authenticateWithOpenIDRememberMe(String openID, String password, String ipaddress, String cookie) throws Exception {
        String userName = OpenIDUtil.getUserName(openID);
        boolean isAutheticated = false;
        String hmac = null;
        OpenIDRememberMeDTO dto = new OpenIDRememberMeDTO();
        dto.setAuthenticated(false);
        if (password != null && password.trim().length() > 0 ? !(isAutheticated = this.authenticateWithOpenID(openID, password)) : cookie == null || "null".equals(cookie) || ipaddress == null) {
            return dto;
        }
        OpenIDRememberMeDO rememberMe = new OpenIDRememberMeDO();
        rememberMe.setOpenID(openID);
        rememberMe.setUserName(userName);
        OpenIDRememberMeTokenManager tokenManager = new OpenIDRememberMeTokenManager();
        String token = null;
        if (ipaddress != null) {
            HttpServletRequest request;
            HttpSession httpSession;
            if (cookie != null && !"null".equals(cookie)) {
                hmac = IdentityUtil.getHMAC((String)ipaddress, (String)cookie);
                token = tokenManager.getToken(rememberMe);
                if (!(isAutheticated || token != null && token.equals(hmac))) {
                    return dto;
                }
            } else if (!isAutheticated) {
                return dto;
            }
            cookie = IdentityUtil.generateUUID();
            hmac = IdentityUtil.getHMAC((String)ipaddress, (String)cookie);
            rememberMe.setToken(hmac);
            tokenManager.updateToken(rememberMe);
            dto.setNewCookieValue(cookie);
            dto.setAuthenticated(true);
            MessageContext msgContext = MessageContext.getCurrentMessageContext();
            if (msgContext != null && (httpSession = (request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)).getSession(false)) != null) {
                httpSession.setAttribute("OPENID_LOGGEDIN_USER", (Object)userName);
            }
            return dto;
        }
        return dto;
    }

    public OpenIDRememberMeDTO authenticateWithRememberMeCookie(String openID, String ipaddress, String cookie) throws Exception {
        HttpServletRequest request;
        HttpSession httpSession;
        String userName = OpenIDUtil.getUserName(openID);
        boolean isAutheticated = false;
        String hmac = null;
        OpenIDRememberMeDTO dto = new OpenIDRememberMeDTO();
        dto.setAuthenticated(false);
        if (cookie == null || "null".equals(cookie) || ipaddress == null) {
            return dto;
        }
        OpenIDRememberMeDO rememberMe = new OpenIDRememberMeDO();
        rememberMe.setOpenID(openID);
        rememberMe.setUserName(userName);
        OpenIDRememberMeTokenManager tokenManager = new OpenIDRememberMeTokenManager();
        String token = null;
        hmac = IdentityUtil.getHMAC((String)ipaddress, (String)cookie);
        token = tokenManager.getToken(rememberMe);
        if (!(isAutheticated || token != null && token.equals(hmac))) {
            return dto;
        }
        cookie = IdentityUtil.generateUUID();
        hmac = IdentityUtil.getHMAC((String)ipaddress, (String)cookie);
        rememberMe.setToken(hmac);
        tokenManager.updateToken(rememberMe);
        dto.setNewCookieValue(cookie);
        dto.setAuthenticated(true);
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        if (msgContext != null && (httpSession = (request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)).getSession(false)) != null) {
            httpSession.setAttribute("OPENID_LOGGEDIN_USER", (Object)userName);
        }
        return dto;
    }

    public OpenIDRememberMeDTO handleRememberMe(String openID, String ipaddress) throws Exception {
        String userName = OpenIDUtil.getUserName(openID);
        String hmac = null;
        OpenIDRememberMeDTO dto = new OpenIDRememberMeDTO();
        dto.setAuthenticated(false);
        String cookie = null;
        OpenIDRememberMeDO rememberMe = new OpenIDRememberMeDO();
        rememberMe.setOpenID(openID);
        rememberMe.setUserName(userName);
        OpenIDRememberMeTokenManager tokenManager = new OpenIDRememberMeTokenManager();
        if (ipaddress != null) {
            HttpServletRequest request;
            HttpSession httpSession;
            cookie = IdentityUtil.generateUUID();
            hmac = IdentityUtil.getHMAC((String)ipaddress, (String)cookie);
            rememberMe.setToken(hmac);
            tokenManager.updateToken(rememberMe);
            dto.setNewCookieValue(cookie);
            dto.setAuthenticated(true);
            MessageContext msgContext = MessageContext.getCurrentMessageContext();
            if (msgContext != null && (httpSession = (request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST)).getSession(false)) != null) {
                httpSession.setAttribute("OPENID_LOGGEDIN_USER", (Object)userName);
            }
        }
        return dto;
    }

    public OpenIDProviderInfoDTO getOpenIDProviderInfo(String userName, String openid) throws IdentityProviderException {
        UserRealm realm;
        String domain;
        OpenIDProviderInfoDTO providerInfo;
        block3: {
            providerInfo = new OpenIDProviderInfoDTO();
            domain = null;
            realm = null;
            try {
                domain = MultitenantUtils.getDomainNameFromOpenId((String)openid);
                realm = IdentityTenantUtil.getRealm((String)domain, (String)userName);
            }
            catch (IdentityException e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Ignoring IdentityException", (Throwable)e);
            }
        }
        if (realm == null) {
            return providerInfo;
        }
        providerInfo.setSubDomain(domain);
        String tenantFreeUsername = MultitenantUtils.getTenantAwareUsername((String)userName);
        providerInfo.setOpenIDProviderServerUrl(OpenIDUtil.getOpenIDServerURL());
        providerInfo.setOpenID(OpenIDUtil.getOpenIDUserPattern() + "/" + tenantFreeUsername);
        return providerInfo;
    }

    public OpenIDClaimDTO[] getClaimValues(String openId, String profileId, OpenIDParameterDTO[] requredClaims) throws IdentityProviderException {
        List<String> claimList = null;
        ParameterList paramList = null;
        AuthRequest authReq = null;
        String message = "Invalid parameters provided to getClaimValues";
        this.validateInputParameters(new String[]{openId, profileId}, message);
        try {
            this.checkUserAuthorization(OpenIDUtil.getUserName(openId), "getClaimValues");
        }
        catch (MalformedURLException e) {
            throw new IdentityProviderException("Failed to get username from OpenID " + openId, e);
        }
        paramList = this.getParameterList(requredClaims);
        try {
            authReq = AuthRequest.createAuthRequest((ParameterList)paramList, (RealmVerifier)OpenIDProvider.getInstance().getManager().getRealmVerifier());
            claimList = this.getRequestedAttributes(authReq);
        }
        catch (MessageException | IdentityException e) {
            throw new IdentityProviderException("Failed to get requested attribute set", e);
        }
        return this.getOpenIDClaimValues(openId, profileId, claimList);
    }

    public String getOpenIDAssociationResponse(OpenIDParameterDTO[] params) {
        Message message = null;
        ParameterList paramList = null;
        paramList = this.getParameterList(params);
        message = OpenIDProvider.getInstance().getManager().associationResponse(paramList);
        return message.keyValueFormEncoding();
    }

    public String verify(OpenIDParameterDTO[] params) throws IdentityProviderException {
        String disableDumbMode = IdentityUtil.getProperty((String)"OpenID.DisableOpenIDDumbMode");
        if ("true".equalsIgnoreCase(disableDumbMode)) {
            throw new IdentityProviderException("OpenID relying parties with dumb mode not supported");
        }
        ParameterList paramList = this.getParameterList(params);
        Message message = OpenIDProvider.getInstance().getManager().verify(paramList);
        return message.keyValueFormEncoding();
    }

    public OpenIDAuthResponseDTO getOpenIDAuthResponse(OpenIDAuthRequestDTO requestDTO) throws IdentityProviderException {
        ParameterList paramList = null;
        Message message = null;
        paramList = this.getParameterList(requestDTO.getParams());
        String destinationUrl = null;
        AuthRequest authReq = null;
        ServerManager manager = null;
        OpenIDAuthResponseDTO response = null;
        response = new OpenIDAuthResponseDTO();
        manager = OpenIDProvider.getInstance().getManager();
        try {
            authReq = AuthRequest.createAuthRequest((ParameterList)paramList, (RealmVerifier)manager.getRealmVerifier());
        }
        catch (MessageException e) {
            throw new IdentityProviderException("Error while creating authentication request", e);
        }
        message = manager.authResponse(paramList, requestDTO.getOpLocalId(), requestDTO.getUserSelectedClaimedId(), requestDTO.isAuthenticated());
        if (message instanceof DirectError || message instanceof AuthFailure) {
            destinationUrl = message.getDestinationUrl(true);
            response.setDestinationUrl(destinationUrl);
            response.setValidated(false);
        } else {
            OpenIDExtension extension = null;
            OpenIDAuthenticationRequest req = null;
            req = new OpenIDAuthenticationRequest();
            if (requestDTO.isPhishiingResistanceAuthRequest()) {
                req.setPhishingResistanceLogin(true);
            }
            if (requestDTO.isMultiFactorAuthRequested()) {
                req.setMultifactorLogin(true);
            }
            req.setAuthRequest(authReq);
            try {
                for (Object alias : authReq.getExtensions()) {
                    req.setExtensionAlias((String)alias);
                    extension = OpenIDExtensionFactory.getInstance().getExtension(req);
                    if (extension == null) continue;
                    MessageExtension messageExtension = null;
                    messageExtension = extension.getMessageExtension(requestDTO.getOpenID(), requestDTO.getProfileName(), requestDTO);
                    if (messageExtension == null) continue;
                    message.addExtension(messageExtension);
                    AuthSuccess authSuccess = (AuthSuccess)message;
                    authSuccess.addSignExtension((String)alias);
                    manager.sign(authSuccess);
                }
            }
            catch (AssociationException | MessageException | ServerException | IdentityException e) {
                throw new IdentityProviderException("Error while creating authentication request", e);
            }
            destinationUrl = message.getDestinationUrl(true);
            response.setDestinationUrl(destinationUrl);
            response.setValidated(true);
        }
        return response;
    }

    private List<String> getRequestedAttributes(AuthRequest authRequest) throws IdentityException {
        OpenIDAuthenticationRequest req = null;
        OpenIDExtension extension = null;
        ArrayList<String> requiredAttributes = null;
        req = new OpenIDAuthenticationRequest();
        req.setAuthRequest(authRequest);
        requiredAttributes = new ArrayList<String>();
        for (Object alias : authRequest.getExtensions()) {
            req.setExtensionAlias((String)alias);
            extension = OpenIDExtensionFactory.getInstance().getExtension(req);
            if (extension == null) continue;
            extension.addRequiredAttributes(requiredAttributes);
        }
        return requiredAttributes;
    }

    private ParameterList getParameterList(OpenIDParameterDTO[] params) {
        ParameterList paramList = null;
        HashMap<String, String> paramMap = null;
        paramMap = new HashMap<String, String>();
        for (OpenIDParameterDTO param : params) {
            paramMap.put(param.getName(), param.getValue());
        }
        paramList = new ParameterList(paramMap);
        return paramList;
    }

    public OpenIDUserProfileDTO[] getUserProfiles(String openId, OpenIDParameterDTO[] requredClaims) throws IdentityProviderException {
        String userName = null;
        UserRealm realm = null;
        UserStoreManager reader = null;
        String tenatUser = null;
        String domainName = null;
        try {
            userName = OpenIDUtil.getUserName(openId);
            tenatUser = MultitenantUtils.getTenantAwareUsername((String)userName);
            domainName = MultitenantUtils.getDomainNameFromOpenId((String)openId);
            realm = IdentityTenantUtil.getRealm((String)domainName, (String)userName);
            reader = realm.getUserStoreManager();
            String[] profileNames = reader.getProfileNames(tenatUser);
            OpenIDUserProfileDTO[] profileDtoSet = new OpenIDUserProfileDTO[profileNames.length];
            List<String> claimList = null;
            ParameterList paramList = this.getParameterList(requredClaims);
            AuthRequest authReq = AuthRequest.createAuthRequest((ParameterList)paramList, (RealmVerifier)OpenIDProvider.getInstance().getManager().getRealmVerifier());
            claimList = this.getRequestedAttributes(authReq);
            for (int i = 0; i < profileNames.length; ++i) {
                OpenIDUserProfileDTO profileDTO = new OpenIDUserProfileDTO();
                OpenIDClaimDTO[] claimSet = this.getOpenIDClaimValues(openId, profileNames[i], claimList);
                profileDTO.setProfileName(profileNames[i]);
                profileDTO.setClaimSet(claimSet);
                profileDtoSet[i] = profileDTO;
            }
            return profileDtoSet;
        }
        catch (MalformedURLException | MessageException | IdentityException | UserStoreException e) {
            throw new IdentityProviderException("Error while retrieving user profiles", e);
        }
    }

    public void updateOpenIDUserRPInfo(OpenIDUserRPDTO rpdto) throws IdentityProviderException {
        String userName = null;
        try {
            userName = OpenIDUtil.getUserName(rpdto.getOpenID());
        }
        catch (MalformedURLException e) {
            throw new IdentityProviderException("Failed to get username from OpenID " + rpdto.getOpenID(), e);
        }
        String domainName = MultitenantUtils.getDomainNameFromOpenId((String)rpdto.getOpenID());
        int tenantId = IdentityTenantUtil.getTenantId((String)domainName);
        OpenIDUserRPDO rpdo = new OpenIDUserRPDO();
        OpenIDUserRPDAO dao = new OpenIDUserRPDAO();
        try {
            rpdo.setUserName(userName);
            rpdo.setRpUrl(rpdto.getRpUrl());
            rpdo.setTrustedAlways(rpdto.isTrustedAlways());
            rpdo.setDefaultProfileName(rpdto.getDefaultProfileName());
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            byte[] digest = sha.digest((userName + ":" + rpdto.getRpUrl()).getBytes());
            rpdo.setUuid(new String(Hex.encodeHex((byte[])digest)));
            dao.createOrUpdate(rpdo, tenantId);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IdentityProviderException("Error while updating DAO for " + domainName, e);
        }
    }

    public OpenIDUserRPDTO[] getOpenIDUserRPs(String openID) throws IdentityProviderException {
        String username = null;
        try {
            username = OpenIDUtil.getUserName(openID);
        }
        catch (MalformedURLException e) {
            throw new IdentityProviderException("Error while getting username for OpenID " + username, e);
        }
        String domainName = MultitenantUtils.getDomainNameFromOpenId((String)openID);
        int tenantId = IdentityTenantUtil.getTenantId((String)domainName);
        OpenIDUserRPDO[] rpdos = null;
        OpenIDUserRPDAO dao = new OpenIDUserRPDAO();
        rpdos = dao.getOpenIDUserRPs(username, tenantId);
        if (rpdos == null) {
            return new OpenIDUserRPDTO[0];
        }
        OpenIDUserRPDTO[] rpdto = new OpenIDUserRPDTO[rpdos.length];
        int i = 0;
        for (OpenIDUserRPDO rpdo : rpdos) {
            rpdto[i] = new OpenIDUserRPDTO(rpdo);
            ++i;
        }
        return rpdto;
    }

    public OpenIDUserRPDTO getOpenIDUserRPInfo(String openID, String rpUrl) throws IdentityProviderException {
        String userName = null;
        try {
            userName = OpenIDUtil.getUserName(openID);
        }
        catch (MalformedURLException e) {
            throw new IdentityProviderException("Failed to get username from OpenID " + openID, e);
        }
        String domainName = MultitenantUtils.getTenantDomain((String)userName);
        int tenantId = IdentityTenantUtil.getTenantId((String)domainName);
        OpenIDUserRPDO rpdo = null;
        OpenIDUserRPDAO dao = new OpenIDUserRPDAO();
        rpdo = dao.getOpenIDUserRP(userName, rpUrl, tenantId);
        if (rpdo == null) {
            return null;
        }
        return new OpenIDUserRPDTO(rpdo);
    }

    public boolean isOpenIDUserApprovalBypassEnabled() {
        return Boolean.parseBoolean(IdentityUtil.getProperty((String)"OpenID.OpenIDSkipUserConsent"));
    }

    private OpenIDClaimDTO[] getOpenIDClaimValues(String openId, String profileId, List<String> claimList) throws IdentityProviderException {
        UserStoreManager userStore = null;
        Map claimValues = null;
        OpenIDClaimDTO[] claims = null;
        OpenIDClaimDTO dto = null;
        IdentityClaimManager claimManager = null;
        Claim[] claimData = null;
        String[] claimArray = new String[claimList.size()];
        String userName = null;
        String domainName = null;
        UserRealm realm = null;
        try {
            userName = OpenIDUtil.getUserName(openId);
        }
        catch (MalformedURLException e) {
            throw new IdentityProviderException("Failed to get username from OpenID " + openId, e);
        }
        domainName = MultitenantUtils.getDomainNameFromOpenId((String)openId);
        String tenantUser = MultitenantUtils.getTenantAwareUsername((String)userName);
        try {
            realm = IdentityTenantUtil.getRealm((String)domainName, (String)userName);
            userStore = realm.getUserStoreManager();
            claimValues = userStore.getUserClaimValues(tenantUser, claimList.toArray(claimArray), profileId);
        }
        catch (IdentityException | UserStoreException e) {
            throw new IdentityProviderException("Failed to get claims of user " + tenantUser, e);
        }
        String claimSeparator = (String)claimValues.get("MultiAttributeSeparator");
        if (StringUtils.isNotBlank((String)claimSeparator)) {
            this.userAttributeSeparator = claimSeparator;
        }
        claimValues.remove("MultiAttributeSeparator");
        int i = 0;
        claims = new OpenIDClaimDTO[claimValues.size()];
        try {
            claimManager = IdentityClaimManager.getInstance();
            claimData = claimManager.getAllSupportedClaims(realm);
        }
        catch (IdentityException e) {
            throw new IdentityProviderException("Failed load all supported claims", e);
        }
        for (Claim element : claimData) {
            if (!claimValues.containsKey(element.getClaimUri())) continue;
            dto = new OpenIDClaimDTO();
            JSONArray values = new JSONArray();
            dto.setClaimUri(element.getClaimUri());
            String value = (String)claimValues.get(element.getClaimUri());
            if (this.userAttributeSeparator != null && value.contains(this.userAttributeSeparator)) {
                StringTokenizer st = new StringTokenizer(value, this.userAttributeSeparator);
                while (st.hasMoreElements()) {
                    String attValue = st.nextElement().toString();
                    if (!StringUtils.isNotBlank((String)attValue)) continue;
                    values.add((Object)attValue);
                }
            } else {
                values.add((Object)value);
            }
            dto.setClaimValue(values.toJSONString());
            dto.setDisplayTag(element.getDisplayTag());
            dto.setDescription(element.getDescription());
            claims[i++] = dto;
        }
        return claims;
    }

    private void checkUserAuthorization(String username, String operation) throws IdentityProviderException {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        if (httpSession != null) {
            String userName = (String)httpSession.getAttribute("OPENID_LOGGEDIN_USER");
            if (!username.equals(userName)) {
                throw new IdentityProviderException("Unauthorised action by user " + username + " to access " + operation);
            }
            return;
        }
        throw new IdentityProviderException("Unauthorised action by user " + username + " to access " + operation);
    }

    private void validateInputParameters(String[] params, String message) {
        for (String param : params) {
            if (param != null && param.trim().length() != 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new IllegalArgumentException(message);
        }
    }
}

