/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.provider;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.core.util.AdminServicesUtil;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.persistence.IdentityPersistenceManager;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.provider.IdentityProviderException;
import org.wso2.carbon.identity.provider.openid.OpenIDUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class IdentityProviderService
extends AbstractAdmin {
    private static final Log log = LogFactory.getLog(IdentityProviderService.class);

    public String getPrimaryOpenID(String userName) throws IdentityProviderException {
        String userNameWithDomain = this.getUserNameWithDomain(userName);
        this.validateInputParameters(new String[]{userNameWithDomain}, "Invalid parameters provided to getOpenID");
        this.checkUserAuthorization(userNameWithDomain, "getOpenID");
        return OpenIDUtil.getOpenIDUserPattern() + "/" + userNameWithDomain;
    }

    public String[] getAllOpenIDs(String userName) throws IdentityProviderException {
        this.validateInputParameters(new String[]{userName}, "Invalid parameters provided to getAllOpenIDs");
        IdentityPersistenceManager persistenceManager = null;
        String[] externalOpenIDs = null;
        try {
            persistenceManager = IdentityPersistenceManager.getPersistanceManager();
            externalOpenIDs = persistenceManager.getOpenIDsForUser(IdentityTenantUtil.getRegistry(), AdminServicesUtil.getUserRealm(), userName);
        }
        catch (CarbonException | IdentityException e) {
            throw new IdentityProviderException("Failed to retrieve OpenID for user " + userName, e);
        }
        String[] openIDset = new String[externalOpenIDs.length + 1];
        openIDset[0] = this.getPrimaryOpenID(userName);
        for (int i = 0; i < externalOpenIDs.length; ++i) {
            openIDset[i + 1] = externalOpenIDs[i];
        }
        return openIDset;
    }

    public void removeOpenID(String openID) {
        try {
            IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
            persistenceManager.removeOpenIDSignUp(IdentityTenantUtil.getRegistry(), AdminServicesUtil.getUserRealm(), openID);
        }
        catch (Exception e) {
            log.error((Object)"Error instantiating a Persistence Manager.", (Throwable)e);
        }
    }

    public void addOpenID(String openID) {
        try {
            IdentityPersistenceManager persistenceManager = IdentityPersistenceManager.getPersistanceManager();
            String userName = CarbonContext.getThreadLocalCarbonContext().getUsername();
            persistenceManager.doOpenIdSignUp(IdentityTenantUtil.getRegistry(), AdminServicesUtil.getUserRealm(), openID, userName);
        }
        catch (Exception e) {
            log.error((Object)"Error instantiating a Persistence Manager.", (Throwable)e);
        }
    }

    public String extractPrimaryUserName(String ppid) throws Exception {
        return IdentityUtil.getPPIDDisplayValue((String)ppid);
    }

    private void checkUserAuthorization(String username, String operation) throws IdentityProviderException {
        MessageContext msgContext = MessageContext.getCurrentMessageContext();
        HttpServletRequest request = (HttpServletRequest)msgContext.getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        HttpSession httpSession = request.getSession(false);
        String tenantFreeUsername = MultitenantUtils.getTenantAwareUsername((String)username);
        if (httpSession != null) {
            String loggedInUsername = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
            if (!tenantFreeUsername.equals(loggedInUsername)) {
                throw new IdentityProviderException("Unauthorised action by user " + username + " to access " + operation);
            }
        } else {
            throw new IdentityProviderException("Unauthorised action by user " + tenantFreeUsername + " to access " + operation);
        }
    }

    private void validateInputParameters(String[] params, String message) {
        for (int i = 0; i < params.length; ++i) {
            if (params[i] != null && params[i].trim().length() != 0) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)message);
            }
            throw new IllegalArgumentException(message);
        }
    }

    private String getUserNameWithDomain(String userName) {
        String usernameWithDomain = StringUtils.isBlank((String)userName) ? CarbonContext.getThreadLocalCarbonContext().getUsername() : userName;
        if (MultitenantUtils.getTenantDomain((String)usernameWithDomain) == null && CarbonContext.getThreadLocalCarbonContext().getTenantDomain() != null) {
            usernameWithDomain = usernameWithDomain + "@" + CarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        }
        return usernameWithDomain;
    }
}

