/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.log4j2.plugins;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.wso2.carbon.context.CarbonContext;

@Plugin(name="TenantIdConverter", category="Converter")
@ConverterKeys(value={"tenantId"})
public class TenantIdConverter
extends LogEventPatternConverter {
    private static final TenantIdConverter INSTANCE = new TenantIdConverter();

    private TenantIdConverter() {
        super("tenantId", "tenantId");
    }

    public static TenantIdConverter newInstance(String[] options) {
        return INSTANCE;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        if (this.getTenantID() != null) {
            toAppendTo.append(this.getTenantID());
        }
    }

    public String getTenantID() {
        String tenantId = String.valueOf(AccessController.doPrivileged(new PrivilegedAction<Integer>(){

            @Override
            public Integer run() {
                return CarbonContext.getThreadLocalCarbonContext().getTenantId();
            }
        }));
        return tenantId;
    }
}

