/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.log4j2.plugins;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.wso2.carbon.utils.CarbonUtils;

@Plugin(name="LogMaskConverter", category="Converter")
@ConverterKeys(value={"mm"})
public class LogMaskConverter
extends LogEventPatternConverter {
    private static final LogMaskConverter INSTANCE = new LogMaskConverter();
    private static final String DEFAULT_MASKING_PATTERNS_FILE_NAME = "wso2-log-masking.properties";
    private static final String REPLACEMENT_STRING = "*****";
    private final List<Pattern> logMaskingPatterns = new ArrayList<Pattern>();

    public static LogMaskConverter newInstance(String[] options) {
        return INSTANCE;
    }

    protected LogMaskConverter() {
        super("mm", "mm");
        this.loadMaskingPatterns();
    }

    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        String message = logEvent.getMessage().getFormat();
        if (!this.logMaskingPatterns.isEmpty()) {
            for (Pattern pattern : this.logMaskingPatterns) {
                Matcher matcher = pattern.matcher(message);
                StringBuffer stringBuffer = new StringBuffer();
                while (matcher.find()) {
                    matcher.appendReplacement(stringBuffer, REPLACEMENT_STRING);
                }
                matcher.appendTail(stringBuffer);
                message = stringBuffer.toString();
            }
        }
        stringBuilder.append(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMaskingPatterns() {
        String defaultFile = CarbonUtils.getCarbonConfigDirPath() + File.separatorChar + DEFAULT_MASKING_PATTERNS_FILE_NAME;
        Properties properties = new Properties();
        InputStream propsStream = null;
        try {
            if (Files.exists(Paths.get(defaultFile, new String[0]), new LinkOption[0])) {
                propsStream = new FileInputStream(defaultFile);
            }
            properties.load(propsStream);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                Pattern maskingPattern = Pattern.compile((String)entry.getValue());
                this.logMaskingPatterns.add(maskingPattern);
            }
        }
        catch (IOException e) {
            System.err.println("Error loading the masking patterns, due to : " + e.getMessage());
        }
        finally {
            if (propsStream != null) {
                try {
                    propsStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

