/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.log4j2.plugins;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.pattern.ConverterKeys;
import org.apache.logging.log4j.core.pattern.LogEventPatternConverter;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.utils.logging.handler.TenantDomainSetter;

@Plugin(name="AppNameConverter", category="Converter")
@ConverterKeys(value={"appName"})
public class AppNameConverter
extends LogEventPatternConverter {
    private static final AppNameConverter INSTANCE = new AppNameConverter();

    private AppNameConverter() {
        super("appName", "appName");
    }

    public static AppNameConverter newInstance(String[] options) {
        return INSTANCE;
    }

    public void format(LogEvent event, StringBuilder toAppendTo) {
        if (this.getAppName() != null) {
            toAppendTo.append(this.getAppName());
        }
    }

    private String getAppName() {
        String appName = CarbonContext.getThreadLocalCarbonContext().getApplicationName();
        if (appName == null) {
            appName = TenantDomainSetter.getServiceName();
        }
        return appName;
    }
}

