/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.cert.Certificate;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.httpclient.conn.util.InetAddressUtils;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ControllerThreadSocketFactory;
import org.apache.commons.httpclient.protocol.ReflectionSocketFactory;
import org.apache.commons.httpclient.protocol.SecureProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SSLProtocolSocketFactory
implements SecureProtocolSocketFactory {
    private static final SSLProtocolSocketFactory factory = new SSLProtocolSocketFactory();
    private static String hostNameVerifier;
    private static final Log LOG;
    private static final String[] BAD_COUNTRY_2LDS;
    private static final String[] LOCALHOSTS;

    static SSLProtocolSocketFactory getSocketFactory() {
        return factory;
    }

    public SSLProtocolSocketFactory() {
        String hostNameVerifier = System.getProperty("httpclient.hostnameVerifier");
        if (hostNameVerifier != null) {
            SSLProtocolSocketFactory.hostNameVerifier = hostNameVerifier;
        }
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException {
        Socket sslSocket = SSLSocketFactory.getDefault().createSocket(host, port, clientHost, clientPort);
        SSLProtocolSocketFactory.verifyHostName(host, (SSLSocket)sslSocket, hostNameVerifier);
        return sslSocket;
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            Socket sslSocket = SSLSocketFactory.getDefault().createSocket(host, port, localAddress, localPort);
            sslSocket.setSoTimeout(params.getSoTimeout());
            SSLProtocolSocketFactory.verifyHostName(host, (SSLSocket)sslSocket, hostNameVerifier);
            return sslSocket;
        }
        Socket sslSocket = ReflectionSocketFactory.createSocket("javax.net.ssl.SSLSocketFactory", host, port, localAddress, localPort, timeout);
        if (sslSocket == null) {
            sslSocket = ControllerThreadSocketFactory.createSocket(this, host, port, localAddress, localPort, timeout);
        }
        sslSocket.setSoTimeout(params.getSoTimeout());
        SSLProtocolSocketFactory.verifyHostName(host, (SSLSocket)sslSocket, hostNameVerifier);
        return sslSocket;
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        Socket sslSocket = SSLSocketFactory.getDefault().createSocket(host, port);
        SSLProtocolSocketFactory.verifyHostName(host, (SSLSocket)sslSocket, hostNameVerifier);
        return sslSocket;
    }

    @Override
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        Socket sslSocket = ((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(socket, host, port, autoClose);
        SSLProtocolSocketFactory.verifyHostName(host, (SSLSocket)sslSocket, hostNameVerifier);
        return sslSocket;
    }

    private static void verifyHostName(String host, SSLSocket ssl, String hostNameVerifier) throws IOException {
        if (host == null) {
            throw new IllegalArgumentException("host to verify was null");
        }
        SSLSession session = ssl.getSession();
        if (session == null) {
            InputStream in = ssl.getInputStream();
            in.available();
            session = ssl.getSession();
            if (session == null) {
                ssl.startHandshake();
                session = ssl.getSession();
            }
        }
        Certificate[] certs = session.getPeerCertificates();
        SSLProtocolSocketFactory.verifyHostName(host.trim().toLowerCase(Locale.US), (X509Certificate)certs[0], hostNameVerifier);
    }

    private static void verifyHostName(String host, X509Certificate cert, String hostNameVerifier) throws SSLException {
        String cn = SSLProtocolSocketFactory.getCN(cert);
        String[] subjectAlts = SSLProtocolSocketFactory.getDNSSubjectAlts(cert);
        if ("Strict".equals(hostNameVerifier)) {
            SSLProtocolSocketFactory.verifyHostName(host, cn, subjectAlts, true);
        } else {
            if ("AllowAll".equals(hostNameVerifier)) {
                return;
            }
            if ("DefaultAndLocalhost".equals(hostNameVerifier)) {
                if (SSLProtocolSocketFactory.isLocalhost(host)) {
                    return;
                }
                SSLProtocolSocketFactory.verifyHostName(host, cn, subjectAlts, false);
            } else {
                SSLProtocolSocketFactory.verifyHostName(host, cn, subjectAlts, false);
            }
        }
    }

    static boolean isLocalhost(String host) {
        int x;
        String string = host = host != null ? host.trim().toLowerCase() : "";
        if (host.startsWith("::1") && (x = host.lastIndexOf(37)) >= 0) {
            host = host.substring(0, x);
        }
        return (x = Arrays.binarySearch(LOCALHOSTS, host)) >= 0;
    }

    private static String[] getDNSSubjectAlts(X509Certificate cert) {
        LinkedList<String> subjectAltList = new LinkedList<String>();
        Collection<List<?>> c = null;
        try {
            c = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException cpe) {
            cpe.printStackTrace();
        }
        if (c != null) {
            for (List<?> list : c) {
                int type = (Integer)list.get(0);
                if (type != 2) continue;
                String s = (String)list.get(1);
                subjectAltList.add(s);
            }
        }
        if (!subjectAltList.isEmpty()) {
            String[] subjectAlts = new String[subjectAltList.size()];
            subjectAltList.toArray(subjectAlts);
            return subjectAlts;
        }
        return new String[0];
    }

    private static void verifyHostName(String host, String cn, String[] subjectAlts, boolean strictWithSubDomains) throws SSLException {
        LinkedList<String> names = new LinkedList<String>();
        if (cn != null) {
            names.add(cn);
        }
        if (subjectAlts != null) {
            for (String subjectAlt : subjectAlts) {
                if (subjectAlt == null) continue;
                names.add(subjectAlt);
            }
        }
        if (names.isEmpty()) {
            String msg = "Certificate for <" + host + "> doesn't contain CN or DNS subjectAlt";
            throw new SSLException(msg);
        }
        StringBuilder buf = new StringBuilder();
        String hostName = SSLProtocolSocketFactory.normaliseIPv6Address(host.trim().toLowerCase(Locale.US));
        boolean match = false;
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String[] parts;
            boolean doWildCard;
            String commonName = (String)it.next();
            commonName = commonName.toLowerCase(Locale.US);
            buf.append(" <");
            buf.append(commonName);
            buf.append('>');
            if (it.hasNext()) {
                buf.append(" OR");
            }
            boolean bl = doWildCard = (parts = commonName.split("\\.")).length >= 3 && parts[0].endsWith("*") && SSLProtocolSocketFactory.validCountryWildcard(parts) && !InetAddressUtils.isValidIPAddress(host);
            if (doWildCard) {
                String firstPart = parts[0];
                if (firstPart.length() > 1) {
                    String prefix = firstPart.substring(0, firstPart.length() - 1);
                    String suffix = commonName.substring(firstPart.length());
                    match = hostName.startsWith(prefix) && hostName.endsWith(suffix);
                } else {
                    match = hostName.endsWith(commonName.substring(1));
                }
                if (match && strictWithSubDomains) {
                    match = SSLProtocolSocketFactory.countDots(hostName) == SSLProtocolSocketFactory.countDots(commonName);
                }
            } else {
                match = hostName.equals(SSLProtocolSocketFactory.normaliseIPv6Address(commonName));
            }
            if (!match) continue;
            break;
        }
        if (!match) {
            throw new SSLException("hostname in certificate didn't match: <" + host + "> !=" + buf);
        }
    }

    static boolean validCountryWildcard(String[] parts) {
        if (parts.length != 3 || parts[2].length() != 2) {
            return true;
        }
        return Arrays.binarySearch(BAD_COUNTRY_2LDS, parts[1]) < 0;
    }

    private static String normaliseIPv6Address(String hostname) {
        if (hostname == null || !InetAddressUtils.isIPv6Address(hostname)) {
            return hostname;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(hostname);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException uhe) {
            LOG.error((Object)("Unexpected error converting " + hostname), (Throwable)uhe);
            return hostname;
        }
    }

    private static int countDots(String data) {
        int dots = 0;
        for (int i = 0; i < data.length(); ++i) {
            if (data.charAt(i) != '.') continue;
            ++dots;
        }
        return dots;
    }

    private static String getCN(X509Certificate cert) {
        String subjectPrincipal = cert.getSubjectX500Principal().toString();
        try {
            return SSLProtocolSocketFactory.extractCN(subjectPrincipal);
        }
        catch (SSLException ex) {
            return null;
        }
    }

    private static String extractCN(String subjectPrincipal) throws SSLException {
        if (subjectPrincipal == null) {
            return null;
        }
        try {
            LdapName subjectDN = new LdapName(subjectPrincipal);
            List<Rdn> rdns = subjectDN.getRdns();
            for (int i = rdns.size() - 1; i >= 0; --i) {
                Rdn rds = rdns.get(i);
                Attributes attributes = rds.toAttributes();
                Attribute cn = attributes.get("cn");
                if (cn == null) continue;
                try {
                    Object value = cn.get();
                    if (value == null) continue;
                    return value.toString();
                }
                catch (NoSuchElementException ignore) {
                    continue;
                }
                catch (NamingException ignore) {
                    // empty catch block
                }
            }
        }
        catch (InvalidNameException e) {
            throw new SSLException(subjectPrincipal + " is not a valid X500 distinguished name");
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    static {
        LOG = LogFactory.getLog(SSLProtocolSocketFactory.class);
        BAD_COUNTRY_2LDS = new String[]{"ac", "co", "com", "ed", "edu", "go", "gouv", "gov", "info", "lg", "ne", "net", "or", "org"};
        LOCALHOSTS = new String[]{"::1", "127.0.0.1", "localhost", "localhost.localdomain"};
        Arrays.sort(LOCALHOSTS);
        Arrays.sort(BAD_COUNTRY_2LDS);
    }
}

