/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.siddhi.extension.evalscript;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.wso2.siddhi.core.exception.ExecutionPlanCreationException;
import org.wso2.siddhi.core.exception.ExecutionPlanRuntimeException;
import org.wso2.siddhi.core.function.EvalScript;
import org.wso2.siddhi.query.api.definition.Attribute;

public class EvalJavaScript
implements EvalScript {
    private ScriptEngine engine = new ScriptEngineManager().getEngineByName("JavaScript");
    private Attribute.Type returnType;
    String functionName;

    public void init(String name, String body) {
        this.functionName = name;
        if (this.returnType == null) {
            throw new ExecutionPlanCreationException("Cannot find the return type of the function " + this.functionName);
        }
        try {
            this.engine.eval("function " + name + "(data){" + body + "}");
        }
        catch (ScriptException e) {
            throw new ExecutionPlanCreationException("Compilation Failure of the JavaScript Function " + name, (Throwable)e);
        }
    }

    public Object eval(String name, Object[] args) {
        StringBuilder jsArray = new StringBuilder("var data = [");
        for (int i = 0; i < args.length - 1; ++i) {
            if (args[i] instanceof String) {
                jsArray.append("\"").append(args[i].toString()).append("\"");
            } else {
                jsArray.append(args[i].toString());
            }
            jsArray.append(",");
        }
        if (args[args.length - 1] instanceof String) {
            jsArray.append("\"").append(args[args.length - 1].toString()).append("\"");
        } else {
            jsArray.append(args[args.length - 1].toString());
        }
        jsArray.append("]");
        try {
            this.engine.eval(jsArray.toString());
            return this.engine.eval(name + "(data);");
        }
        catch (ScriptException e) {
            throw new ExecutionPlanRuntimeException("Error evaluating JavaScript Function " + name, (Throwable)e);
        }
    }

    public void setReturnType(Attribute.Type returnType) {
        this.returnType = returnType;
    }

    public Attribute.Type getReturnType() {
        return this.returnType;
    }
}

