/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Hashtable;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.identity.core.util.IdentityIOStreamUtils;

public class KeyStoreMgtUtil {
    private static final Log log = LogFactory.getLog(KeyStoreMgtUtil.class);

    private KeyStoreMgtUtil() {
    }

    public static String dumpCert(ConfigurationContext configurationContext, byte[] cert, String fileName) {
        block7: {
            if (KeyStoreMgtUtil.verifyCertExistence(fileName, configurationContext)) break block7;
            String workDir = (String)configurationContext.getProperty("WORK_DIR");
            File pubCert = new File(workDir + File.separator + "pub_certs");
            if (fileName == null) {
                fileName = String.valueOf((double)System.currentTimeMillis() + new SecureRandom().nextDouble()) + ".cert";
            }
            if (!pubCert.exists()) {
                pubCert.mkdirs();
            }
            String filePath = workDir + File.separator + "pub_certs" + File.separator + fileName;
            FileOutputStream outStream = null;
            try {
                outStream = new FileOutputStream(filePath);
                ((OutputStream)outStream).write(cert);
            }
            catch (Exception e) {
                try {
                    String msg = "Error when writing the public certificate to a file";
                    log.error((Object)msg);
                    throw new SecurityException("msg", e);
                }
                catch (Throwable throwable) {
                    IdentityIOStreamUtils.flushOutputStream(outStream);
                    IdentityIOStreamUtils.closeOutputStream((OutputStream)outStream);
                    throw throwable;
                }
            }
            IdentityIOStreamUtils.flushOutputStream((OutputStream)outStream);
            IdentityIOStreamUtils.closeOutputStream((OutputStream)outStream);
            Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)configurationContext.getProperty("file.resource.map");
            if (fileResourcesMap == null) {
                fileResourcesMap = new Hashtable<String, String>();
                configurationContext.setProperty("file.resource.map", fileResourcesMap);
            }
            fileResourcesMap.put(fileName, filePath);
        }
        return "/filedownload?id=" + fileName;
    }

    private static boolean verifyCertExistence(String fileName, ConfigurationContext configurationContext) {
        String workDir = (String)configurationContext.getProperty("WORK_DIR");
        String filePath = workDir + File.separator + "pub_certs" + File.separator + fileName;
        File pubCert = new File(workDir + File.separator + "pub_certs" + File.separator + fileName);
        if (pubCert.exists()) {
            Hashtable<String, String> fileResourcesMap = (Hashtable<String, String>)configurationContext.getProperty("file.resource.map");
            if (fileResourcesMap == null) {
                fileResourcesMap = new Hashtable<String, String>();
                configurationContext.setProperty("file.resource.map", fileResourcesMap);
            }
            if (fileResourcesMap.get(fileName) == null) {
                fileResourcesMap.put(fileName, filePath);
            }
            return true;
        }
        return false;
    }
}

