/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.keystore.service;

import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.core.AbstractAdmin;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;
import org.wso2.carbon.security.keystore.service.KeyStoreAdminInterface;
import org.wso2.carbon.security.keystore.service.KeyStoreData;
import org.wso2.carbon.security.keystore.service.PaginatedKeyStoreData;

public class KeyStoreAdminServiceImpl
extends AbstractAdmin
implements KeyStoreAdminInterface {
    @Override
    public KeyStoreData[] getKeyStores() throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getThreadLocalCarbonContext().getTenantId(), this.getGovernanceSystemRegistry());
        boolean isSuperTenant = CarbonContext.getThreadLocalCarbonContext().getTenantId() == -1234;
        return admin.getKeyStores(isSuperTenant);
    }

    @Override
    public void addKeyStore(String fileData, String filename, String password, String provider, String type, String pvtkeyPass) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getThreadLocalCarbonContext().getTenantId(), this.getGovernanceSystemRegistry());
        admin.addKeyStore(fileData, filename, password, provider, type, pvtkeyPass);
    }

    @Override
    public void addTrustStore(String fileData, String filename, String password, String provider, String type) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getThreadLocalCarbonContext().getTenantId(), this.getGovernanceSystemRegistry());
        admin.addTrustStore(fileData, filename, password, provider, type);
    }

    @Override
    public void deleteStore(String keyStoreName) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getThreadLocalCarbonContext().getTenantId(), this.getGovernanceSystemRegistry());
        admin.deleteStore(keyStoreName);
    }

    @Override
    public void importCertToStore(String fileName, String fileData, String keyStoreName) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getThreadLocalCarbonContext().getTenantId(), this.getGovernanceSystemRegistry());
        admin.importCertToStore(fileName, fileData, keyStoreName);
    }

    @Override
    public String[] getStoreEntries(String keyStoreName) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getThreadLocalCarbonContext().getTenantId(), this.getGovernanceSystemRegistry());
        return admin.getStoreEntries(keyStoreName);
    }

    @Override
    public KeyStoreData getKeystoreInfo(String keyStoreName) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getThreadLocalCarbonContext().getTenantId(), this.getGovernanceSystemRegistry());
        return admin.getKeystoreInfo(keyStoreName);
    }

    @Override
    public void removeCertFromStore(String alias, String keyStoreName) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getThreadLocalCarbonContext().getTenantId(), this.getGovernanceSystemRegistry());
        admin.removeCertFromStore(alias, keyStoreName);
    }

    public PaginatedKeyStoreData getPaginatedKeystoreInfo(String keyStoreName, int pageNumber) throws SecurityConfigException {
        KeyStoreAdmin admin = new KeyStoreAdmin(CarbonContext.getThreadLocalCarbonContext().getTenantId(), this.getGovernanceSystemRegistry());
        return admin.getPaginatedKeystoreInfo(keyStoreName, pageNumber);
    }
}

