/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.keystore;

import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.core.util.KeyStoreUtil;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.SecurityConstants;
import org.wso2.carbon.security.keystore.KeyStoreAdmin;
import org.wso2.carbon.security.keystore.KeyStoreManagementClientException;
import org.wso2.carbon.security.keystore.KeyStoreManagementException;
import org.wso2.carbon.security.keystore.KeyStoreManagementServerException;
import org.wso2.carbon.security.keystore.KeyStoreManagementService;
import org.wso2.carbon.security.keystore.service.CertData;
import org.wso2.carbon.security.keystore.service.CertDataDetail;
import org.wso2.carbon.security.keystore.service.KeyStoreData;

public class KeyStoreManagementServiceImpl
implements KeyStoreManagementService {
    @Override
    public List<String> getKeyStoreCertificateAliases(String tenantDomain, String filter) throws KeyStoreManagementException {
        KeyStoreData keyStoreInfo = this.getKeystoreData(tenantDomain, this.getKeyStoreName(tenantDomain));
        return this.filterAlias(this.getAliasList(keyStoreInfo), filter);
    }

    @Override
    public Map<String, X509Certificate> getPublicCertificate(String tenantDomain) throws KeyStoreManagementException {
        HashMap<String, X509Certificate> certData = new HashMap<String, X509Certificate>();
        KeyStoreData keyStoreInfo = this.getKeystoreData(tenantDomain, this.getKeyStoreName(tenantDomain));
        CertData key = keyStoreInfo.getKey();
        certData.put(key.getAlias(), ((CertDataDetail)key).getCertificate());
        return certData;
    }

    @Override
    public X509Certificate getKeyStoreCertificate(String tenantDomain, String alias) throws KeyStoreManagementException {
        CertData[] certDataArray;
        if (StringUtils.isEmpty((String)alias)) {
            throw this.handleClientException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_EMPTY_ALIAS, null);
        }
        KeyStoreData keyStoreInfo = this.getKeystoreData(tenantDomain, this.getKeyStoreName(tenantDomain));
        CertData key = keyStoreInfo.getKey();
        if (key != null && StringUtils.equals((String)key.getAlias(), (String)alias)) {
            return ((CertDataDetail)key).getCertificate();
        }
        for (CertData certData : certDataArray = keyStoreInfo.getCerts()) {
            String aliasFromKeyStore = certData.getAlias();
            if (!StringUtils.equals((String)aliasFromKeyStore, (String)alias)) continue;
            return ((CertDataDetail)certData).getCertificate();
        }
        return null;
    }

    @Override
    public List<String> getClientCertificateAliases(String tenantDomain, String filter) throws KeyStoreManagementException {
        KeyStoreData truststoreInfo = this.getKeystoreData(tenantDomain, this.getTrustStoreName());
        return this.filterAlias(this.getAliasList(truststoreInfo), filter);
    }

    @Override
    public X509Certificate getClientCertificate(String tenantDomain, String alias) throws KeyStoreManagementException {
        if (StringUtils.isEmpty((String)alias)) {
            throw this.handleClientException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_EMPTY_ALIAS, null);
        }
        KeyStore trustStore = null;
        try {
            trustStore = this.getKeyStoreAdmin(tenantDomain).getTrustStore();
        }
        catch (SecurityConfigException e) {
            throw this.handleServerException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_RETRIEVE_CLIENT_TRUSTSTORE, tenantDomain, (Throwable)((Object)e));
        }
        if (trustStore != null) {
            try {
                if (trustStore.containsAlias(alias)) {
                    return (X509Certificate)trustStore.getCertificate(alias);
                }
            }
            catch (KeyStoreException e) {
                throw this.handleServerException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_RETRIEVE_CLIENT_TRUSTSTORE_CERTIFICATE, alias, e);
            }
        }
        return null;
    }

    @Override
    public void addCertificate(String tenantDomain, String alias, String certificate) throws KeyStoreManagementException {
        String certAlias;
        boolean isAliasExists;
        X509Certificate cert;
        KeyStoreAdmin keyStoreAdmin = this.getKeyStoreAdmin(tenantDomain);
        String keyStoreName = this.getKeyStoreName(tenantDomain);
        try {
            cert = keyStoreAdmin.extractCertificate(certificate);
        }
        catch (SecurityConfigException e) {
            throw this.handleClientException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_INVALID_CERTIFICATE, alias);
        }
        try {
            KeyStore keyStore = keyStoreAdmin.getKeyStore(keyStoreName);
            isAliasExists = keyStore.containsAlias(alias);
            certAlias = keyStore.getCertificateAlias(cert);
        }
        catch (Exception e) {
            throw this.handleServerException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_VALIDATE_CERTIFICATE, null, e);
        }
        if (isAliasExists) {
            throw this.handleClientException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_ALIAS_EXISTS, alias);
        }
        if (certAlias != null) {
            throw this.handleClientException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_CERTIFICATE_EXISTS, certAlias);
        }
        try {
            keyStoreAdmin.importCertToStore(alias, certificate, keyStoreName);
        }
        catch (SecurityConfigException e) {
            throw this.handleServerException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_ADD_CERTIFICATE, alias, (Throwable)((Object)e));
        }
    }

    @Override
    public void deleteCertificate(String tenantDomain, String alias) throws KeyStoreManagementException {
        try {
            this.getKeyStoreAdmin(tenantDomain).removeCertFromStore(alias, this.getKeyStoreName(tenantDomain));
        }
        catch (SecurityConfigException e) {
            throw this.handleServerException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_DELETE_CERTIFICATE, alias, (Throwable)((Object)e));
        }
    }

    private String getKeyStoreName(String tenantDomain) throws KeyStoreManagementException {
        KeyStoreData[] keyStoreDataArray = new KeyStoreData[]{};
        try {
            keyStoreDataArray = this.getKeyStoreAdmin(tenantDomain).getKeyStores(this.isSuperTenant(tenantDomain));
        }
        catch (SecurityConfigException e) {
            throw this.handleServerException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_RETRIEVE_KEYSTORE, tenantDomain, (Throwable)((Object)e));
        }
        for (KeyStoreData keyStoreData : keyStoreDataArray) {
            String tenantKeyStoreName;
            if (keyStoreData == null) break;
            String keyStoreName = keyStoreData.getKeyStoreName();
            if (!(this.isSuperTenant(tenantDomain) ? KeyStoreUtil.isPrimaryStore((String)keyStoreName) : StringUtils.equals((String)keyStoreName, (String)(tenantKeyStoreName = tenantDomain.trim().replace(".", "-") + ".jks")))) continue;
            return keyStoreName;
        }
        throw this.handleServerException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_RETRIEVE_KEYSTORE, tenantDomain);
    }

    private KeyStoreData getKeystoreData(String tenantDomain, String keyStoreName) throws KeyStoreManagementException {
        KeyStoreAdmin keyStoreAdmin = this.getKeyStoreAdmin(tenantDomain);
        KeyStoreData keyStoreData = null;
        keyStoreAdmin.setIncludeCert(true);
        try {
            keyStoreData = keyStoreAdmin.getKeystoreInfo(keyStoreName);
        }
        catch (SecurityConfigException e) {
            throw this.handleServerException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_RETRIEVE_KEYSTORE_INFORMATION, keyStoreName, (Throwable)((Object)e));
        }
        return keyStoreData;
    }

    private List<String> getAliasList(KeyStoreData keyStoreData) {
        CertData[] certDataArray;
        ArrayList<String> aliasList = new ArrayList<String>();
        CertData key = keyStoreData.getKey();
        if (key != null && key.getAlias() != null) {
            aliasList.add(key.getAlias());
        }
        for (CertData certData : certDataArray = keyStoreData.getCerts()) {
            String alias = certData.getAlias();
            if (alias == null) continue;
            aliasList.add(alias);
        }
        return aliasList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> filterAlias(List<String> aliases, String filter) throws KeyStoreManagementException {
        if (filter == null) return aliases;
        String[] extractedFilter = (filter = filter.replace(" ", "+")).split("[+]");
        if (extractedFilter.length != 3) throw this.handleClientException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_BAD_VALUE_FOR_FILTER, filter);
        if (!StringUtils.equals((String)extractedFilter[0], (String)"alias")) return aliases;
        String operation = extractedFilter[1];
        String value = extractedFilter[2];
        if (StringUtils.equals((String)operation, (String)"eq")) {
            return aliases.stream().filter(alias -> alias.matches(value)).collect(Collectors.toList());
        }
        if (StringUtils.equals((String)operation, (String)"sw")) {
            return aliases.stream().filter(alias -> alias.startsWith(value)).collect(Collectors.toList());
        }
        if (StringUtils.equals((String)operation, (String)"ew")) {
            return aliases.stream().filter(alias -> alias.endsWith(value)).collect(Collectors.toList());
        }
        if (!StringUtils.equals((String)operation, (String)"co")) throw this.handleClientException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage.ERROR_CODE_UNSUPPORTED_FILTER_OPERATION, operation);
        return aliases.stream().filter(alias -> alias.contains(value)).collect(Collectors.toList());
    }

    private KeyStoreAdmin getKeyStoreAdmin(String tenantDomain) {
        return new KeyStoreAdmin(IdentityTenantUtil.getTenantId((String)tenantDomain), (Registry)CarbonContext.getThreadLocalCarbonContext().getRegistry(RegistryType.SYSTEM_GOVERNANCE));
    }

    private boolean isSuperTenant(String tenantDomain) {
        return IdentityTenantUtil.getTenantId((String)tenantDomain) == -1234;
    }

    private String getTrustStoreName() {
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        String filePath = serverConfiguration.getFirstProperty("Security.TrustStore.Location");
        return Paths.get(filePath, new String[0]).getFileName().toString();
    }

    private KeyStoreManagementServerException handleServerException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage error, String data) {
        String message = KeyStoreManagementServiceImpl.includeData(error, data);
        return new KeyStoreManagementServerException(error.getCode(), message);
    }

    private KeyStoreManagementServerException handleServerException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage error, String data, Throwable e) {
        String message = KeyStoreManagementServiceImpl.includeData(error, data);
        return new KeyStoreManagementServerException(error.getCode(), message, e);
    }

    private KeyStoreManagementClientException handleClientException(SecurityConstants.KeyStoreMgtConstants.ErrorMessage error, String data) {
        String message = KeyStoreManagementServiceImpl.includeData(error, data);
        return new KeyStoreManagementClientException(error.getCode(), message);
    }

    private static String includeData(SecurityConstants.KeyStoreMgtConstants.ErrorMessage error, String data) {
        String message = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return message;
    }
}

