/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.keystore;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.apache.axiom.om.util.Base64;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.core.util.CryptoUtil;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.core.util.KeyStoreUtil;
import org.wso2.carbon.registry.core.Association;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Registry;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.security.SecurityConfigException;
import org.wso2.carbon.security.keystore.service.CertData;
import org.wso2.carbon.security.keystore.service.CertDataDetail;
import org.wso2.carbon.security.keystore.service.KeyStoreData;
import org.wso2.carbon.security.keystore.service.PaginatedCertData;
import org.wso2.carbon.security.keystore.service.PaginatedKeyStoreData;
import org.wso2.carbon.security.util.KeyStoreMgtUtil;
import org.wso2.carbon.utils.CarbonUtils;

public class KeyStoreAdmin {
    public static final String SERVER_TRUSTSTORE_FILE = "Security.TrustStore.Location";
    public static final String SERVER_TRUSTSTORE_PASSWORD = "Security.TrustStore.Password";
    public static final String SERVER_TRUSTSTORE_TYPE = "Security.TrustStore.Type";
    private static final Log log = LogFactory.getLog(KeyStoreAdmin.class);
    private Registry registry = null;
    private int tenantId;
    private boolean includeCert = false;
    private static String TRUST_STORE_LOCATION;
    private static String TRUST_STORE_PASSWORD;

    public KeyStoreAdmin(int tenantId, Registry registry) {
        ServerConfiguration config = ServerConfiguration.getInstance();
        TRUST_STORE_LOCATION = config.getFirstProperty(SERVER_TRUSTSTORE_FILE);
        TRUST_STORE_PASSWORD = config.getFirstProperty(SERVER_TRUSTSTORE_PASSWORD);
        this.registry = registry;
        this.tenantId = tenantId;
    }

    public boolean isIncludeCert() {
        return this.includeCert;
    }

    public void setIncludeCert(boolean includeCert) {
        this.includeCert = includeCert;
    }

    public KeyStoreData[] getKeyStores(boolean isSuperTenant) throws SecurityConfigException {
        CarbonUtils.checkSecurity();
        KeyStoreData[] names = new KeyStoreData[]{};
        try {
            if (this.registry.resourceExists("/repository/security/key-stores")) {
                String type;
                Collection collection = (Collection)this.registry.get("/repository/security/key-stores");
                String[] ks = collection.getChildren();
                ArrayList<KeyStoreData> lst = new ArrayList<KeyStoreData>();
                for (int i = 0; i < ks.length; ++i) {
                    Association[] associations;
                    String fullname = ks[i];
                    if ("/repository/security/key-stores/carbon-primary-ks".equals(fullname)) continue;
                    Resource store = this.registry.get(ks[i]);
                    int lastIndex = fullname.lastIndexOf("/");
                    String name = fullname.substring(lastIndex + 1);
                    type = store.getProperty("type");
                    String provider = store.getProperty("provider");
                    KeyStoreData data = new KeyStoreData();
                    data.setKeyStoreName(name);
                    data.setKeyStoreType(type);
                    data.setProvider(provider);
                    String alias = store.getProperty("privatekeyAlias");
                    if (alias != null) {
                        data.setPrivateStore(true);
                    } else {
                        data.setPrivateStore(false);
                    }
                    if (!isSuperTenant && (associations = this.registry.getAssociations(ks[i], "assoc.tenant.ks.pub.key")) != null && associations.length > 0) {
                        Resource pubKeyResource = this.registry.get(associations[0].getDestinationPath());
                        String fileName = this.generatePubCertFileName(ks[i], pubKeyResource.getProperty("tenant.pub.key.file.name.appender"));
                        if (MessageContext.getCurrentMessageContext() != null) {
                            String pubKeyFilePath = KeyStoreMgtUtil.dumpCert(MessageContext.getCurrentMessageContext().getConfigurationContext(), (byte[])pubKeyResource.getContent(), fileName);
                            data.setPubKeyFilePath(pubKeyFilePath);
                        }
                    }
                    lst.add(data);
                }
                names = new KeyStoreData[lst.size() + 1];
                Iterator ite = lst.iterator();
                int count = 0;
                while (ite.hasNext()) {
                    names[count] = (KeyStoreData)ite.next();
                    ++count;
                }
                if (isSuperTenant) {
                    KeyStoreData data = new KeyStoreData();
                    ServerConfiguration config = ServerConfiguration.getInstance();
                    String fileName = config.getFirstProperty("Security.KeyStore.Location");
                    type = config.getFirstProperty("Security.KeyStore.Type");
                    String name = KeyStoreUtil.getKeyStoreFileName((String)fileName);
                    data.setKeyStoreName(name);
                    data.setKeyStoreType(type);
                    data.setProvider(" ");
                    data.setPrivateStore(true);
                    names[count] = data;
                }
            }
            return names;
        }
        catch (RegistryException e) {
            String msg = "Error when getting keyStore data";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg, e);
        }
    }

    public void addKeyStoreWithFilePath(String filePath, String filename, String password, String provider, String type, String pvtkeyPass) throws SecurityConfigException {
        try {
            this.addKeyStore(this.readBytesFromFile(filePath), filename, password, provider, type, pvtkeyPass);
        }
        catch (IOException e) {
            throw new SecurityConfigException("Error while loading keystore from file " + filePath, e);
        }
    }

    public void addKeyStore(String fileData, String filename, String password, String provider, String type, String pvtkeyPass) throws SecurityConfigException {
        byte[] content = Base64.decode((String)fileData);
        this.addKeyStore(content, filename, password, provider, type, pvtkeyPass);
    }

    public void addKeyStore(byte[] content, String filename, String password, String provider, String type, String pvtkeyPass) throws SecurityConfigException {
        if (filename == null) {
            throw new SecurityConfigException("Key Store name can't be null");
        }
        try {
            if (KeyStoreUtil.isPrimaryStore((String)filename)) {
                throw new SecurityConfigException("Key store " + filename + " already available");
            }
            if (this.isTrustStore(filename)) {
                throw new SecurityConfigException("Key store " + filename + " already available");
            }
            String path = "/repository/security/key-stores/" + filename;
            if (this.registry.resourceExists(path)) {
                throw new SecurityConfigException("Key store " + filename + " already available");
            }
            KeyStore keyStore = KeyStore.getInstance(type);
            keyStore.load(new ByteArrayInputStream(content), password.toCharArray());
            Enumeration<String> enumeration = keyStore.aliases();
            String pvtKeyAlias = null;
            while (enumeration.hasMoreElements()) {
                String alias = enumeration.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                pvtKeyAlias = alias;
            }
            keyStore.getKey(pvtKeyAlias, pvtkeyPass.toCharArray());
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            Resource resource = this.registry.newResource();
            resource.addProperty("password", cryptoUtil.encryptAndBase64Encode(password.getBytes()));
            resource.addProperty("provider", provider);
            resource.addProperty("type", type);
            if (pvtKeyAlias != null) {
                resource.addProperty("privatekeyAlias", pvtKeyAlias);
                resource.addProperty("privatekeyPass", cryptoUtil.encryptAndBase64Encode(pvtkeyPass.getBytes()));
            }
            resource.setContent((Object)content);
            this.registry.put(path, resource);
        }
        catch (SecurityConfigException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Error when adding a keyStore";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg, e);
        }
    }

    public void addTrustStore(String fileData, String filename, String password, String provider, String type) throws SecurityConfigException {
        byte[] content = Base64.decode((String)fileData);
        this.addTrustStore(content, filename, password, provider, type);
    }

    public void addTrustStore(byte[] content, String filename, String password, String provider, String type) throws SecurityConfigException {
        if (filename == null) {
            throw new SecurityConfigException("Key Store name can't be null");
        }
        try {
            if (KeyStoreUtil.isPrimaryStore((String)filename)) {
                throw new SecurityConfigException("Key store " + filename + " already available");
            }
            String path = "/repository/security/key-stores/" + filename;
            if (this.registry.resourceExists(path)) {
                throw new SecurityConfigException("Key store " + filename + " already available");
            }
            KeyStore keyStore = KeyStore.getInstance(type);
            keyStore.load(new ByteArrayInputStream(content), password.toCharArray());
            CryptoUtil cryptoUtil = CryptoUtil.getDefaultCryptoUtil();
            Resource resource = this.registry.newResource();
            resource.addProperty("password", cryptoUtil.encryptAndBase64Encode(password.getBytes()));
            resource.addProperty("provider", provider);
            resource.addProperty("type", type);
            resource.setContent((Object)content);
            this.registry.put(path, resource);
        }
        catch (SecurityConfigException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Error when adding a trustStore";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg, e);
        }
    }

    public void deleteStore(String keyStoreName) throws SecurityConfigException {
        try {
            if (StringUtils.isBlank((String)keyStoreName)) {
                throw new SecurityConfigException("Key Store name can't be null");
            }
            if (KeyStoreUtil.isPrimaryStore((String)keyStoreName)) {
                throw new SecurityConfigException("Not allowed to delete the primary key store : " + keyStoreName);
            }
            if (this.isTrustStore(keyStoreName)) {
                throw new SecurityConfigException("Not allowed to delete the trust store : " + keyStoreName);
            }
            String path = "/repository/security/key-stores/" + keyStoreName;
            boolean isFound = false;
            Association[] assocs = this.registry.getAllAssociations(path);
            if (assocs.length > 0) {
                isFound = true;
            }
            if (isFound) {
                throw new SecurityConfigException("Key store : " + keyStoreName + " is already in use and can't be deleted");
            }
            this.registry.delete(path);
        }
        catch (RegistryException e) {
            String msg = "Error when deleting a keyStore";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg, e);
        }
    }

    public void importCertToStore(String fileName, String certData, String keyStoreName) throws SecurityConfigException {
        try {
            X509Certificate cert;
            if (keyStoreName == null) {
                throw new SecurityConfigException("Key Store name can't be null");
            }
            KeyStore ks = this.getKeyStore(keyStoreName);
            if (ks.getCertificateAlias(cert = this.extractCertificate(certData)) != null) {
                return;
            }
            ks.setCertificateEntry(fileName, cert);
            this.updateKeyStore(keyStoreName, ks);
            if (this.isTrustStore(keyStoreName)) {
                System.setProperty("org.wso2.carbon.identity.core.util.TRUST_STORE_UPDATE_REQUIRED", "true");
            }
        }
        catch (SecurityConfigException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Error when importing cert to the keyStore";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg, e);
        }
    }

    public String importCertToStore(String certData, String keyStoreName) throws SecurityConfigException {
        String alias = null;
        try {
            X509Certificate cert;
            if (keyStoreName == null) {
                throw new SecurityConfigException("Key Store name can't be null");
            }
            KeyStore ks = this.getKeyStore(keyStoreName);
            if (ks.getCertificateAlias(cert = this.extractCertificate(certData)) != null) {
                return null;
            }
            alias = cert.getSubjectDN().getName();
            ks.setCertificateEntry(alias, cert);
            this.updateKeyStore(keyStoreName, ks);
            if (this.isTrustStore(keyStoreName)) {
                System.setProperty("org.wso2.carbon.identity.core.util.TRUST_STORE_UPDATE_REQUIRED", "true");
            }
            return alias;
        }
        catch (SecurityConfigException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Error when importing cert to keyStore";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg);
        }
    }

    public void removeCertFromStore(String alias, String keyStoreName) throws SecurityConfigException {
        try {
            if (keyStoreName == null) {
                throw new SecurityConfigException("Key Store name can't be null");
            }
            KeyStore ks = this.getKeyStore(keyStoreName);
            if (ks.getCertificate(alias) == null) {
                return;
            }
            ks.deleteEntry(alias);
            this.updateKeyStore(keyStoreName, ks);
            if (this.isTrustStore(keyStoreName)) {
                System.setProperty("org.wso2.carbon.identity.core.util.TRUST_STORE_UPDATE_REQUIRED", Boolean.TRUE.toString());
            }
        }
        catch (SecurityConfigException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Error when removing cert from store";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg);
        }
    }

    public String[] getStoreEntries(String keyStoreName) throws SecurityConfigException {
        String[] names;
        try {
            if (keyStoreName == null) {
                throw new Exception("keystore name cannot be null");
            }
            KeyStore ks = this.getKeyStore(keyStoreName);
            Enumeration<String> enm = ks.aliases();
            ArrayList<String> lst = new ArrayList<String>();
            while (enm.hasMoreElements()) {
                lst.add(enm.nextElement());
            }
            names = lst.toArray(new String[lst.size()]);
        }
        catch (SecurityConfigException e) {
            throw e;
        }
        catch (Exception e) {
            String msg = "Error when getting store entries";
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg);
        }
        return names;
    }

    public KeyStoreData getKeystoreInfo(String keyStoreName) throws SecurityConfigException {
        try {
            String keyStoreType;
            KeyStore keyStore;
            if (keyStoreName == null) {
                throw new Exception("keystore name cannot be null");
            }
            String privateKeyPassword = null;
            if (KeyStoreUtil.isPrimaryStore((String)keyStoreName)) {
                KeyStoreManager keyMan = KeyStoreManager.getInstance((int)this.tenantId);
                keyStore = keyMan.getPrimaryKeyStore();
                ServerConfiguration serverConfig = ServerConfiguration.getInstance();
                keyStoreType = serverConfig.getFirstProperty("Security.KeyStore.Type");
                privateKeyPassword = serverConfig.getFirstProperty("Security.KeyStore.KeyPassword");
            } else if (this.isTrustStore(keyStoreName)) {
                keyStore = this.getTrustStore();
                ServerConfiguration serverConfig = ServerConfiguration.getInstance();
                keyStoreType = serverConfig.getFirstProperty(SERVER_TRUSTSTORE_TYPE);
                privateKeyPassword = serverConfig.getFirstProperty(SERVER_TRUSTSTORE_PASSWORD);
            } else {
                String path = "/repository/security/key-stores/" + keyStoreName;
                if (!this.registry.resourceExists(path)) {
                    throw new SecurityConfigException("Key Store not found");
                }
                Resource resource = this.registry.get(path);
                keyStore = this.getKeyStore(keyStoreName);
                keyStoreType = resource.getProperty("type");
                String encpass = resource.getProperty("privatekeyPass");
                if (encpass != null) {
                    CryptoUtil util = CryptoUtil.getDefaultCryptoUtil();
                    privateKeyPassword = new String(util.base64DecodeAndDecrypt(encpass));
                }
            }
            Enumeration<String> aliases = keyStore.aliases();
            ArrayList<CertData> certDataList = new ArrayList<CertData>();
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isCertificateEntry(alias)) continue;
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                certDataList.add(this.fillCertData(cert, alias, formatter));
            }
            CertData[] certs = certDataList.toArray(new CertData[certDataList.size()]);
            KeyStoreData keyStoreData = new KeyStoreData();
            keyStoreData.setKeyStoreName(keyStoreName);
            keyStoreData.setCerts(certs);
            keyStoreData.setKeyStoreType(keyStoreType);
            aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                keyStoreData.setKey(this.fillCertData(cert, alias, formatter));
                PrivateKey key = (PrivateKey)keyStore.getKey(alias, privateKeyPassword.toCharArray());
                String pemKey = "-----BEGIN PRIVATE KEY-----\n";
                pemKey = pemKey + Base64.encode((byte[])key.getEncoded());
                pemKey = pemKey + "\n-----END PRIVATE KEY-----";
                keyStoreData.setKeyValue(pemKey);
                break;
            }
            return keyStoreData;
        }
        catch (Exception e) {
            String msg = "Error has encounted while loading the keystore to the given keystore name " + keyStoreName;
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg);
        }
    }

    public Key getPrivateKey(String alias, boolean isSuperTenant) throws SecurityConfigException {
        KeyStoreData[] keystores = this.getKeyStores(isSuperTenant);
        KeyStore keyStore = null;
        String privateKeyPassowrd = null;
        try {
            for (int i = 0; i < keystores.length; ++i) {
                if (!KeyStoreUtil.isPrimaryStore((String)keystores[i].getKeyStoreName())) continue;
                KeyStoreManager keyMan = KeyStoreManager.getInstance((int)this.tenantId);
                keyStore = keyMan.getPrimaryKeyStore();
                ServerConfiguration serverConfig = ServerConfiguration.getInstance();
                privateKeyPassowrd = serverConfig.getFirstProperty("Security.KeyStore.KeyPassword");
                return keyStore.getKey(alias, privateKeyPassowrd.toCharArray());
            }
        }
        catch (Exception e) {
            String msg = "Error has encounted while loading the key for the given alias " + alias;
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg);
        }
        return null;
    }

    private CertData fillCertData(X509Certificate cert, String alise, Format formatter) throws CertificateEncodingException {
        CertData certData = null;
        certData = this.includeCert ? new CertDataDetail() : new CertData();
        certData.setAlias(alise);
        certData.setSubjectDN(cert.getSubjectDN().getName());
        certData.setIssuerDN(cert.getIssuerDN().getName());
        certData.setSerialNumber(cert.getSerialNumber());
        certData.setVersion(cert.getVersion());
        certData.setNotAfter(formatter.format(cert.getNotAfter()));
        certData.setNotBefore(formatter.format(cert.getNotBefore()));
        certData.setPublicKey(Base64.encode((byte[])cert.getPublicKey().getEncoded()));
        if (this.includeCert) {
            ((CertDataDetail)certData).setCertificate(cert);
        }
        return certData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readBytesFromFile(String filePath) throws IOException {
        byte[] bytes;
        FileInputStream inputStream = null;
        File file = new File(filePath);
        int numRead = 0;
        try {
            inputStream = new FileInputStream(file);
            long length = file.length();
            bytes = new byte[(int)length];
            for (int offset = 0; offset < bytes.length && (numRead = ((InputStream)inputStream).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
        return bytes;
    }

    private String generatePubCertFileName(String ksLocation, String uuid) {
        String tenantName = ksLocation.substring(ksLocation.lastIndexOf("/"));
        if (tenantName.endsWith(".jks")) {
            tenantName = tenantName.replace(".jks", "");
        }
        return tenantName + "-" + uuid + ".cert";
    }

    private PaginatedCertData doPaging(int pageNumber, CertData[] certDataSet) {
        PaginatedCertData paginatedCertData = new PaginatedCertData();
        if (certDataSet.length == 0) {
            paginatedCertData.setCertDataSet(new CertData[0]);
            return paginatedCertData;
        }
        int itemsPerPageInt = 10;
        int numberOfPages = (int)Math.ceil((double)certDataSet.length / (double)itemsPerPageInt);
        if (pageNumber > numberOfPages - 1) {
            pageNumber = numberOfPages - 1;
        }
        int startIndex = pageNumber * itemsPerPageInt;
        int endIndex = (pageNumber + 5) * itemsPerPageInt;
        CertData[] returnedCertDataSet = new CertData[itemsPerPageInt * 5];
        int i = startIndex;
        int j = 0;
        while (i < endIndex && i < certDataSet.length) {
            returnedCertDataSet[j] = certDataSet[i];
            ++i;
            ++j;
        }
        paginatedCertData.setCertDataSet(returnedCertDataSet);
        paginatedCertData.setNumberOfPages(numberOfPages);
        return paginatedCertData;
    }

    public PaginatedKeyStoreData getPaginatedKeystoreInfo(String keyStoreName, int pageNumber) throws SecurityConfigException {
        try {
            String keyStoreType;
            ServerConfiguration serverConfig;
            KeyStore keyStore;
            KeyStoreManager keyMan;
            if (keyStoreName == null) {
                throw new Exception("keystore name cannot be null");
            }
            String keyStorePassword = null;
            if (KeyStoreUtil.isPrimaryStore((String)keyStoreName)) {
                keyMan = KeyStoreManager.getInstance((int)this.tenantId);
                keyStore = keyMan.getPrimaryKeyStore();
                serverConfig = ServerConfiguration.getInstance();
                keyStoreType = serverConfig.getFirstProperty("Security.KeyStore.Type");
                keyStorePassword = serverConfig.getFirstProperty("Security.KeyStore.KeyPassword");
            } else if (this.isTrustStore(keyStoreName)) {
                keyMan = KeyStoreManager.getInstance((int)this.tenantId);
                keyStore = this.getTrustStore();
                serverConfig = ServerConfiguration.getInstance();
                keyStoreType = serverConfig.getFirstProperty(SERVER_TRUSTSTORE_TYPE);
                keyStorePassword = serverConfig.getFirstProperty(SERVER_TRUSTSTORE_PASSWORD);
            } else {
                String path = "/repository/security/key-stores/" + keyStoreName;
                if (!this.registry.resourceExists(path)) {
                    throw new SecurityConfigException("Key Store not found");
                }
                Resource resource = this.registry.get(path);
                KeyStoreManager manager = KeyStoreManager.getInstance((int)this.tenantId);
                keyStore = this.getKeyStore(keyStoreName);
                keyStoreType = resource.getProperty("type");
                String encpass = resource.getProperty("privatekeyPass");
                if (encpass != null) {
                    CryptoUtil util = CryptoUtil.getDefaultCryptoUtil();
                    keyStorePassword = new String(util.base64DecodeAndDecrypt(encpass));
                }
            }
            Enumeration<String> aliases = keyStore.aliases();
            ArrayList<CertData> certDataList = new ArrayList<CertData>();
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isCertificateEntry(alias)) continue;
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                certDataList.add(this.fillCertData(cert, alias, formatter));
            }
            CertData[] certs = certDataList.toArray(new CertData[certDataList.size()]);
            PaginatedKeyStoreData keyStoreData = new PaginatedKeyStoreData();
            keyStoreData.setKeyStoreName(keyStoreName);
            keyStoreData.setPaginatedCertData(this.doPaging(pageNumber, certs));
            keyStoreData.setKeyStoreType(keyStoreType);
            ArrayList<CertData> keyDataList = new ArrayList<CertData>();
            aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!keyStore.isKeyEntry(alias)) continue;
                X509Certificate cert = (X509Certificate)keyStore.getCertificate(alias);
                keyDataList.add(this.fillCertData(cert, alias, formatter));
            }
            CertData[] keyCerts = keyDataList.toArray(new CertData[keyDataList.size()]);
            keyStoreData.setPaginatedKeyData(this.doPaging(pageNumber, keyCerts));
            return keyStoreData;
        }
        catch (Exception e) {
            String msg = "Error has encounted while loading the keystore to the given keystore name " + keyStoreName;
            log.error((Object)msg, (Throwable)e);
            throw new SecurityConfigException(msg);
        }
    }

    public KeyStore getTrustStore() throws SecurityConfigException {
        KeyStore trustStore;
        KeyStore store;
        if (this.tenantId != -1234) {
            throw new SecurityConfigException("Permission denied for accessing trust store");
        }
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        String file = new File(serverConfiguration.getFirstProperty(SERVER_TRUSTSTORE_FILE)).getAbsolutePath();
        try {
            store = KeyStore.getInstance(serverConfiguration.getFirstProperty(SERVER_TRUSTSTORE_TYPE));
        }
        catch (KeyStoreException e) {
            throw new SecurityConfigException("Error occurred while loading keystore.", e);
        }
        String password = serverConfiguration.getFirstProperty(SERVER_TRUSTSTORE_PASSWORD);
        try (FileInputStream in = new FileInputStream(file);){
            store.load(in, password.toCharArray());
            trustStore = store;
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException e) {
            throw new SecurityConfigException("Error occurred while loading trust store", e);
        }
        return trustStore;
    }

    private boolean isTrustStore(String id) {
        String name;
        ServerConfiguration serverConfiguration = ServerConfiguration.getInstance();
        String fileName = serverConfiguration.getFirstProperty(SERVER_TRUSTSTORE_FILE);
        int index = fileName.lastIndexOf(47);
        return index != -1 ? (name = fileName.substring(index + 1)).equals(id) : (name = (index = fileName.lastIndexOf(File.separatorChar)) != -1 ? fileName.substring(fileName.lastIndexOf(File.separatorChar)) : fileName).equals(id);
    }

    public KeyStore getKeyStore(String keyStoreName) throws Exception {
        if (this.isTrustStore(keyStoreName)) {
            return this.getTrustStore();
        }
        KeyStoreManager keyMan = KeyStoreManager.getInstance((int)this.tenantId);
        return keyMan.getKeyStore(keyStoreName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKeyStore(String name, KeyStore keyStore) throws Exception {
        if (this.isTrustStore(name)) {
            String path = new File(TRUST_STORE_LOCATION).getAbsolutePath();
            try (FileOutputStream resource1 = null;){
                resource1 = new FileOutputStream(path);
                String outputStream1 = TRUST_STORE_PASSWORD;
                keyStore.store(resource1, outputStream1.toCharArray());
            }
        } else {
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)this.tenantId);
            keyStoreManager.updateKeyStore(name, keyStore);
        }
    }

    public X509Certificate extractCertificate(String certData) throws SecurityConfigException {
        X509Certificate cert;
        byte[] bytes = Base64.decode((String)certData);
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(bytes));
        }
        catch (CertificateException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e.getMessage(), (Throwable)e);
            }
            throw new SecurityConfigException("Invalid format of the provided certificate file");
        }
        return cert;
    }
}

