/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.security.internal;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.identity.core.util.IdentityCoreInitializedEvent;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.utils.Transaction;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.registry.core.service.TenantRegistryLoader;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.security.SecurityServiceHolder;
import org.wso2.carbon.security.keystore.KeyStoreManagementService;
import org.wso2.carbon.security.keystore.KeyStoreManagementServiceImpl;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="security.mgt.service.component", immediate=true)
public class SecurityMgtServiceComponent {
    private static String POX_SECURITY_MODULE = "POXSecurityModule";
    private static final Log log = LogFactory.getLog(SecurityMgtServiceComponent.class);
    private static ConfigurationContextService configContextService = null;
    private static RealmService realmService;
    private static RegistryService registryService;

    public static ConfigurationContext getServerConfigurationContext() {
        return configContextService.getServerConfigContext();
    }

    @Activate
    protected void activate(ComponentContext ctxt) {
        try {
            BundleContext bundleCtx = ctxt.getBundleContext();
            bundleCtx.registerService(KeyStoreManagementService.class.getName(), (Object)new KeyStoreManagementServiceImpl(), null);
            try {
                this.addKeystores();
            }
            catch (Exception e) {
                String msg = "Error while adding key stores.";
                log.error((Object)msg, (Throwable)e);
                throw new RuntimeException(msg, e);
            }
            log.debug((Object)"Security Mgt bundle is activated");
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate SecurityMgtServiceComponent", e);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext ctxt) {
        log.debug((Object)"Security Mgt bundle is deactivated");
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the ConfigurationContext");
        }
        configContextService = contextService;
        SecurityServiceHolder.setConfigurationContextService(contextService);
    }

    @Reference(name="registry.service", service=RegistryService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRegistryService")
    protected void setRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the RegistryService");
        }
        SecurityMgtServiceComponent.registryService = registryService;
        SecurityServiceHolder.setRegistryService(registryService);
    }

    @Reference(name="user.realmservice.default", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Setting the RealmService");
        }
        SecurityMgtServiceComponent.realmService = realmService;
        SecurityServiceHolder.setRealmService(realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the RealmService");
        }
        SecurityMgtServiceComponent.realmService = null;
        SecurityServiceHolder.setRealmService(null);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the ConfigurationContext");
        }
        configContextService = null;
        SecurityServiceHolder.setConfigurationContextService(contextService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Unsetting the RegistryService");
        }
        SecurityMgtServiceComponent.registryService = registryService;
        SecurityServiceHolder.setRegistryService(registryService);
    }

    @Reference(name="registry.loader.default", service=TenantRegistryLoader.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetTenantRegistryLoader")
    protected void setTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant Registry Loader is set in the SAML SSO bundle");
        }
        SecurityServiceHolder.setTenantRegistryLoader(tenantRegistryLoader);
    }

    protected void unsetTenantRegistryLoader(TenantRegistryLoader tenantRegistryLoader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Tenant Registry Loader is unset in the SAML SSO bundle");
        }
        SecurityServiceHolder.setTenantRegistryLoader(null);
    }

    @Reference(name="identityCoreInitializedEventService", service=IdentityCoreInitializedEvent.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdentityCoreInitializedEventService")
    protected void setIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    protected void unsetIdentityCoreInitializedEventService(IdentityCoreInitializedEvent identityCoreInitializedEvent) {
    }

    public static RegistryService getRegistryService() {
        return registryService;
    }

    private void addKeystores() throws RegistryException {
        UserRegistry registry = SecurityServiceHolder.getRegistryService().getGovernanceSystemRegistry();
        try {
            boolean transactionStarted = Transaction.isStarted();
            if (!transactionStarted) {
                registry.beginTransaction();
            }
            if (!registry.resourceExists("/repository/security/key-stores")) {
                Collection kstores = registry.newCollection();
                registry.put("/repository/security/key-stores", (Resource)kstores);
                Resource primResource = registry.newResource();
                if (!registry.resourceExists("/repository/security/key-stores/carbon-primary-ks")) {
                    registry.put("/repository/security/key-stores/carbon-primary-ks", primResource);
                }
            }
            if (!transactionStarted) {
                registry.commitTransaction();
            }
        }
        catch (Exception e) {
            registry.rollbackTransaction();
            throw e;
        }
    }
}

