/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.report;

import java.io.File;
import org.apache.commons.lang.ArrayUtils;
import org.wso2.carbon.privacy.forgetme.api.user.UserIdentifier;
import org.wso2.carbon.privacy.forgetme.report.PlainTextReportAppender;

public class UserIdentifierQualifiedPlainTextReportAppender
extends PlainTextReportAppender {
    private UserIdentifier userIdentifier;

    public UserIdentifierQualifiedPlainTextReportAppender(File file, String name, UserIdentifier userIdentifier) {
        super(file, name);
        this.userIdentifier = userIdentifier;
    }

    @Override
    public void appendSection(String format, Object ... data) {
        super.appendSection(this.getUserIdentifierQualifiedFormat(format), this.getExtendedData(data));
    }

    @Override
    public void appendSectionEnd(String format, Object ... data) {
        super.appendSectionEnd(this.getUserIdentifierQualifiedFormat(format), this.getExtendedData(data));
    }

    private String getUserIdentifierQualifiedFormat(String format) {
        return format.concat("\nUsername: %s Tenant Domain: %s User Store Domain: %s Pseudonym: %s");
    }

    private Object[] getExtendedData(Object[] data) {
        int length = data.length;
        Object[] extendedData = new Object[length + 4];
        ArrayUtils.addAll((Object[])extendedData, (Object[])data);
        extendedData[length] = this.userIdentifier.getUsername();
        extendedData[length + 1] = this.userIdentifier.getTenantDomain();
        extendedData[length + 2] = this.userIdentifier.getUserStoreDomain();
        extendedData[length + 3] = this.userIdentifier.getPseudonym();
        return extendedData;
    }
}

