/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.report;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.wso2.carbon.privacy.forgetme.api.report.CloseableReportAppender;
import org.wso2.carbon.privacy.forgetme.api.report.CloseableReportAppenderBuilder;
import org.wso2.carbon.privacy.forgetme.api.runtime.ModuleException;
import org.wso2.carbon.privacy.forgetme.api.user.UserIdentifier;
import org.wso2.carbon.privacy.forgetme.report.PlainTextReportAppender;
import org.wso2.carbon.privacy.forgetme.report.UserIdentifierQualifiedPlainTextReportAppender;

public class PlainTextReportAppenderBuilder
implements CloseableReportAppenderBuilder {
    private static final String LOG_USER_IDENTIFIER_PROPERTY = "log-user-identifier";

    public String getType() {
        return "plain-text";
    }

    public CloseableReportAppender build(String processor, Path reportDirectoryPath, Map<String, String> properties, UserIdentifier userIdentifier) throws ModuleException {
        Path reportFilePath = Paths.get(reportDirectoryPath.toString(), this.getReportFileName(processor));
        if (properties.containsKey(LOG_USER_IDENTIFIER_PROPERTY) && Boolean.parseBoolean(properties.get(LOG_USER_IDENTIFIER_PROPERTY))) {
            return new UserIdentifierQualifiedPlainTextReportAppender(reportFilePath.toFile(), processor, userIdentifier);
        }
        return new PlainTextReportAppender(reportFilePath.toFile(), processor);
    }

    private String getReportFileName(String processor) {
        return "Report-" + processor + "-" + System.currentTimeMillis() + ".txt";
    }
}

