/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.report;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.api.report.CloseableReportAppender;
import org.wso2.carbon.privacy.forgetme.api.runtime.InstructionExecutionException;

public class PlainTextReportAppender
implements CloseableReportAppender {
    private static final Logger logger = LoggerFactory.getLogger(PlainTextReportAppender.class);
    private File file;
    private String name;
    private Writer writer;

    public PlainTextReportAppender(File file, String name) {
        this.file = file;
    }

    public void open() throws InstructionExecutionException {
        if (this.file.exists()) {
            if (!this.file.isFile()) {
                throw new InstructionExecutionException("Could not open file for writing. Not a file: " + this.file);
            }
        } else {
            try {
                this.file.createNewFile();
            }
            catch (IOException e) {
                throw new InstructionExecutionException("Could not create a report file : " + this.file);
            }
        }
        try {
            this.writer = Files.newBufferedWriter(this.file.toPath(), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            throw new InstructionExecutionException("Could not open file for writing : " + this.file, (Throwable)e);
        }
    }

    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                logger.error("Error closing the report file for : " + this.name + " , File:  " + this.file, (Throwable)e);
            }
        }
    }

    public void appendSection(String format, Object ... data) {
        String title = String.format(format, data);
        StringBuilder separator = new StringBuilder();
        for (int i = 0; i < title.length(); ++i) {
            separator.append("=");
        }
        String line = separator.toString();
        this.doAppend(line, new Object[0]);
        this.doAppend(title, new Object[0]);
        this.doAppend(line, new Object[0]);
    }

    public void append(String format, Object ... data) {
        this.doAppend(format, data);
    }

    public void appendSectionEnd(String format, Object ... data) {
        this.doAppend("\n", new Object[0]);
        String endNote = String.format(format, data);
        StringBuilder separator = new StringBuilder();
        for (int i = 0; i < endNote.length(); ++i) {
            separator.append("-");
        }
        String line = separator.toString();
        this.doAppend(line, new Object[0]);
        this.doAppend(endNote, new Object[0]);
        this.doAppend(line, new Object[0]);
    }

    private void doAppend(String format, Object ... data) {
        if (this.writer != null && format != null) {
            try {
                this.writer.append(String.format(format, data));
                this.writer.append("\n");
            }
            catch (IOException e) {
                logger.error("Error writing log line: " + String.format(format, data));
            }
        }
    }
}

