/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme.config;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.wso2.carbon.privacy.forgetme.api.report.CloseableReportAppenderBuilder;
import org.wso2.carbon.privacy.forgetme.api.runtime.InstructionReader;
import org.wso2.carbon.privacy.forgetme.api.runtime.ProcessorConfig;
import org.wso2.carbon.privacy.forgetme.config.InstructionReaderConfig;
import org.wso2.carbon.privacy.forgetme.config.ReportAppenderConfig;

public class SystemConfig {
    private Map<Path, InstructionReaderConfig> directoryToInstructionReaderMap = new HashMap<Path, InstructionReaderConfig>();
    private Map<String, ProcessorConfig> processorConfigMap = new HashMap<String, ProcessorConfig>();
    private List<String> processors = new ArrayList<String>();
    private Path workDir;
    private Map<String, ReportAppenderConfig> processorToReportAppenderConfigMap = new HashMap<String, ReportAppenderConfig>();

    public void addInstructionReader(Path dir, InstructionReader instructionReader, Properties properties) {
        this.directoryToInstructionReaderMap.put(dir, new InstructionReaderConfig(instructionReader, properties));
    }

    public Map<Path, InstructionReaderConfig> getDirectoryToInstructionReaderMap() {
        return Collections.unmodifiableMap(this.directoryToInstructionReaderMap);
    }

    public void addProcessorConfig(String processorName, ProcessorConfig processorConfig) {
        this.processorConfigMap.put(processorName, processorConfig);
    }

    public Map<String, ProcessorConfig> getProcessorConfigMap() {
        return Collections.unmodifiableMap(this.processorConfigMap);
    }

    public void addProcessor(String processor) {
        this.processors.add(processor);
    }

    public List<String> getProcessors() {
        return Collections.unmodifiableList(this.processors);
    }

    public Path getWorkDir() {
        return this.workDir;
    }

    public void setWorkDir(Path workDir) {
        this.workDir = workDir;
    }

    public void addReportAppenderConfig(String processor, Path reportDirectoryPath, Map<String, String> properties, CloseableReportAppenderBuilder closeableReportAppenderBuilder) {
        this.processorToReportAppenderConfigMap.put(processor, new ReportAppenderConfig(reportDirectoryPath, properties, closeableReportAppenderBuilder));
    }

    public Map<String, ReportAppenderConfig> getProcessorToReportAppenderConfigMap() {
        return Collections.unmodifiableMap(this.processorToReportAppenderConfigMap);
    }
}

