/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.api.report.CloseableReportAppender;
import org.wso2.carbon.privacy.forgetme.api.report.CloseableReportAppenderBuilder;
import org.wso2.carbon.privacy.forgetme.api.report.ReportAppender;
import org.wso2.carbon.privacy.forgetme.api.runtime.Environment;
import org.wso2.carbon.privacy.forgetme.api.runtime.ForgetMeInstruction;
import org.wso2.carbon.privacy.forgetme.api.runtime.ForgetMeResult;
import org.wso2.carbon.privacy.forgetme.api.runtime.InstructionExecutionException;
import org.wso2.carbon.privacy.forgetme.api.runtime.InstructionReader;
import org.wso2.carbon.privacy.forgetme.api.runtime.ModuleException;
import org.wso2.carbon.privacy.forgetme.api.runtime.ProcessorConfig;
import org.wso2.carbon.privacy.forgetme.api.user.UserIdentifier;
import org.wso2.carbon.privacy.forgetme.config.InstructionReaderConfig;
import org.wso2.carbon.privacy.forgetme.config.ReportAppenderConfig;
import org.wso2.carbon.privacy.forgetme.config.SystemConfig;
import org.wso2.carbon.privacy.forgetme.processor.ForgetMeCompositeResult;
import org.wso2.carbon.privacy.forgetme.report.PlainTextReportAppender;
import org.wso2.carbon.privacy.forgetme.runtime.ForgetMeExecutionException;

public class ForgetMeExecutionEngine {
    private static final Logger log = LoggerFactory.getLogger(ForgetMeExecutionEngine.class);
    private static final String EXECUTOR_THREAD_PREFIX = "ProcessorExec-";
    private SystemConfig systemConfig;
    private Map<String, ExecutorService> executors = new HashMap<String, ExecutorService>();
    private Set<Future<ForgetMeResult>> submittedJobs = new HashSet<Future<ForgetMeResult>>();
    private UserIdentifier userIdentifier;
    private Environment systemEnv;

    public ForgetMeExecutionEngine(UserIdentifier userIdentifier, Environment systemEnv, SystemConfig systemConfig) {
        this.systemConfig = systemConfig;
        this.userIdentifier = userIdentifier;
        this.systemEnv = systemEnv;
    }

    public ForgetMeResult execute() throws ForgetMeExecutionException {
        ForgetMeCompositeResult forgetMeResult = new ForgetMeCompositeResult();
        this.createExecutors();
        this.startExecutors();
        this.waitForCompletion(forgetMeResult);
        return forgetMeResult;
    }

    private void waitForCompletion(ForgetMeCompositeResult compositeResult) {
        for (ExecutorService executorService : this.executors.values()) {
            executorService.shutdown();
        }
        for (Future future : this.submittedJobs) {
            try {
                ForgetMeResult result = (ForgetMeResult)future.get(1L, TimeUnit.HOURS);
                compositeResult.addEntry(result);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.error("Interrupted while executing the processor thread : " + future, (Throwable)e);
            }
        }
        log.info("All processors have been properly shut-down");
    }

    private void startExecutors() throws ForgetMeExecutionException {
        for (String processorName : this.executors.keySet()) {
            List<ForgetMeInstruction> instructions = this.getInstructions(processorName, this.systemEnv);
            ProcessorConfig processorConfig = this.systemConfig.getProcessorConfigMap().get(processorName);
            ReportAppenderConfig reportAppenderConfig = this.systemConfig.getProcessorToReportAppenderConfigMap().get(processorName);
            ProcessorPipeline processorPipeline = new ProcessorPipeline(this.systemConfig.getWorkDir(), processorName, this.userIdentifier, processorConfig, instructions, this.systemEnv, reportAppenderConfig);
            ExecutorService executorService = this.executors.get(processorName);
            Future<ForgetMeResult> future = executorService.submit(processorPipeline);
            this.submittedJobs.add(future);
        }
    }

    private List<ForgetMeInstruction> getInstructions(String processorName, Environment environment) throws ForgetMeExecutionException {
        ArrayList<ForgetMeInstruction> result = new ArrayList<ForgetMeInstruction>();
        for (Map.Entry<Path, InstructionReaderConfig> entry : this.systemConfig.getDirectoryToInstructionReaderMap().entrySet()) {
            InstructionReaderConfig readerConfig = entry.getValue();
            InstructionReader reader = readerConfig.getInstructionReader();
            Path path = entry.getKey();
            if (!reader.getType().equals(processorName)) continue;
            try {
                List instructions = reader.read(path, readerConfig.getProperties(), environment);
                result.addAll(instructions);
            }
            catch (ModuleException e) {
                throw new ForgetMeExecutionException("Unable to get instructions for the processor : " + processorName, e);
            }
        }
        return result;
    }

    private void createExecutors() {
        for (String name : this.systemConfig.getProcessors()) {
            ExecutorService executorService = Executors.newSingleThreadExecutor(new SimpleThreadFactory(EXECUTOR_THREAD_PREFIX + name));
            this.executors.put(name, executorService);
        }
    }

    private static class ProcessorPipeline
    implements Callable<ForgetMeResult> {
        private ProcessorConfig processorConfig;
        private List<ForgetMeInstruction> instructionList;
        private UserIdentifier userIdentifier;
        private String name;
        private Path workDir;
        private Environment environment;
        private ReportAppenderConfig reportAppenderConfig;

        public ProcessorPipeline(Path workDir, String name, UserIdentifier userIdentifier, ProcessorConfig processorConfig, List<ForgetMeInstruction> instructionList, Environment environment, ReportAppenderConfig reportAppenderConfig) {
            this.workDir = workDir;
            this.name = name;
            this.userIdentifier = userIdentifier;
            this.processorConfig = processorConfig;
            this.instructionList = instructionList;
            this.environment = environment;
            this.reportAppenderConfig = reportAppenderConfig;
        }

        @Override
        public ForgetMeResult call() throws InstructionExecutionException {
            try (CloseableReportAppender reportAppender = this.getReportAppender(this.reportAppenderConfig);){
                reportAppender.open();
                ForgetMeCompositeResult forgetMeResult = new ForgetMeCompositeResult();
                for (ForgetMeInstruction instruction : this.instructionList) {
                    instruction.execute(this.userIdentifier, this.processorConfig, this.environment, (ReportAppender)reportAppender);
                }
                log.info("Processor execution completed. Processor : " + this.name);
                Object object = forgetMeResult;
                return object;
            }
        }

        private CloseableReportAppender getReportAppender(ReportAppenderConfig reportAppenderConfig) {
            if (reportAppenderConfig == null) {
                return this.getDefaultAppender();
            }
            CloseableReportAppenderBuilder closeableReportAppenderBuilder = reportAppenderConfig.getReportAppenderBuilder();
            try {
                return closeableReportAppenderBuilder.build(this.name, reportAppenderConfig.getReportDirectoryPath(), reportAppenderConfig.getProperties(), this.userIdentifier);
            }
            catch (ModuleException e) {
                String msg = "Failed to load report appender: " + closeableReportAppenderBuilder.getType() + " for processor: " + this.name;
                log.warn(msg);
                if (log.isDebugEnabled()) {
                    log.debug(msg, (Throwable)e);
                }
                return this.getDefaultAppender();
            }
        }

        private CloseableReportAppender getDefaultAppender() {
            Path reportFile = Paths.get(this.workDir.toString(), this.getReportFileName());
            return new PlainTextReportAppender(reportFile.toFile(), this.name);
        }

        private String getReportFileName() {
            return "Report-" + this.name + "-" + System.currentTimeMillis() + ".txt";
        }
    }

    private static class SimpleThreadFactory
    implements ThreadFactory {
        private String threadNamePrefix;

        public SimpleThreadFactory(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, this.threadNamePrefix);
        }
    }
}

