/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.privacy.forgetme;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.privacy.forgetme.api.report.CloseableReportAppenderBuilder;
import org.wso2.carbon.privacy.forgetme.api.runtime.Environment;
import org.wso2.carbon.privacy.forgetme.api.runtime.InstructionReader;
import org.wso2.carbon.privacy.forgetme.api.runtime.ModuleException;
import org.wso2.carbon.privacy.forgetme.api.runtime.ProcessorConfig;
import org.wso2.carbon.privacy.forgetme.api.runtime.ProcessorConfigReader;
import org.wso2.carbon.privacy.forgetme.config.SystemConfig;
import org.wso2.carbon.privacy.forgetme.runtime.ForgetMeExecutionException;
import org.wso2.carbon.privacy.forgetme.runtime.VariableResolver;

public class ConfigReader {
    private static final Logger log = LoggerFactory.getLogger(ConfigReader.class);
    private ServiceLoader<InstructionReader> readerServiceLoader = ServiceLoader.load(InstructionReader.class);
    private ServiceLoader<ProcessorConfigReader> processorConfigReaderServiceLoader = ServiceLoader.load(ProcessorConfigReader.class);
    private ServiceLoader<CloseableReportAppenderBuilder> reportAppenderBuilderServiceLoader = ServiceLoader.load(CloseableReportAppenderBuilder.class);
    private List<InstructionReader> instructionReaderList = new ArrayList<InstructionReader>();
    private Map<String, InstructionReader> instructionReaderMap = new HashMap<String, InstructionReader>();
    private Map<String, ProcessorConfigReader> stringProcessorConfigReaderMap;
    private Map<String, CloseableReportAppenderBuilder> reportAppenderBuilderMap;
    private static ConfigReader configReader = new ConfigReader();

    public static ConfigReader getInstance() {
        return configReader;
    }

    private ConfigReader() {
        this.readerServiceLoader.forEach(r -> this.instructionReaderList.add((InstructionReader)r));
        this.readerServiceLoader.forEach(r -> this.instructionReaderMap.put(r.getType(), (InstructionReader)r));
        this.stringProcessorConfigReaderMap = new HashMap<String, ProcessorConfigReader>();
        this.processorConfigReaderServiceLoader.forEach(r -> this.stringProcessorConfigReaderMap.put(r.getName(), (ProcessorConfigReader)r));
        this.reportAppenderBuilderMap = new HashMap<String, CloseableReportAppenderBuilder>();
        this.reportAppenderBuilderServiceLoader.forEach(r -> this.reportAppenderBuilderMap.put(r.getType(), (CloseableReportAppenderBuilder)r));
    }

    public SystemConfig readSystemConfig(File file, Environment environment) throws ForgetMeExecutionException {
        SystemConfig systemConfig = new SystemConfig();
        JSONParser jsonParser = new JSONParser();
        Path basePath = file.toPath().getParent();
        try {
            Object parsedObject = jsonParser.parse((Reader)new FileReader(file));
            if (parsedObject instanceof JSONObject) {
                Object reports;
                Object directories;
                Object extensions;
                JSONObject jsonObject = (JSONObject)parsedObject;
                Object processors = jsonObject.get((Object)"processors");
                if (processors instanceof JSONArray) {
                    this.loadProcessors((JSONArray)processors, systemConfig);
                }
                if ((extensions = jsonObject.get((Object)"extensions")) instanceof JSONArray) {
                    this.loadExtensions((JSONArray)extensions, systemConfig, basePath);
                }
                if ((directories = jsonObject.get((Object)"directories")) instanceof JSONArray) {
                    this.loadDirectories((JSONArray)directories, systemConfig, basePath, environment);
                }
                if ((reports = jsonObject.get((Object)"reports")) instanceof JSONArray) {
                    this.loadReports((JSONArray)reports, systemConfig, basePath);
                }
            }
        }
        catch (IOException e) {
            throw new ForgetMeExecutionException("Could not read the config files related to : " + file.getAbsolutePath(), e);
        }
        catch (ParseException e) {
            throw new ForgetMeExecutionException("Could not parse config files related to: " + file.getAbsolutePath(), e);
        }
        return systemConfig;
    }

    private void loadDirectories(JSONArray directories, SystemConfig systemConfig, Path basePath, Environment environment) throws ForgetMeExecutionException {
        VariableResolver variableResolver = new VariableResolver(environment);
        for (Object e : directories) {
            if (!(e instanceof JSONObject)) continue;
            JSONObject dirConfig = (JSONObject)e;
            Object type = dirConfig.get((Object)"type");
            Object dir = dirConfig.get((Object)"dir");
            Object processor = dirConfig.get((Object)"processor");
            Properties additionalProperties = this.getAdditionalProperties(dirConfig, variableResolver);
            if (!(type instanceof String) || !(dir instanceof String) || !(processor instanceof String)) continue;
            String processorName = (String)processor;
            if (systemConfig.getProcessors().contains(processorName)) {
                InstructionReader instructionReader = this.instructionReaderMap.get(processor);
                String pathStr = variableResolver.resolve((String)dir);
                Path path = Paths.get(pathStr, new String[0]);
                if (!path.isAbsolute()) {
                    path = basePath.resolve((String)dir);
                }
                if (instructionReader != null) {
                    systemConfig.addInstructionReader(path, instructionReader, additionalProperties);
                    continue;
                }
                throw new ForgetMeExecutionException("Could not find an instruction reader for the processor : " + processor);
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("The processor : {} is not enabled for directory : {} ", processor, dir);
        }
    }

    private Properties getAdditionalProperties(JSONObject dirConfig, VariableResolver variableResolver) {
        Properties properties = new Properties();
        dirConfig.forEach((key, value) -> properties.setProperty(key.toString(), variableResolver.resolve(value.toString())));
        return properties;
    }

    private void loadProcessors(JSONArray processors, SystemConfig systemConfig) {
        processors.forEach(e -> {
            if (e instanceof String) {
                systemConfig.addProcessor((String)e);
            }
        });
    }

    private void loadExtensions(JSONArray extensions, SystemConfig systemConfig, Path basePath) throws ForgetMeExecutionException {
        for (Object e : extensions) {
            if (!(e instanceof JSONObject)) continue;
            JSONObject extension = (JSONObject)e;
            Object processor = extension.get((Object)"processor");
            Object type = extension.get((Object)"type");
            Object dir = extension.get((Object)"dir");
            Object properties = extension.get((Object)"properties");
            if (!(processor instanceof String) || !(dir instanceof String) || !(type instanceof String)) continue;
            ProcessorConfigReader processorConfigReader = this.stringProcessorConfigReaderMap.get(type);
            if (processorConfigReader == null) {
                throw new ForgetMeExecutionException("No processor configuration extension found for : " + processor + ", dir: " + dir);
            }
            Path path = basePath.resolve((String)dir);
            try {
                Map<Object, Object> propertiesMap = properties instanceof JSONArray ? this.getPropertiesMap((JSONArray)properties) : new HashMap();
                ProcessorConfig processorConfig = processorConfigReader.readProcessorConfig(path, propertiesMap);
                systemConfig.addProcessorConfig((String)processor, processorConfig);
                if (!log.isDebugEnabled()) continue;
                log.debug("Loaded processor config : {} from directory : {}", (Object)processorConfig, (Object)path);
            }
            catch (ModuleException me) {
                throw new ForgetMeExecutionException("Error in reading config of the processor : " + processor + ", from the path : " + path, me);
            }
        }
    }

    private void loadReports(JSONArray reports, SystemConfig systemConfig, Path basePath) throws ForgetMeExecutionException {
        for (Object e : reports) {
            if (!(e instanceof JSONObject)) continue;
            JSONObject reportConfig = (JSONObject)e;
            Object processor = reportConfig.get((Object)"processor");
            Object type = reportConfig.get((Object)"type");
            Object dir = reportConfig.get((Object)"dir");
            Object properties = reportConfig.get((Object)"properties");
            if (!(processor instanceof String) || !(dir instanceof String) || !(type instanceof String)) continue;
            if (!systemConfig.getProcessors().contains(processor)) {
                throw new ForgetMeExecutionException("Could not find a processor: " + processor + " registered to load the report appender");
            }
            CloseableReportAppenderBuilder closeableReportAppenderBuilder = this.reportAppenderBuilderMap.get(type);
            if (closeableReportAppenderBuilder == null) {
                throw new ForgetMeExecutionException("No report appender extension found for type: " + type + " for processor: " + processor);
            }
            Path path = basePath.resolve((String)dir);
            Map<Object, Object> propertiesMap = properties instanceof JSONArray ? this.getPropertiesMap((JSONArray)properties) : new HashMap();
            systemConfig.addReportAppenderConfig((String)processor, path, propertiesMap, closeableReportAppenderBuilder);
            if (!log.isDebugEnabled()) continue;
            log.debug("Loaded report appender config of type: {} for processor : {}", type, processor);
        }
    }

    private Map<String, String> getPropertiesMap(JSONArray jsonArray) {
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (Object arrayItem : jsonArray) {
            JSONObject jsonObject = (JSONObject)arrayItem;
            for (Object key : jsonObject.keySet()) {
                propertiesMap.put((String)key, (String)jsonObject.get(key));
            }
        }
        return propertiesMap;
    }
}

