/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.governance.custom.lifecycles.history.ui.clients;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.ws.stub.WSRegistryServiceStub;
import org.wso2.carbon.ui.CarbonUIUtil;

public class WSRegistryServiceClient {
    private static final Log log = LogFactory.getLog(org.wso2.carbon.registry.ws.client.registry.WSRegistryServiceClient.class);
    private WSRegistryServiceStub stub;
    private String cookie;
    private String epr;

    public WSRegistryServiceClient(String cookie, ServletConfig config, HttpSession session) throws RegistryException {
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        this.epr = backendServerURL + "WSRegistryService";
        try {
            this.stub = new WSRegistryServiceStub(configContext, this.epr);
            ServiceClient client = this.stub._getServiceClient();
            Options options = client.getOptions();
            options.setManageSession(true);
            options.setProperty("Cookie", (Object)cookie);
            this.stub._getServiceClient().getOptions().setProperty("enableMTOM", (Object)"true");
            this.stub._getServiceClient().getOptions().setTimeOutInMilliSeconds(1000000L);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate WSRegistry Service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public boolean resourceExists(String path) throws RegistryException {
        try {
            return this.stub.resourceExists(path);
        }
        catch (Exception e) {
            String msg = "Failed to perform resourceExists operation.";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public void setCookie(String cookie) {
        this.cookie = cookie;
    }

    public void setStub(WSRegistryServiceStub stub) {
        this.stub = stub;
    }

    public WSRegistryServiceStub getStub() {
        return this.stub;
    }

    public void setEpr(String epr) {
        this.epr = epr;
    }
}

