/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.indexing;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.indexing.IndexingManager;
import org.wso2.carbon.registry.indexing.Utils;
import org.wso2.carbon.registry.indexing.indexer.IndexDocumentCreator;
import org.wso2.carbon.registry.indexing.indexer.IndexerException;
import org.wso2.carbon.registry.indexing.solr.SolrClient;
import org.wso2.carbon.utils.WaitBeforeShutdownObserver;

public class AsyncIndexer
implements Runnable {
    private static Log log = LogFactory.getLog(AsyncIndexer.class);
    private final SolrClient client;
    private LinkedBlockingQueue<File2Index> queue = new LinkedBlockingQueue();
    private boolean canAcceptFiles = true;
    int poolSize = 50;

    public void addFile(File2Index file2Index) {
        if (this.canAcceptFiles) {
            this.queue.offer(file2Index);
        } else {
            log.warn((Object)("Can't accept resource for indexing. Shutdown in progress: path=" + file2Index.path));
        }
    }

    protected AsyncIndexer() throws RegistryException {
        try {
            this.client = SolrClient.getInstance();
            Utils.setWaitBeforeShutdownObserver(new WaitBeforeShutdownObserver(){

                public void startingShutdown() {
                    AsyncIndexer.this.canAcceptFiles = false;
                    do {
                        AsyncIndexer.this.indexFile();
                    } while (AsyncIndexer.this.queue.size() != 0);
                }

                public boolean isTaskComplete() {
                    return AsyncIndexer.this.queue.size() <= 0;
                }
            });
        }
        catch (IndexerException e) {
            throw new RegistryException("Error initializing Async Indexer " + e.getMessage(), (Throwable)e);
        }
    }

    public SolrClient getClient() {
        return this.client;
    }

    @Override
    public void run() {
        this.indexFile();
    }

    private boolean indexFile() {
        try {
            if (!this.canAcceptFiles) {
                return false;
            }
            long batchSize = IndexingManager.getInstance().getBatchSize();
            ArrayList<IndexingTask> taskList = new ArrayList<IndexingTask>();
            for (long i = 0L; this.queue.size() > 0 && i <= batchSize; ++i) {
                IndexingTask indexingTask = new IndexingTask(this.queue.take());
                taskList.add(indexingTask);
            }
            if (taskList.size() <= 0) {
                return true;
            }
            this.uploadFiles(taskList);
        }
        catch (Throwable e) {
            if (e instanceof InterruptedException) {
                return false;
            }
            log.error((Object)"Error while indexing.", e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void uploadFiles(List<IndexingTask> tasks) throws RegistryException {
        this.poolSize = IndexingManager.getInstance().getIndexerPoolSize();
        if (this.poolSize <= 0) {
            for (IndexingTask task : tasks) {
                task.run();
            }
            return;
        } else {
            ExecutorService executorService = Executors.newFixedThreadPool(this.poolSize);
            try {
                for (IndexingTask task : tasks) {
                    executorService.submit(task);
                }
                return;
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) return;
                log.debug((Object)"Failed to submit indexing task ", (Throwable)e);
                return;
            }
            finally {
                executorService.shutdown();
            }
        }
    }

    protected static class IndexingTask
    implements Runnable {
        private static final String REGISTRY_RESOURCE_SYMLINK_PATH = "registry.resource.symlink.path";
        private File2Index fileData;

        protected IndexingTask(File2Index fileData) {
            this.fileData = fileData;
        }

        @Override
        public void run() {
            try {
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.fileData.tenantId);
                PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(this.fileData.tenantDomain);
                this.createIndexDocument(this.fileData);
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void createIndexDocument(File2Index file2Index) {
            RegistryContext registryContext = null;
            boolean skipCache = false;
            String resourcePath = file2Index.path;
            try {
                skipCache = IndexingManager.getInstance().isCacheSkipped();
                UserRegistry registry = IndexingManager.getInstance().getRegistry(file2Index.tenantId);
                registryContext = registry.getRegistryContext();
                if (resourcePath != null) {
                    Resource resource;
                    if (skipCache) {
                        registryContext.registerNoCachePath(resourcePath);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Resource at path \"" + resourcePath + "\" is added as a no cache path"));
                        }
                    }
                    if (registry.resourceExists(resourcePath) && (resource = registry.get(resourcePath)) != null) {
                        IndexDocumentCreator indexDocumentCreator = new IndexDocumentCreator(file2Index, resource);
                        indexDocumentCreator.createIndexDocument();
                        String symlinkPath = resource.getProperty(REGISTRY_RESOURCE_SYMLINK_PATH);
                        if (symlinkPath != null) {
                            file2Index.path = symlinkPath;
                            indexDocumentCreator = new IndexDocumentCreator(file2Index, resource);
                            indexDocumentCreator.createIndexDocument();
                        }
                    }
                }
            }
            catch (RegistryException | IndexerException e) {
                log.error((Object)("Error while indexing. Resource at path \"" + resourcePath + "\"could not be indexed" + e));
            }
            finally {
                if (skipCache && registryContext != null) {
                    registryContext.removeNoCachePath(resourcePath);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Resource at path \"" + resourcePath + "\" is removed from no cache path"));
                    }
                }
            }
        }
    }

    public static class File2Index {
        public byte[] data;
        public String mediaType;
        public String path;
        public String lcName;
        public String lcState;
        public String sourceURL;
        public int tenantId;
        public String tenantDomain;

        public File2Index(byte[] data, String mediaType, String path, int tenantId, String tenantDomain) {
            this.data = data;
            this.mediaType = mediaType;
            this.path = path;
            this.tenantId = tenantId;
            this.tenantDomain = tenantDomain;
        }

        public File2Index(byte[] data, String mediaType, String path, int tenantId, String tenantDomain, String lcName, String lcState) {
            this.data = data;
            this.mediaType = mediaType;
            this.path = path;
            this.tenantId = tenantId;
            this.tenantDomain = tenantDomain;
            this.lcName = lcName;
            this.lcState = lcState;
        }

        public File2Index(String path, int tenantId, String tenantDomain, String sourceURL) {
            this.path = path;
            this.tenantId = tenantId;
            this.tenantDomain = tenantDomain;
            this.sourceURL = sourceURL;
        }
    }
}

