/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.identity.oauth2.grant.jwt;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.EncryptedJWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minidev.json.JSONArray;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.identity.application.authentication.framework.model.AuthenticatedUser;
import org.wso2.carbon.identity.application.authentication.framework.util.FrameworkUtils;
import org.wso2.carbon.identity.application.common.IdentityApplicationManagementException;
import org.wso2.carbon.identity.application.common.model.FederatedAuthenticatorConfig;
import org.wso2.carbon.identity.application.common.model.IdentityProvider;
import org.wso2.carbon.identity.application.common.model.Property;
import org.wso2.carbon.identity.application.common.util.IdentityApplicationManagementUtil;
import org.wso2.carbon.identity.base.IdentityException;
import org.wso2.carbon.identity.core.util.IdentityTenantUtil;
import org.wso2.carbon.identity.core.util.IdentityUtil;
import org.wso2.carbon.identity.oauth.config.OAuthServerConfiguration;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.grant.jwt.cache.JWTCache;
import org.wso2.carbon.identity.oauth2.grant.jwt.cache.JWTCacheEntry;
import org.wso2.carbon.identity.oauth2.model.RequestParameter;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.AbstractAuthorizationGrantHandler;
import org.wso2.carbon.identity.oauth2.util.ClaimsUtil;
import org.wso2.carbon.identity.oauth2.util.OAuth2Util;
import org.wso2.carbon.identity.oauth2.validators.jwt.JWKSBasedJWTValidator;
import org.wso2.carbon.idp.mgt.IdentityProviderManagementException;
import org.wso2.carbon.idp.mgt.IdentityProviderManager;

public class JWTBearerGrantHandler
extends AbstractAuthorizationGrantHandler {
    private static final String OAUTH_SPLIT_AUTHZ_USER_3_WAY = "OAuth.SplitAuthzUser3Way";
    private static final String DEFAULT_IDP_NAME = "default";
    private static final Log log = LogFactory.getLog(JWTBearerGrantHandler.class);
    private static final String OIDC_IDP_ENTITY_ID = "IdPEntityId";
    private static final String ERROR_GET_RESIDENT_IDP = "Error while getting Resident Identity Provider of '%s' tenant.";
    private static final String ENFORCE_CERTIFICATE_VALIDITY = "JWTValidatorConfigs.EnforceCertificateExpiryTimeValidity";
    private static Map<Integer, Key> privateKeys = new ConcurrentHashMap<Integer, Key>();
    private String[] registeredClaimNames = new String[]{"iss", "sub", "aud", "exp", "nbf", "iat", "jti"};
    private String tenantDomain;
    private int validityPeriod;
    private boolean validateIAT = true;
    private JWTCache jwtCache;
    private boolean cacheUsedJTI;

    public void init() throws IdentityOAuth2Exception {
        String cacheJWTProp;
        String registeredClaims;
        super.init();
        String validateIATProp = IdentityUtil.getProperty((String)"OAuth.JWTGrant.EnableIATValidation");
        if (StringUtils.isNotBlank((String)validateIATProp)) {
            this.validateIAT = Boolean.parseBoolean(validateIATProp);
        }
        String validityPeriodProp = IdentityUtil.getProperty((String)"OAuth.JWTGrant.IATValidityPeriod");
        if (this.validateIAT) {
            if (StringUtils.isNotBlank((String)validityPeriodProp)) {
                try {
                    this.validityPeriod = Integer.parseInt(validityPeriodProp);
                }
                catch (NumberFormatException e) {
                    this.validityPeriod = 30;
                    log.warn((Object)("Invalid value: " + validityPeriodProp + " is set for IAT validity period. Using default value: " + this.validityPeriod + " minutes."));
                }
            } else {
                this.validityPeriod = 30;
                log.warn((Object)("Empty value is set for IAT validity period. Using default value: " + this.validityPeriod + " minutes."));
            }
        }
        if (StringUtils.isNotBlank((String)(registeredClaims = IdentityUtil.getProperty((String)"OAuth.JWTGrant.RegisteredClaim")))) {
            this.registeredClaimNames = registeredClaims.split("\\s*,\\s*");
        }
        if (StringUtils.isNotBlank((String)(cacheJWTProp = IdentityUtil.getProperty((String)"OAuth.JWTGrant.EnableJWTCache")))) {
            this.cacheUsedJTI = Boolean.parseBoolean(cacheJWTProp);
            if (this.cacheUsedJTI) {
                this.jwtCache = JWTCache.getInstance();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Validate IAT is set to: " + this.validateIAT + " for JWT grant."));
            if (this.validateIAT) {
                log.debug((Object)("IAT validity period is set to: " + this.validityPeriod + " minutes for JWT grant."));
            }
            log.debug((Object)("Caching JWT is set to: " + this.cacheUsedJTI + " for JWT grant."));
        }
    }

    private IdentityProvider getResidentIDPForIssuer(String tenantDomain, String jwtIssuer) throws IdentityOAuth2Exception {
        IdentityProvider residentIdentityProvider;
        String issuer = "";
        try {
            residentIdentityProvider = IdentityProviderManager.getInstance().getResidentIdP(tenantDomain);
        }
        catch (IdentityProviderManagementException e) {
            String errorMsg = String.format(ERROR_GET_RESIDENT_IDP, tenantDomain);
            throw new IdentityOAuth2Exception(errorMsg, (Throwable)e);
        }
        FederatedAuthenticatorConfig[] fedAuthnConfigs = residentIdentityProvider.getFederatedAuthenticatorConfigs();
        FederatedAuthenticatorConfig oauthAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])fedAuthnConfigs, (String)"openidconnect");
        if (oauthAuthenticatorConfig != null) {
            issuer = IdentityApplicationManagementUtil.getProperty((Property[])oauthAuthenticatorConfig.getProperties(), (String)OIDC_IDP_ENTITY_ID).getValue();
        }
        return jwtIssuer.equals(issuer) ? residentIdentityProvider : null;
    }

    public boolean validateGrant(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        JWTClaimsSet claimsSet;
        String tokenEndPointAlias;
        IdentityProvider identityProvider;
        SignedJWT signedJWT;
        block63: {
            EncryptedJWT encryptedJWT;
            signedJWT = null;
            identityProvider = null;
            tokenEndPointAlias = null;
            claimsSet = null;
            this.tenantDomain = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getTenantDomain();
            if (StringUtils.isEmpty((String)this.tenantDomain)) {
                this.tenantDomain = "carbon.super";
            }
            if ((encryptedJWT = this.getEncryptedJWT(tokReqMsgCtx)) == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The assertion is not encrypted.");
                }
                if ((signedJWT = this.getSignedJWT(tokReqMsgCtx)) == null) {
                    this.handleException("No Valid Assertion was found for urn:ietf:params:oauth:grant-type:jwt-bearer");
                } else {
                    claimsSet = this.getClaimSet(signedJWT);
                }
            } else {
                RSAPrivateKey rsaPrivateKey = JWTBearerGrantHandler.getPrivateKey(this.tenantDomain);
                RSADecrypter decrypter = new RSADecrypter((PrivateKey)rsaPrivateKey);
                try {
                    encryptedJWT.decrypt((JWEDecrypter)decrypter);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"The assertion is successfully decrypted.");
                    }
                }
                catch (JOSEException e) {
                    String errorMessage = "Error when decrypting the encrypted JWT." + e.getMessage();
                    throw new IdentityOAuth2Exception(errorMessage, (Throwable)e);
                }
                try {
                    String payload = null;
                    if (encryptedJWT.getPayload() != null) {
                        payload = encryptedJWT.getPayload().toString();
                    }
                    if (!this.isEncryptedJWTSigned(payload)) {
                        try {
                            claimsSet = encryptedJWT.getJWTClaimsSet();
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"The encrypted JWT is not signed. Obtained the claim set of the encrypted JWT.");
                            }
                            break block63;
                        }
                        catch (ParseException ex) {
                            String errorMessage = "Error when trying to retrieve claimsSet from the encrypted JWT." + ex.getMessage();
                            throw new IdentityOAuth2Exception(errorMessage, (Throwable)ex);
                        }
                    }
                    signedJWT = SignedJWT.parse((String)payload);
                    claimsSet = this.getClaimSet(signedJWT);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"The encrypted JWT is signed. Obtained the claim set of the encrypted JWT.");
                    }
                }
                catch (ParseException e) {
                    String errorMessage = "Unexpected number of Base64URL parts of the nested JWT payload. Expected number of parts must be three. ";
                    throw new IdentityOAuth2Exception(errorMessage, (Throwable)e);
                }
            }
        }
        if (claimsSet == null) {
            this.handleException("Claim values are empty in the given JSON Web Token");
        }
        String jwtIssuer = claimsSet.getIssuer();
        String subject = this.resolveSubject(claimsSet);
        List audience = claimsSet.getAudience();
        Date expirationTime = claimsSet.getExpirationTime();
        tokReqMsgCtx.addProperty((Object)"EXPIRY_TIME_JWT", (Object)expirationTime);
        Date notBeforeTime = claimsSet.getNotBeforeTime();
        Date issuedAtTime = claimsSet.getIssueTime();
        String jti = claimsSet.getJWTID();
        Map customClaims = claimsSet.getClaims();
        boolean audienceFound = false;
        long currentTimeInMillis = System.currentTimeMillis();
        long timeStampSkewMillis = OAuthServerConfiguration.getInstance().getTimeStampSkewInSeconds() * 1000L;
        if (StringUtils.isEmpty((String)jwtIssuer) || StringUtils.isEmpty((String)subject) || expirationTime == null || audience == null) {
            this.handleException("Mandatory fields(Issuer, Subject, Expiration time or Audience) are empty in the given JSON Web Token.");
        }
        try {
            boolean checkedExpirationTime;
            identityProvider = IdentityProviderManager.getInstance().getIdPByMetadataProperty("idpIssuerName", jwtIssuer, this.tenantDomain, false);
            if (identityProvider == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("IDP not found when retrieving for IDP using property: idpIssuerName with value: " + jwtIssuer + ". Attempting to retrieve IDP using IDP Name as issuer."));
                }
                identityProvider = IdentityProviderManager.getInstance().getIdPByName(jwtIssuer, this.tenantDomain);
            }
            if (identityProvider != null) {
                if (StringUtils.equalsIgnoreCase((String)identityProvider.getIdentityProviderName(), (String)DEFAULT_IDP_NAME) && (identityProvider = this.getResidentIDPForIssuer(this.tenantDomain, jwtIssuer)) == null) {
                    this.handleException("No Registered IDP found for the JWT with issuer name : " + jwtIssuer);
                }
                tokenEndPointAlias = this.getTokenEndpointAlias(identityProvider);
            } else {
                this.handleException("No Registered IDP found for the JWT with issuer name : " + jwtIssuer);
            }
            if (signedJWT != null) {
                boolean signatureValid = this.validateSignature(signedJWT, identityProvider);
                if (signatureValid) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Signature/MAC validated successfully.");
                    }
                } else {
                    this.handleException("Signature or Message Authentication invalid.");
                }
            }
            this.setAuthorizedUser(tokReqMsgCtx, identityProvider, subject);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Subject(sub) found in JWT: " + subject));
                log.debug((Object)(subject + " set as the Authorized User."));
            }
            tokReqMsgCtx.setScope(tokReqMsgCtx.getOauth2AccessTokenReqDTO().getScope());
            if (StringUtils.isEmpty((String)tokenEndPointAlias)) {
                this.handleException("Token Endpoint alias of the local Identity Provider has not been configured for " + identityProvider.getIdentityProviderName());
            }
            for (String aud : audience) {
                if (!StringUtils.equals((String)tokenEndPointAlias, (String)aud)) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(tokenEndPointAlias + " of IDP was found in the list of audiences."));
                }
                audienceFound = true;
                break;
            }
            if (!audienceFound) {
                this.handleException("None of the audience values matched the tokenEndpoint Alias " + tokenEndPointAlias);
            }
            if ((checkedExpirationTime = this.checkExpirationTime(expirationTime, currentTimeInMillis, timeStampSkewMillis)) && log.isDebugEnabled()) {
                log.debug((Object)"Expiration Time(exp) of JWT was validated successfully.");
            }
            if (notBeforeTime == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Not Before Time(nbf) not found in JWT. Continuing Validation");
                }
            } else {
                boolean checkedNotBeforeTime = this.checkNotBeforeTime(notBeforeTime, currentTimeInMillis, timeStampSkewMillis);
                if (checkedNotBeforeTime && log.isDebugEnabled()) {
                    log.debug((Object)"Not Before Time(nbf) of JWT was validated successfully.");
                }
            }
            if (issuedAtTime == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Issued At Time(iat) not found in JWT. Continuing Validation");
                }
            } else if (!this.validateIAT) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Issued At Time (iat) validation is disabled for the JWT.");
                }
            } else {
                boolean checkedValidityToken = this.checkValidityOfTheToken(issuedAtTime, currentTimeInMillis, timeStampSkewMillis);
                if (checkedValidityToken && log.isDebugEnabled()) {
                    log.debug((Object)"Issued At Time(iat) of JWT was validated successfully.");
                }
            }
            if (this.cacheUsedJTI && jti != null) {
                JWTCacheEntry entry = (JWTCacheEntry)this.jwtCache.getValueFromCache(jti);
                if (entry != null && this.checkCachedJTI(jti, signedJWT, entry, currentTimeInMillis, timeStampSkewMillis) && log.isDebugEnabled()) {
                    log.debug((Object)("JWT id: " + jti + " not found in the cache."));
                    log.debug((Object)"jti of the JWT has been validated successfully.");
                }
            } else if (log.isDebugEnabled()) {
                if (!this.cacheUsedJTI) {
                    log.debug((Object)"List of used JSON Web Token IDs are not maintained. Continue Validation");
                }
                if (jti == null) {
                    log.debug((Object)"JSON Web Token ID(jti) not found in JWT. Continuing Validation");
                }
            }
            if (customClaims == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No custom claims found. Continue validating other claims.");
                }
            } else {
                boolean customClaimsValidated = this.validateCustomClaims(claimsSet.getClaims());
                if (!customClaimsValidated) {
                    this.handleException("Custom Claims in the JWT were invalid");
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"JWT Token was validated successfully");
            }
            if (this.cacheUsedJTI && jti != null) {
                this.jwtCache.addToCache(jti, new JWTCacheEntry(signedJWT));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"JWT Token was added to the cache successfully");
            }
        }
        catch (IdentityProviderManagementException e) {
            this.handleException("Error while getting the Federated Identity Provider ");
        }
        catch (JOSEException e) {
            this.handleException("Error when verifying signature");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Issuer(iss) of the JWT validated successfully");
        }
        if (OAuth2Util.isOIDCAuthzRequest((String[])tokReqMsgCtx.getScope())) {
            this.handleCustomClaims(tokReqMsgCtx, customClaims, identityProvider);
        }
        return true;
    }

    protected void setAuthorizedUser(OAuthTokenReqMessageContext tokenReqMsgCtx, IdentityProvider identityProvider, String authenticatedSubjectIdentifier) {
        AuthenticatedUser authenticatedUser;
        if (Boolean.parseBoolean(IdentityUtil.getProperty((String)OAUTH_SPLIT_AUTHZ_USER_3_WAY))) {
            authenticatedUser = OAuth2Util.getUserFromUserName((String)authenticatedSubjectIdentifier);
            authenticatedUser.setAuthenticatedSubjectIdentifier(authenticatedSubjectIdentifier);
        } else {
            authenticatedUser = AuthenticatedUser.createFederateAuthenticatedUserFromSubjectIdentifier((String)authenticatedSubjectIdentifier);
            authenticatedUser.setUserName(authenticatedSubjectIdentifier);
        }
        authenticatedUser.setFederatedUser(true);
        authenticatedUser.setFederatedIdPName(identityProvider.getIdentityProviderName());
        tokenReqMsgCtx.setAuthorizedUser(authenticatedUser);
    }

    protected void handleCustomClaims(OAuthTokenReqMessageContext tokReqMsgCtx, Map<String, Object> customClaims, IdentityProvider identityProvider) throws IdentityOAuth2Exception {
        Map mappedClaims;
        Map<String, String> customClaimMap = this.getCustomClaims(customClaims);
        try {
            mappedClaims = ClaimsUtil.handleClaimMapping((IdentityProvider)identityProvider, customClaimMap, (String)this.tenantDomain, (OAuthTokenReqMessageContext)tokReqMsgCtx);
        }
        catch (IdentityApplicationManagementException | IdentityException e) {
            throw new IdentityOAuth2Exception("Error while handling custom claim mapping for the tenant domain, " + this.tenantDomain, e);
        }
        AuthenticatedUser user = tokReqMsgCtx.getAuthorizedUser();
        if (MapUtils.isNotEmpty((Map)mappedClaims)) {
            user.setUserAttributes(FrameworkUtils.buildClaimMappings((Map)mappedClaims));
        }
        tokReqMsgCtx.setAuthorizedUser(user);
    }

    public OAuth2AccessTokenRespDTO issue(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        OAuth2AccessTokenRespDTO tokenRespDTO = super.issue(tokReqMsgCtx);
        AuthenticatedUser user = tokReqMsgCtx.getAuthorizedUser();
        Map userAttributes = user.getUserAttributes();
        if (MapUtils.isNotEmpty((Map)userAttributes)) {
            ClaimsUtil.addUserAttributesToCache((OAuth2AccessTokenRespDTO)tokenRespDTO, (OAuthTokenReqMessageContext)tokReqMsgCtx, (Map)userAttributes);
        }
        return tokenRespDTO;
    }

    public boolean issueRefreshToken() throws IdentityOAuth2Exception {
        return OAuthServerConfiguration.getInstance().getValueForIsRefreshTokenAllowed("urn:ietf:params:oauth:grant-type:jwt-bearer");
    }

    protected Map<String, String> getCustomClaims(Map<String, Object> customClaims) {
        HashMap<String, String> customClaimMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : customClaims.entrySet()) {
            String entryKey = entry.getKey();
            boolean isRegisteredClaim = false;
            for (int registeredClaim = 0; registeredClaim < this.registeredClaimNames.length; ++registeredClaim) {
                if (!this.registeredClaimNames[registeredClaim].equals(entryKey)) continue;
                isRegisteredClaim = true;
            }
            if (isRegisteredClaim) continue;
            Object value = entry.getValue();
            if (value instanceof JSONArray) {
                String multiValueSeparator = FrameworkUtils.getMultiAttributeSeparator();
                String multiValuesWithSeparator = StringUtils.join((Collection)((Collection)value), (String)multiValueSeparator);
                customClaimMap.put(entry.getKey(), multiValuesWithSeparator);
                continue;
            }
            customClaimMap.put(entry.getKey(), value.toString());
        }
        return customClaimMap;
    }

    protected String resolveSubject(JWTClaimsSet claimsSet) {
        return claimsSet.getSubject();
    }

    private SignedJWT getSignedJWT(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        SignedJWT signedJWT;
        RequestParameter[] params = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getRequestParameters();
        String assertion = null;
        for (RequestParameter param : params) {
            if (!param.getKey().equals("assertion")) continue;
            assertion = param.getValue()[0];
            break;
        }
        if (StringUtils.isEmpty(assertion)) {
            return null;
        }
        try {
            signedJWT = SignedJWT.parse(assertion);
            if (log.isDebugEnabled()) {
                this.logJWT(signedJWT);
            }
        }
        catch (ParseException e) {
            String errorMessage = "Error while parsing the JWT.";
            throw new IdentityOAuth2Exception(errorMessage, (Throwable)e);
        }
        return signedJWT;
    }

    private JWTClaimsSet getClaimSet(SignedJWT signedJWT) throws IdentityOAuth2Exception {
        JWTClaimsSet claimsSet = null;
        try {
            claimsSet = signedJWT.getJWTClaimsSet();
        }
        catch (ParseException e) {
            this.handleException("Error when trying to retrieve claimsSet from the JWT");
        }
        return claimsSet;
    }

    private String getTokenEndpointAlias(IdentityProvider identityProvider) {
        Property oauthTokenURL = null;
        String tokenEndPointAlias = null;
        if ("LOCAL".equals(identityProvider.getIdentityProviderName())) {
            block8: {
                try {
                    identityProvider = IdentityProviderManager.getInstance().getResidentIdP(this.tenantDomain);
                }
                catch (IdentityProviderManagementException e) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug((Object)("Error while getting Resident IDP :" + e.getMessage()));
                }
            }
            FederatedAuthenticatorConfig[] fedAuthnConfigs = identityProvider.getFederatedAuthenticatorConfigs();
            FederatedAuthenticatorConfig oauthAuthenticatorConfig = IdentityApplicationManagementUtil.getFederatedAuthenticator((FederatedAuthenticatorConfig[])fedAuthnConfigs, (String)"openidconnect");
            if (oauthAuthenticatorConfig != null) {
                oauthTokenURL = IdentityApplicationManagementUtil.getProperty((Property[])oauthAuthenticatorConfig.getProperties(), (String)"OAuth2TokenEPUrl");
            }
            if (oauthTokenURL != null) {
                tokenEndPointAlias = oauthTokenURL.getValue();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Token End Point Alias of Resident IDP :" + tokenEndPointAlias));
                }
            }
        } else {
            tokenEndPointAlias = identityProvider.getAlias();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Token End Point Alias of the Federated IDP: " + tokenEndPointAlias));
            }
        }
        return tokenEndPointAlias;
    }

    private boolean checkExpirationTime(Date expirationTime, long currentTimeInMillis, long timeStampSkewMillis) throws IdentityOAuth2Exception {
        long expirationTimeInMillis = expirationTime.getTime();
        if (currentTimeInMillis + timeStampSkewMillis > expirationTimeInMillis) {
            this.handleException("JSON Web Token is expired., Expiration Time(ms) : " + expirationTimeInMillis + ", TimeStamp Skew : " + timeStampSkewMillis + ", Current Time : " + currentTimeInMillis + ". JWT Rejected and validation terminated");
        }
        return true;
    }

    private boolean checkNotBeforeTime(Date notBeforeTime, long currentTimeInMillis, long timeStampSkewMillis) throws IdentityOAuth2Exception {
        long notBeforeTimeMillis = notBeforeTime.getTime();
        if (currentTimeInMillis + timeStampSkewMillis < notBeforeTimeMillis) {
            this.handleException("JSON Web Token is used before Not_Before_Time., Not Before Time(ms) : " + notBeforeTimeMillis + ", TimeStamp Skew : " + timeStampSkewMillis + ", Current Time : " + currentTimeInMillis + ". JWT Rejected and validation terminated");
        }
        return true;
    }

    private boolean checkValidityOfTheToken(Date issuedAtTime, long currentTimeInMillis, long timeStampSkewMillis) throws IdentityOAuth2Exception {
        long rejectBeforeMillis;
        long issuedAtTimeMillis = issuedAtTime.getTime();
        if (currentTimeInMillis + timeStampSkewMillis - issuedAtTimeMillis > (rejectBeforeMillis = 60000L * (long)this.validityPeriod)) {
            this.handleException("JSON Web Token is issued before the allowed time., Issued At Time(ms) : " + issuedAtTimeMillis + ", Reject before limit(ms) : " + rejectBeforeMillis + ", TimeStamp Skew : " + timeStampSkewMillis + ", Current Time : " + currentTimeInMillis + ". JWT Rejected and validation terminated");
        }
        return true;
    }

    private boolean checkCachedJTI(String jti, SignedJWT signedJWT, JWTCacheEntry entry, long currentTimeInMillis, long timeStampSkewMillis) throws IdentityOAuth2Exception {
        try {
            SignedJWT cachedJWT = entry.getJwt();
            long cachedJWTExpiryTimeMillis = cachedJWT.getJWTClaimsSet().getExpirationTime().getTime();
            if (currentTimeInMillis + timeStampSkewMillis > cachedJWTExpiryTimeMillis) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("JWT Token has been reused after the allowed expiry time : " + cachedJWT.getJWTClaimsSet().getExpirationTime()));
                }
                this.jwtCache.addToCache(jti, new JWTCacheEntry(signedJWT));
                if (log.isDebugEnabled()) {
                    log.debug((Object)"jti of the JWT has been validated successfully and cache updated");
                }
            } else {
                this.handleException("JWT Token \n" + signedJWT.getHeader().toJSONObject().toString() + "\n" + signedJWT.getPayload().toJSONObject().toString() + "\nHas been replayed before the allowed expiry time : " + cachedJWT.getJWTClaimsSet().getExpirationTime());
            }
        }
        catch (ParseException e) {
            this.handleException("Unable to parse the cached jwt assertion : " + entry.getEncodedJWt());
        }
        return true;
    }

    private void logJWT(SignedJWT signedJWT) {
        log.debug((Object)("JWT Header: " + signedJWT.getHeader().toJSONObject().toString()));
        log.debug((Object)("JWT Payload: " + signedJWT.getPayload().toJSONObject().toString()));
        log.debug((Object)("Signature: " + signedJWT.getSignature().toString()));
    }

    private boolean validateSignature(SignedJWT signedJWT, IdentityProvider idp) throws JOSEException, IdentityOAuth2Exception {
        Object[] identityProviderProperties;
        boolean isJWKSEnabled = false;
        boolean hasJWKSUri = false;
        String jwksUri = null;
        String isJWKSEnalbedProperty = IdentityUtil.getProperty((String)"JWTValidatorConfigs.Enable");
        isJWKSEnabled = Boolean.parseBoolean(isJWKSEnalbedProperty);
        if (isJWKSEnabled && log.isDebugEnabled()) {
            log.debug((Object)"JWKS based JWT validation enabled.");
        }
        if (!ArrayUtils.isEmpty((Object[])(identityProviderProperties = idp.getIdpProperties()))) {
            for (Object identityProviderProperty : identityProviderProperties) {
                if (StringUtils.equals((String)identityProviderProperty.getName(), (String)"jwksUri")) {
                    hasJWKSUri = true;
                    jwksUri = identityProviderProperty.getValue();
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)("JWKS endpoint set for the identity provider : " + idp.getIdentityProviderName() + ", jwks_uri : " + jwksUri));
                    break;
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("JWKS endpoint not specified for the identity provider : " + idp.getIdentityProviderName()));
            }
        }
        if (isJWKSEnabled && hasJWKSUri) {
            JWKSBasedJWTValidator jwksBasedJWTValidator = new JWKSBasedJWTValidator();
            return jwksBasedJWTValidator.validateSignature(signedJWT.getParsedString(), jwksUri, signedJWT.getHeader().getAlgorithm().getName(), null);
        }
        RSASSAVerifier verifier = null;
        JWSHeader header = signedJWT.getHeader();
        X509Certificate x509Certificate = this.resolveSignerCertificate(header, idp);
        if (x509Certificate == null) {
            this.handleException("Unable to locate certificate for Identity Provider " + idp.getDisplayName() + "; JWT " + header.toString());
        }
        this.checkValidity(x509Certificate);
        String alg = signedJWT.getHeader().getAlgorithm().getName();
        if (StringUtils.isEmpty((String)alg)) {
            this.handleException("Algorithm must not be null.");
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Signature Algorithm found in the JWT Header: " + alg));
            }
            if (alg.startsWith("RS")) {
                PublicKey publicKey = x509Certificate.getPublicKey();
                if (publicKey instanceof RSAPublicKey) {
                    verifier = new RSASSAVerifier((RSAPublicKey)publicKey);
                } else {
                    this.handleException("Public key is not an RSA public key.");
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Signature Algorithm not supported yet : " + alg));
            }
            if (verifier == null) {
                this.handleException("Could not create a signature verifier for algorithm type: " + alg);
            }
        }
        return signedJWT.verify(verifier);
    }

    private void checkValidity(X509Certificate x509Certificate) throws IdentityOAuth2Exception {
        String isEnforceCertificateValidity = IdentityUtil.getProperty((String)ENFORCE_CERTIFICATE_VALIDITY);
        if (StringUtils.isNotEmpty((String)isEnforceCertificateValidity) && !Boolean.parseBoolean(isEnforceCertificateValidity)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Check for the certificate validity is disabled.");
            }
            return;
        }
        try {
            x509Certificate.checkValidity();
        }
        catch (CertificateExpiredException e) {
            throw new IdentityOAuth2Exception("X509Certificate has expired.", (Throwable)e);
        }
        catch (CertificateNotYetValidException e) {
            throw new IdentityOAuth2Exception("X509Certificate is not yet valid.", (Throwable)e);
        }
    }

    protected X509Certificate resolveSignerCertificate(JWSHeader header, IdentityProvider idp) throws IdentityOAuth2Exception {
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = (X509Certificate)IdentityApplicationManagementUtil.decodeCertificate((String)idp.getCertificate());
        }
        catch (CertificateException e) {
            this.handleException("Error occurred while decoding public certificate of Identity Provider " + idp.getIdentityProviderName() + " for tenant domain " + this.tenantDomain);
        }
        return x509Certificate;
    }

    protected boolean validateCustomClaims(Map<String, Object> customClaims) {
        return true;
    }

    private void handleException(String errorMessage) throws IdentityOAuth2Exception {
        log.error((Object)errorMessage);
        throw new IdentityOAuth2Exception(errorMessage);
    }

    private EncryptedJWT getEncryptedJWT(OAuthTokenReqMessageContext tokReqMsgCtx) {
        RequestParameter[] params = tokReqMsgCtx.getOauth2AccessTokenReqDTO().getRequestParameters();
        String assertion = null;
        if (params != null) {
            for (RequestParameter param : params) {
                if (!"assertion".equals(param.getKey())) continue;
                assertion = param.getValue()[0];
                break;
            }
        }
        if (StringUtils.isEmpty(assertion)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The assertion is empty.");
            }
            return null;
        }
        try {
            EncryptedJWT encryptedJWT = EncryptedJWT.parse(assertion);
            return encryptedJWT;
        }
        catch (ParseException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error while parsing the assertion. The assertion is not encrypted.");
            }
            return null;
        }
    }

    private static RSAPrivateKey getPrivateKey(String tenantDomain) throws IdentityOAuth2Exception {
        Key privateKey;
        int tenantId = OAuth2Util.getTenantId((String)tenantDomain);
        if (!privateKeys.containsKey(tenantId)) {
            try {
                IdentityTenantUtil.initializeRegistry((int)tenantId, (String)tenantDomain);
            }
            catch (IdentityException e) {
                throw new IdentityOAuth2Exception("Error occurred while loading registry for tenant " + tenantDomain, (Throwable)e);
            }
            KeyStoreManager tenantKSM = KeyStoreManager.getInstance((int)tenantId);
            if (!"carbon.super".equals(tenantDomain)) {
                String ksName = tenantDomain.trim().replace(".", "-");
                String jksName = ksName + ".jks";
                privateKey = tenantKSM.getPrivateKey(jksName, tenantDomain);
            } else {
                try {
                    privateKey = tenantKSM.getDefaultPrivateKey();
                }
                catch (Exception e) {
                    throw new IdentityOAuth2Exception("Error while obtaining private key for super tenant", (Throwable)e);
                }
            }
            privateKeys.put(tenantId, privateKey);
        } else {
            privateKey = privateKeys.get(tenantId);
        }
        return (RSAPrivateKey)privateKey;
    }

    private boolean isEncryptedJWTSigned(String payload) {
        String[] parts;
        return StringUtils.isNotEmpty((String)payload) && (parts = payload.split(".")).length == 3 && StringUtils.isNotEmpty((String)parts[2]);
    }
}

