/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.configadmin.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.util.SecurityManager;
import org.w3c.dom.Document;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class XMLPrettyPrinter {
    private InputStream in;
    private boolean xmlFormat;
    private boolean numericEnc;
    private boolean done = false;
    private String encoding = "UTF-8";
    private static Log log = LogFactory.getLog(XMLPrettyPrinter.class);

    public XMLPrettyPrinter(InputStream in, boolean format, boolean numeric, String encoding) {
        this.in = in;
        this.xmlFormat = format;
        this.numericEnc = numeric;
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    public XMLPrettyPrinter(InputStream in) {
        this(in, true, false, null);
    }

    public XMLPrettyPrinter(InputStream in, String encoding) {
        this(in, true, false, encoding);
    }

    public String xmlFormatWithComments() {
        String xmlOutput = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = this.getSecuredDocumentBuilder();
            Document doc = documentBuilderFactory.newDocumentBuilder().parse(this.in);
            DOMImplementationLS domImplementation = (DOMImplementationLS)((Object)doc.getImplementation());
            LSSerializer lsSerializer = domImplementation.createLSSerializer();
            lsSerializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            LSOutput lsOutput = domImplementation.createLSOutput();
            lsOutput.setEncoding(this.encoding);
            StringWriter stringWriter = new StringWriter();
            lsOutput.setCharacterStream(stringWriter);
            lsSerializer.write(doc, lsOutput);
            xmlOutput = ((Object)stringWriter).toString();
        }
        catch (IOException e) {
            log.error((Object)"XML Pretty Printer Error reading data from given InputStream to XML Document ", (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"XML Pretty Printer Error parsing the given InputStream to XML Document", (Throwable)e);
        }
        catch (Exception e) {
            log.error((Object)"XML Pretty Printer failed. ", (Throwable)e);
        }
        return xmlOutput;
    }

    private DocumentBuilderFactory getSecuredDocumentBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setXIncludeAware(false);
        dbf.setExpandEntityReferences(false);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Failed to load XML Processor Feature external-general-entities or external-parameter-entities or nonvalidating/load-external-dtd", (Throwable)e);
        }
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(0);
        dbf.setAttribute("http://apache.org/xml/properties/security-manager", securityManager);
        return dbf;
    }
}

