/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.configadmin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Map;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.ParameterObserver;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.Startup;
import org.apache.synapse.api.API;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.XMLConfigurationBuilder;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2SynapseEnvironment;
import org.apache.synapse.core.axis2.MessageContextCreatorForAxis2;
import org.apache.synapse.core.axis2.ProxyService;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.endpoints.Endpoint;
import org.apache.synapse.endpoints.Template;
import org.apache.synapse.eventing.SynapseEventSource;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.libraries.imports.SynapseImport;
import org.apache.synapse.libraries.model.Library;
import org.apache.synapse.libraries.util.LibDeployerUtils;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.mediators.template.TemplateMediator;
import org.apache.synapse.message.processor.MessageProcessor;
import org.apache.synapse.message.store.MessageStore;
import org.apache.synapse.task.TaskDescriptionRepository;
import org.apache.synapse.task.TaskScheduler;
import org.osgi.framework.ServiceRegistration;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.mediation.configadmin.ConfigAdminException;
import org.wso2.carbon.mediation.configadmin.util.ConfigHolder;
import org.wso2.carbon.mediation.dependency.mgt.services.ConfigurationTrackingService;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationInitilizerException;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationManager;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;
import org.wso2.carbon.proxyadmin.observer.ProxyServiceParameterObserver;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ConfigurationUpdater {
    private static final Log log = LogFactory.getLog(ConfigurationUpdater.class);
    private ServerContextInformation serverContextInformation;
    private ConfigurationContext configurationContext;
    private MediationPersistenceManager persistenceManager;
    private UserRegistry configRegistry;
    private final SynapseConfiguration currentConfig;
    private SynapseEnvironment currentEnvironment;
    private AxisConfiguration axisCfg;
    private TaskDescriptionRepository taskRepository;
    private TaskScheduler taskScheduler;
    private static final String XML = ".xml";

    public ConfigurationUpdater(ServerContextInformation serverContextInformation, ConfigurationContext configurationContext, MediationPersistenceManager persistenceManager, UserRegistry configRegistry) {
        this.serverContextInformation = serverContextInformation;
        this.configurationContext = configurationContext;
        this.persistenceManager = persistenceManager;
        this.configRegistry = configRegistry;
        this.currentConfig = serverContextInformation.getSynapseConfiguration();
        this.currentEnvironment = serverContextInformation.getSynapseEnvironment();
        this.axisCfg = this.currentConfig.getAxisConfiguration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(OMElement configElement) throws AxisFault {
        SynapseConfiguration synapseConfiguration = this.currentConfig;
        synchronized (synapseConfiguration) {
            this.cleanupCurrentConfiguration();
        }
        SynapseConfiguration newConfig = null;
        try {
            newConfig = this.createNewConfiguration(configElement);
        }
        catch (Exception e) {
            newConfig = this.currentConfig;
        }
        finally {
            SynapseConfiguration synapseConfiguration2 = newConfig;
            synchronized (synapseConfiguration2) {
                this.prepareNewConfiguration(newConfig);
            }
        }
    }

    private void cleanupCurrentConfiguration() {
        this.persistenceManager.destroy();
        if (this.currentEnvironment.getTaskManager().isInitialized()) {
            this.taskRepository = this.currentEnvironment.getTaskManager().getTaskDescriptionRepository();
            this.taskScheduler = this.currentEnvironment.getTaskManager().getTaskScheduler();
            TaskDescriptionRepository repository = this.currentEnvironment.getTaskManager().getTaskDescriptionRepository();
            if (repository != null) {
                repository.clear();
            }
            this.currentEnvironment.getTaskManager().cleanup();
        }
        log.trace((Object)"Stopping and undeploying proxy services");
        for (ProxyService proxyService : this.currentConfig.getProxyServices()) {
            proxyService.stop(this.currentConfig);
            this.safeRemoveService(proxyService.getName());
        }
        for (SequenceMediator sequence : this.currentConfig.getDefinedSequences().values()) {
            sequence.destroy();
        }
        for (Endpoint endpoint : this.currentConfig.getDefinedEndpoints().values()) {
            endpoint.destroy();
        }
        log.trace((Object)"Stopping active scheduled tasks");
        for (Startup startup : this.currentConfig.getStartups()) {
            startup.destroy();
        }
        for (SynapseEventSource eventSource : this.currentConfig.getEventSources()) {
            this.safeRemoveService(eventSource.getName());
        }
        for (PriorityExecutor executor : this.currentConfig.getPriorityExecutors().values()) {
            executor.destroy();
        }
        for (MessageStore ms : this.currentConfig.getMessageStores().values()) {
            ms.destroy();
        }
        for (MessageProcessor mp : this.currentConfig.getMessageProcessors().values()) {
            mp.destroy();
        }
        for (TemplateMediator tm : this.currentConfig.getSequenceTemplates().values()) {
            tm.destroy();
        }
        log.trace((Object)"Successfully cleaned up the current SynapseConfiguration");
    }

    private SynapseConfiguration createNewConfiguration(OMElement configElement) throws XMLStreamException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        configElement.serialize((OutputStream)stream);
        return XMLConfigurationBuilder.getConfiguration((InputStream)new ByteArrayInputStream(stream.toByteArray()), (Properties)this.currentConfig.getProperties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareNewConfiguration(SynapseConfiguration newConfig) throws AxisFault {
        newConfig.setPathToConfigFile(this.currentConfig.getPathToConfigFile());
        newConfig.addEntry("SERVER_HOST", this.currentConfig.getEntryDefinition("SERVER_HOST"));
        newConfig.addEntry("SERVER_IP", this.currentConfig.getEntryDefinition("SERVER_IP"));
        if (newConfig.getMainSequence() == null) {
            SynapseConfigUtils.setDefaultMainSequence((SynapseConfiguration)newConfig);
        }
        if (newConfig.getFaultSequence() == null) {
            SynapseConfigUtils.setDefaultFaultSequence((SynapseConfiguration)newConfig);
        }
        this.setFileNames(newConfig);
        newConfig.setAxisConfiguration(this.axisCfg);
        Parameter synapseCtxParam = new Parameter("synapse.config", null);
        synapseCtxParam.setValue((Object)newConfig);
        MessageContextCreatorForAxis2.setSynConfig((SynapseConfiguration)newConfig);
        Axis2SynapseEnvironment synEnv = new Axis2SynapseEnvironment(this.configurationContext, newConfig, this.serverContextInformation);
        Parameter synapseEnvParam = new Parameter("synapse.env", null);
        synapseEnvParam.setValue((Object)synEnv);
        MessageContextCreatorForAxis2.setSynEnv((SynapseEnvironment)synEnv);
        try {
            this.axisCfg.addParameter(synapseCtxParam);
            this.axisCfg.addParameter(synapseEnvParam);
        }
        catch (AxisFault axisFault) {
            this.handleException("Error while adding SynapseConfiguration and/or SynapseEnvironment to the AxisConfiguration", (Exception)((Object)axisFault));
        }
        synEnv.getTaskManager().init(this.taskRepository, this.taskScheduler, newConfig.getTaskManager());
        Parameter suspendPersistence = new Parameter("suspend.mediation.persistence", (Object)"true");
        try {
            this.axisCfg.addParameter(suspendPersistence);
            this.deployServices(newConfig);
        }
        finally {
            this.serverContextInformation.setSynapseConfiguration(newConfig);
            this.serverContextInformation.setSynapseEnvironment((SynapseEnvironment)synEnv);
            newConfig.init((SynapseEnvironment)synEnv);
            synEnv.setInitialized(true);
            this.axisCfg.removeParameter(suspendPersistence);
            this.initPersistence(newConfig);
            this.publishConfiguration(newConfig, synEnv);
        }
    }

    private void deployServices(SynapseConfiguration newConfig) throws AxisFault {
        for (ProxyService proxyService : newConfig.getProxyServices()) {
            try {
                AxisService axisService = proxyService.buildAxisService(newConfig, this.axisCfg);
                ProxyServiceParameterObserver paramObserver = new ProxyServiceParameterObserver(axisService);
                axisService.addParameterObserver((ParameterObserver)paramObserver);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Deployed Proxy service : " + proxyService.getName()));
                }
                if (proxyService.isStartOnLoad()) continue;
                proxyService.stop(newConfig);
            }
            catch (Exception e) {
                this.handleServiceInitializationError(proxyService.getName(), "proxyservices", e);
            }
        }
        for (SynapseEventSource eventSource : newConfig.getEventSources()) {
            try {
                eventSource.buildService(this.axisCfg);
            }
            catch (Exception e) {
                this.handleServiceInitializationError(eventSource.getName(), "eventsources", e);
            }
        }
    }

    private void handleServiceInitializationError(String serviceName, String type, Exception e) throws AxisFault {
        if (!SynapseConfigUtils.isFailSafeEnabled((String)type)) {
            String msg = "Error while initializing the service: " + serviceName;
            log.error((Object)msg, (Throwable)e);
            throw new AxisFault(msg, (Throwable)e);
        }
        log.warn((Object)("Error while initializing the service: " + serviceName + " - Continue in fail-safe mode"), (Throwable)e);
    }

    private void initPersistence(SynapseConfiguration newConfig) {
        ConfigurationManager configurationManager = (ConfigurationManager)this.configurationContext.getProperty("CONFIGURATION_MANAGER");
        try {
            ConfigurationUtils.initPersistence((SynapseConfiguration)newConfig, (UserRegistry)this.configRegistry, (String)newConfig.getPathToConfigFile(), (AxisConfiguration)this.axisCfg, (String)configurationManager.getTracker().getCurrentConfigurationName());
        }
        catch (ConfigurationInitilizerException e) {
            log.error((Object)"Error while initializing mediation persistence", (Throwable)e);
        }
    }

    private void addToDeploymentStore(String parent, String fileName, String artifactName, SynapseConfiguration config) {
        if (fileName != null) {
            File file = new File(this.serverContextInformation.getServerConfigurationInformation().getSynapseXMLLocation(), parent);
            fileName = file.getAbsolutePath() + File.separator + fileName;
            SynapseArtifactDeploymentStore store = config.getArtifactDeploymentStore();
            if (!store.containsFileName(fileName)) {
                store.addArtifact(fileName, artifactName);
            }
            store.addRestoredArtifact(fileName);
        }
    }

    private void setFileNames(SynapseConfiguration newConfig) {
        Map endpoints = newConfig.getDefinedEndpoints();
        for (Object name : endpoints.keySet()) {
            Endpoint newEndpoint = (Endpoint)endpoints.get(name);
            Endpoint oldEndpoint = (Endpoint)this.currentConfig.getDefinedEndpoints().get(name);
            if (oldEndpoint != null) {
                newEndpoint.setFileName(oldEndpoint.getFileName());
                newEndpoint.setArtifactContainerName(oldEndpoint.getArtifactContainerName());
                this.addToDeploymentStore("endpoints", oldEndpoint.getFileName(), (String)name, newConfig);
                continue;
            }
            newEndpoint.setFileName((String)name + XML);
            this.addToDeploymentStore("endpoints", newEndpoint.getFileName(), (String)name, newConfig);
        }
        Map sequences = newConfig.getDefinedSequences();
        for (Object name : sequences.keySet()) {
            SequenceMediator oldSequence = (SequenceMediator)this.currentConfig.getDefinedSequences().get(name);
            if (oldSequence != null) {
                ((SequenceMediator)sequences.get(name)).setFileName(oldSequence.getFileName());
                ((SequenceMediator)sequences.get(name)).setArtifactContainerName(oldSequence.getArtifactContainerName());
                this.addToDeploymentStore("sequences", oldSequence.getFileName(), (String)name, newConfig);
                continue;
            }
            SequenceMediator newSequence = (SequenceMediator)sequences.get(name);
            newSequence.setFileName((String)name + XML);
            this.addToDeploymentStore("sequences", newSequence.getFileName(), (String)name, newConfig);
        }
        Collection proxyServices = newConfig.getProxyServices();
        for (Object proxy : proxyServices) {
            ProxyService oldProxy = this.currentConfig.getProxyService(proxy.getName());
            if (oldProxy != null) {
                proxy.setFileName(oldProxy.getFileName());
                proxy.setArtifactContainerName(oldProxy.getArtifactContainerName());
                this.addToDeploymentStore("proxy-services", oldProxy.getFileName(), proxy.getName(), newConfig);
                continue;
            }
            proxy.setFileName(proxy.getName() + XML);
            this.addToDeploymentStore("sequences", proxy.getFileName(), proxy.getName(), newConfig);
        }
        Map localEntries = newConfig.getDefinedEntries();
        for (Object name : localEntries.keySet()) {
            Entry newEntry = (Entry)localEntries.get(name);
            Entry oldEntry = (Entry)this.currentConfig.getDefinedEntries().get(name);
            if (oldEntry != null) {
                newEntry.setFileName(oldEntry.getFileName());
                newEntry.setArtifactContainerName(oldEntry.getArtifactContainerName());
                this.addToDeploymentStore("local-entries", oldEntry.getFileName(), (String)name, newConfig);
                continue;
            }
            newEntry.setFileName((String)name + XML);
            this.addToDeploymentStore("local-entries", newEntry.getFileName(), (String)name, newConfig);
        }
        Collection tasks = newConfig.getStartups();
        for (Object task : tasks) {
            Startup oldTask = this.currentConfig.getStartup(task.getName());
            if (oldTask != null) {
                task.setFileName(oldTask.getFileName());
                task.setArtifactContainerName(oldTask.getArtifactContainerName());
                this.addToDeploymentStore("tasks", oldTask.getFileName(), task.getName(), newConfig);
                continue;
            }
            task.setFileName(task.getName() + XML);
            this.addToDeploymentStore("tasks", task.getFileName(), task.getName(), newConfig);
        }
        Collection eventSources = newConfig.getEventSources();
        for (Object eventSource : eventSources) {
            SynapseEventSource oldEventSource = this.currentConfig.getEventSource(eventSource.getName());
            if (oldEventSource != null) {
                eventSource.setFileName(oldEventSource.getFileName());
                this.addToDeploymentStore("event-sources", oldEventSource.getFileName(), eventSource.getName(), newConfig);
                continue;
            }
            eventSource.setFileName(eventSource.getName() + XML);
            this.addToDeploymentStore("event-sources", eventSource.getFileName(), eventSource.getName(), newConfig);
        }
        Collection executors = newConfig.getPriorityExecutors().values();
        for (Object exec : executors) {
            PriorityExecutor oldExec = (PriorityExecutor)this.currentConfig.getPriorityExecutors().get(exec.getName());
            if (oldExec != null) {
                exec.setFileName(oldExec.getFileName());
                this.addToDeploymentStore("priority-executors", oldExec.getFileName(), exec.getName(), newConfig);
                continue;
            }
            exec.setFileName(exec.getName() + XML);
            this.addToDeploymentStore("priority-executors", exec.getFileName(), exec.getName(), newConfig);
        }
        Collection messageStores = newConfig.getMessageStores().values();
        for (Object store : messageStores) {
            MessageStore oldStore = this.currentConfig.getMessageStore(store.getName());
            if (oldStore != null) {
                store.setFileName(oldStore.getFileName());
                store.setArtifactContainerName(oldStore.getArtifactContainerName());
                this.addToDeploymentStore("message-stores", oldStore.getFileName(), store.getName(), newConfig);
                continue;
            }
            store.setFileName(store.getName() + XML);
            this.addToDeploymentStore("message-stores", store.getFileName(), store.getName(), newConfig);
        }
        Collection messageProcessors = newConfig.getMessageProcessors().values();
        for (Object processor : messageProcessors) {
            MessageProcessor oldProcessor = (MessageProcessor)this.currentConfig.getMessageProcessors().get(processor.getName());
            if (oldProcessor != null) {
                processor.setFileName(oldProcessor.getFileName());
                processor.setArtifactContainerName(oldProcessor.getArtifactContainerName());
                this.addToDeploymentStore("message-processors", oldProcessor.getFileName(), processor.getName(), newConfig);
                continue;
            }
            processor.setFileName(processor.getName() + XML);
            this.addToDeploymentStore("message-processors", processor.getFileName(), processor.getName(), newConfig);
        }
        Map sequenceTemplates = newConfig.getSequenceTemplates();
        for (Object name : sequenceTemplates.keySet()) {
            TemplateMediator oldSequenceTempl = (TemplateMediator)this.currentConfig.getSequenceTemplates().get(name);
            if (oldSequenceTempl != null) {
                ((TemplateMediator)sequenceTemplates.get(name)).setFileName(oldSequenceTempl.getFileName());
                ((TemplateMediator)sequenceTemplates.get(name)).setArtifactContainerName(oldSequenceTempl.getArtifactContainerName());
                this.addToDeploymentStore("templates", oldSequenceTempl.getFileName(), (String)name, newConfig);
                continue;
            }
            TemplateMediator newSeqTemplate = (TemplateMediator)sequenceTemplates.get(name);
            newSeqTemplate.setFileName((String)name + XML);
            this.addToDeploymentStore("templates", newSeqTemplate.getFileName(), (String)name, newConfig);
        }
        Map endpointTemplates = newConfig.getEndpointTemplates();
        for (Object name : endpointTemplates.keySet()) {
            Template oldEndpointTempl = (Template)this.currentConfig.getEndpointTemplates().get(name);
            if (oldEndpointTempl != null) {
                ((Template)endpointTemplates.get(name)).setFileName(oldEndpointTempl.getFileName());
                ((Template)endpointTemplates.get(name)).setArtifactContainerName(oldEndpointTempl.getArtifactContainerName());
                this.addToDeploymentStore("templates", oldEndpointTempl.getFileName(), (String)name, newConfig);
                continue;
            }
            Template newTemplate = (Template)endpointTemplates.get(name);
            newTemplate.setFileName((String)name + XML);
            this.addToDeploymentStore("templates", newTemplate.getFileName(), (String)name, newConfig);
        }
        Collection apiCollection = newConfig.getAPIs();
        for (Object api : apiCollection) {
            API oldAPI = this.currentConfig.getAPI(api.getName());
            if (oldAPI != null) {
                api.setFileName(oldAPI.getFileName());
                api.setArtifactContainerName(oldAPI.getArtifactContainerName());
                this.addToDeploymentStore("api", api.getFileName(), api.getName(), newConfig);
                continue;
            }
            api.setFileName(api.getName() + XML);
            this.addToDeploymentStore("api", api.getFileName(), api.getName(), newConfig);
        }
        Collection inboundEndpoints = newConfig.getInboundEndpoints();
        for (Object inboundEndpoint : inboundEndpoints) {
            InboundEndpoint oldInbound = this.currentConfig.getInboundEndpoint(inboundEndpoint.getName());
            if (oldInbound == null) continue;
            inboundEndpoint.setArtifactContainerName(oldInbound.getArtifactContainerName());
        }
        Map imports = newConfig.getSynapseImports();
        for (String name : imports.keySet()) {
            SynapseImport oldImport = (SynapseImport)this.currentConfig.getSynapseImports().get(name);
            if (oldImport != null) {
                ((SynapseImport)imports.get(name)).setFileName(oldImport.getFileName());
                this.addToDeploymentStore("imports", oldImport.getFileName(), name, newConfig);
                continue;
            }
            SynapseImport newImport = (SynapseImport)imports.get(name);
            newImport.setFileName(name + XML);
            this.addToDeploymentStore("imports", newImport.getFileName(), name, newConfig);
        }
        Map libraryMap = this.currentConfig.getSynapseLibraries();
        for (String name : libraryMap.keySet()) {
            newConfig.getSynapseLibraries().put(name, libraryMap.get(name));
            String fileName = ((Library)libraryMap.get(name)).getFileName();
            SynapseArtifactDeploymentStore store = newConfig.getArtifactDeploymentStore();
            LibDeployerUtils.deployingLocalEntries((Library)((Library)libraryMap.get(name)), (SynapseConfiguration)newConfig);
            if (!store.containsFileName(fileName)) {
                store.addArtifact(fileName, name);
            }
            store.addRestoredArtifact(fileName);
        }
        if (Boolean.valueOf(this.currentConfig.getProperty("__separateRegDef")).booleanValue()) {
            newConfig.getProperties().setProperty("__separateRegDef", "true");
        }
        if (Boolean.valueOf(this.currentConfig.getProperty("__separateTaskManagerDef")).booleanValue()) {
            newConfig.getProperties().setProperty("__separateTaskManagerDef", "true");
        }
    }

    private void safeRemoveService(String serviceName) {
        AxisService service = this.axisCfg.getServiceForActivation(serviceName);
        if (service != null) {
            try {
                service.getParent().addParameter("keepServiceHistory", (Object)"true");
                this.axisCfg.removeService(serviceName);
            }
            catch (AxisFault axisFault) {
                this.handleException("Error while removing the service: " + serviceName, (Exception)((Object)axisFault));
            }
        }
    }

    private void publishConfiguration(SynapseConfiguration synCfg, Axis2SynapseEnvironment synEnv) {
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        SynapseRegistrationsService registrationsService = ConfigHolder.getInstance().getSynapseRegistrationService(tenantId);
        if (registrationsService != null) {
            this.serverContextInformation.setSynapseConfiguration(synCfg);
            ServiceRegistration configRegistration = registrationsService.getSynapseConfigurationServiceRegistration();
            SynapseConfigurationService synCfgSvc = (SynapseConfigurationService)ConfigHolder.getInstance().getBundleContext().getService(configRegistration.getReference());
            synCfgSvc.setSynapseConfiguration(synCfg);
            configRegistration.setProperties((Dictionary)new Properties());
            ServiceRegistration synEnvSvcRegistration = registrationsService.getSynapseEnvironmentServiceRegistration();
            SynapseEnvironmentService synEnvSvc = (SynapseEnvironmentService)ConfigHolder.getInstance().getBundleContext().getService(synEnvSvcRegistration.getReference());
            synEnvSvc.setSynapseEnvironment((SynapseEnvironment)synEnv);
            synEnvSvcRegistration.setProperties((Dictionary)new Properties());
            ConfigurationTrackingService trackingSvc = ConfigHolder.getInstance().getSynapseConfigTrackingService();
            if (trackingSvc != null) {
                trackingSvc.setSynapseConfiguration(synCfg);
            }
        } else {
            String msg = "Couldn't find the OSGi service information about this ESB Configuration";
            log.error((Object)msg);
            throw new ConfigAdminException(msg);
        }
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new ConfigAdminException(msg, e);
    }
}

