/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.webhooks;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils;
import org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore$AjcClosure21;
import org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore$AjcClosure9;
import org.wso2.carbon.apimgt.impl.dto.WebhooksDTO;
import org.wso2.carbon.apimgt.impl.dto.WebhooksListDTO;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class SubscriptionDataStore {
    private String tenantDomain = "carbon.super";
    public static final int retrievalRetries = 15;
    private static final Log log;
    private Map<String, Map<String, WebhooksDTO>> subscribersMap;
    private Map<String, Boolean> throttlingStatusMap;
    ExecutorService executor = Executors.newSingleThreadExecutor();
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;

    static {
        SubscriptionDataStore.ajc$preClinit();
        log = LogFactory.getLog(SubscriptionDataStore.class);
    }

    public SubscriptionDataStore(String tenantDomain) {
        this.tenantDomain = tenantDomain;
        this.initializeStore();
    }

    public SubscriptionDataStore() {
        this.initializeStore();
    }

    private void initializeStore() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new SubscriptionDataStore$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        SubscriptionDataStore.initializeStore_aroundBody0(this, joinPoint);
    }

    public void addSubscriber(String key, WebhooksDTO subscriber) {
        String string = key;
        WebhooksDTO webhooksDTO = subscriber;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string, (Object)webhooksDTO);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, webhooksDTO, joinPoint};
            MethodTimeLogger.aspectOf().log(new SubscriptionDataStore$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        SubscriptionDataStore.addSubscriber_aroundBody2(this, string, webhooksDTO, joinPoint);
    }

    public void updateThrottleStatus(String key, boolean status) {
        String string = key;
        boolean bl = status;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string, (Object)Conversions.booleanObject((boolean)bl));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, Conversions.booleanObject((boolean)bl), joinPoint};
            MethodTimeLogger.aspectOf().log(new SubscriptionDataStore$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        this.throttlingStatusMap.replace(string, bl);
    }

    public boolean getThrottleStatus(String key) {
        String string = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new SubscriptionDataStore$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return SubscriptionDataStore.getThrottleStatus_aroundBody6(this, string, joinPoint);
    }

    public void removeSubscriber(String key, WebhooksDTO subscriber) {
        String string = key;
        WebhooksDTO webhooksDTO = subscriber;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)webhooksDTO);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, webhooksDTO, joinPoint};
            MethodTimeLogger.aspectOf().log(new SubscriptionDataStore$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        SubscriptionDataStore.removeSubscriber_aroundBody8(this, string, webhooksDTO, joinPoint);
    }

    private String invokeService() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new SubscriptionDataStore$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return SubscriptionDataStore.invokeService_aroundBody10(this, joinPoint);
    }

    private List<WebhooksDTO> loadSubscriptions() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (List)MethodTimeLogger.aspectOf().log(new SubscriptionDataStore$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return SubscriptionDataStore.loadSubscriptions_aroundBody12(this, joinPoint);
    }

    public List<WebhooksDTO> getSubscribers(String api) {
        String string = api;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (List)MethodTimeLogger.aspectOf().log(new SubscriptionDataStore$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648));
        }
        return SubscriptionDataStore.getSubscribers_aroundBody14(this, string, joinPoint);
    }

    static final /* synthetic */ void initializeStore_aroundBody0(SubscriptionDataStore ajc$this, JoinPoint joinPoint) {
        ajc$this.subscribersMap = new ConcurrentHashMap<String, Map<String, WebhooksDTO>>();
        ajc$this.throttlingStatusMap = new ConcurrentHashMap<String, Boolean>();
        ajc$this.executor.submit(() -> {
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this);
            if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
                Object[] objectArray = new Object[]{this, joinPoint};
                MethodTimeLogger.aspectOf().log(new SubscriptionDataStore$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
                return;
            }
            SubscriptionDataStore.lambda$0_aroundBody16(this, joinPoint);
        });
    }

    static final /* synthetic */ void addSubscriber_aroundBody2(SubscriptionDataStore ajc$this, String key, WebhooksDTO subscriber, JoinPoint joinPoint) {
        Map<String, WebhooksDTO> subscribersOfAPIMap = ajc$this.subscribersMap.get(key);
        if (subscribersOfAPIMap != null) {
            subscribersOfAPIMap.put(subscriber.getCallbackURL(), subscriber);
            ajc$this.subscribersMap.replace(key, subscribersOfAPIMap);
        } else {
            subscribersOfAPIMap = new HashMap<String, WebhooksDTO>();
            subscribersOfAPIMap.put(subscriber.getCallbackURL(), subscriber);
            ajc$this.subscribersMap.put(key, subscribersOfAPIMap);
        }
    }

    static final /* synthetic */ boolean getThrottleStatus_aroundBody6(SubscriptionDataStore ajc$this, String key, JoinPoint joinPoint) {
        if (ajc$this.throttlingStatusMap.containsKey(key)) {
            return ajc$this.throttlingStatusMap.get(key);
        }
        return false;
    }

    static final /* synthetic */ void removeSubscriber_aroundBody8(SubscriptionDataStore ajc$this, String key, WebhooksDTO subscriber, JoinPoint joinPoint) {
        Map<String, WebhooksDTO> existingSubscribers = ajc$this.subscribersMap.get(key);
        if (existingSubscribers != null) {
            existingSubscribers.values().removeIf(existingSubscriber -> {
                WebhooksDTO webhooksDTO = subscriber;
                WebhooksDTO webhooksDTO2 = existingSubscriber;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, null, null, (Object)webhooksDTO, (Object)webhooksDTO2);
                if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
                    Object[] objectArray = new Object[]{webhooksDTO, webhooksDTO2, joinPoint};
                    return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new SubscriptionDataStore$AjcClosure19(objectArray).linkClosureAndJoinPoint(65536)));
                }
                return SubscriptionDataStore.lambda$1_aroundBody18(webhooksDTO, webhooksDTO2, joinPoint);
            });
            ajc$this.subscribersMap.replace(key, existingSubscribers);
        }
    }

    static final /* synthetic */ String invokeService_aroundBody10(SubscriptionDataStore ajc$this, JoinPoint joinPoint) {
        try {
            boolean retry;
            String url = WebhooksUtils.getEventHubConfiguration().getServiceUrl().concat("/internal/data/v1").concat("/webhooks-subscriptions");
            HttpGet method = new HttpGet(url);
            byte[] credentials = Base64.encodeBase64((byte[])(String.valueOf(WebhooksUtils.getEventHubConfiguration().getUsername()) + ":" + WebhooksUtils.getEventHubConfiguration().getPassword()).getBytes(StandardCharsets.UTF_8));
            method.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
            method.setHeader("xWSO2Tenant", ajc$this.tenantDomain);
            URL eventHubURL = new URL(url);
            int eventHubPort = eventHubURL.getPort();
            String eventHubProtocol = eventHubURL.getProtocol();
            HttpClient httpClient = APIUtil.getHttpClient((int)eventHubPort, (String)eventHubProtocol);
            HttpResponse httpResponse = null;
            int retryCount = 0;
            do {
                try {
                    httpResponse = httpClient.execute((HttpUriRequest)method);
                    retry = false;
                }
                catch (IOException ex) {
                    if (++retryCount < 15) {
                        retry = true;
                        log.warn((Object)("Failed retrieving webhooks subscription data from remote endpoint: " + ex.getMessage() + ". Retrying after " + 15 + " seconds..."));
                        Thread.sleep(15000L);
                        continue;
                    }
                    throw ex;
                }
            } while (retry);
            return EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
        }
        catch (IOException | InterruptedException e) {
            log.error((Object)"Exception when retrieving webhooks subscription data from remote endpoint ", (Throwable)e);
            return null;
        }
    }

    static final /* synthetic */ List loadSubscriptions_aroundBody12(SubscriptionDataStore ajc$this, JoinPoint joinPoint) {
        String responseString = ajc$this.invokeService();
        List subscriptions = new ArrayList();
        if (responseString != null && !responseString.isEmpty()) {
            subscriptions = ((WebhooksListDTO)new Gson().fromJson(responseString, WebhooksListDTO.class)).getList();
        }
        return subscriptions;
    }

    static final /* synthetic */ List getSubscribers_aroundBody14(SubscriptionDataStore ajc$this, String api, JoinPoint joinPoint) {
        Map<String, WebhooksDTO> subscribers = ajc$this.subscribersMap.get(api);
        if (subscribers != null) {
            Map<String, WebhooksDTO> existingSubscribers = ajc$this.subscribersMap.get(api);
            long now = Instant.now().toEpochMilli();
            existingSubscribers.values().removeIf(existingSubscriber -> {
                long l = now;
                WebhooksDTO webhooksDTO = existingSubscriber;
                JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, null, null, (Object)Conversions.longObject((long)l), (Object)webhooksDTO);
                if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
                    Object[] objectArray = new Object[]{Conversions.longObject((long)l), webhooksDTO, joinPoint};
                    return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new SubscriptionDataStore$AjcClosure21(objectArray).linkClosureAndJoinPoint(65536)));
                }
                return SubscriptionDataStore.lambda$2_aroundBody20(l, webhooksDTO, joinPoint);
            });
            ajc$this.subscribersMap.replace(api, existingSubscribers);
            return new ArrayList<WebhooksDTO>(existingSubscribers.values());
        }
        return null;
    }

    static final /* synthetic */ void lambda$0_aroundBody16(SubscriptionDataStore ajc$this, JoinPoint joinPoint) {
        List<WebhooksDTO> subscriptions = ajc$this.loadSubscriptions();
        for (WebhooksDTO subscriber : subscriptions) {
            String subscriptionKey = String.valueOf(subscriber.getApiUUID()) + "_" + subscriber.getTopicName();
            String throttleKey = String.valueOf(subscriber.getAppID()) + "_" + subscriber.getApiUUID();
            ajc$this.addSubscriber(subscriptionKey, subscriber);
            ajc$this.throttlingStatusMap.put(throttleKey, false);
        }
    }

    static final /* synthetic */ boolean lambda$1_aroundBody18(WebhooksDTO webhooksDTO, WebhooksDTO existingSubscriber, JoinPoint joinPoint) {
        return existingSubscriber.getCallbackURL().equals(webhooksDTO.getCallbackURL());
    }

    static final /* synthetic */ boolean lambda$2_aroundBody20(long l, WebhooksDTO existingSubscriber, JoinPoint joinPoint) {
        return existingSubscriber.getExpiryTime() != 0L && existingSubscriber.getExpiryTime() < l;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SubscriptionDataStore.java", SubscriptionDataStore.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "initializeStore", "org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore", "", "", "", "void"), 72);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addSubscriber", "org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore", "java.lang.String:org.wso2.carbon.apimgt.impl.dto.WebhooksDTO", "key:subscriber", "", "void"), 92);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("100a", "lambda$2", "org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore", "long:org.wso2.carbon.apimgt.impl.dto.WebhooksDTO", "arg0:existingSubscriber", "", "boolean"), 212);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateThrottleStatus", "org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore", "java.lang.String:boolean", "key:status", "", "void"), 110);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getThrottleStatus", "org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore", "java.lang.String", "key", "", "boolean"), 120);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "removeSubscriber", "org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore", "java.lang.String:org.wso2.carbon.apimgt.impl.dto.WebhooksDTO", "key:subscriber", "", "void"), 133);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "invokeService", "org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore", "", "", "", "java.lang.String"), 147);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "loadSubscriptions", "org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore", "", "", "", "java.util.List"), 192);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getSubscribers", "org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore", "java.lang.String", "api", "", "java.util.List"), 207);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1002", "lambda$0", "org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore", "", "", "", "void"), 76);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("100a", "lambda$1", "org.wso2.carbon.apimgt.gateway.webhooks.SubscriptionDataStore", "org.wso2.carbon.apimgt.impl.dto.WebhooksDTO:org.wso2.carbon.apimgt.impl.dto.WebhooksDTO", "arg0:existingSubscriber", "", "boolean"), 136);
    }
}

