/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.utils.redis;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure19;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure21;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure23;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure25;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure27;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils$AjcClosure9;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisCacheUtils {
    private static final Log log;
    private static JedisPool jedisPool;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_13;

    static {
        RedisCacheUtils.ajc$preClinit();
        log = LogFactory.getLog(RedisCacheUtils.class);
    }

    public RedisCacheUtils(String host, int port) {
        jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), host, port);
    }

    public RedisCacheUtils(String host, int port, int timeout, String username, char[] password, int database, boolean ssl) {
        jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), host, port, timeout, username, String.valueOf(password), database, ssl);
    }

    public void setValue(String key, String value) {
        String string = key;
        String string2 = value;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RedisCacheUtils.setValue_aroundBody0(this, string, string2, joinPoint);
    }

    public String getValue(String key) {
        String string = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return RedisCacheUtils.getValue_aroundBody2(this, string, joinPoint);
    }

    public boolean exists(String key) {
        String string = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return RedisCacheUtils.exists_aroundBody4(this, string, joinPoint);
    }

    public Long deleteKey(String key) {
        String string = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (Long)MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
        }
        return RedisCacheUtils.deleteKey_aroundBody6(this, string, joinPoint);
    }

    public void renameKey(String oldKey, String newKey) {
        String string = oldKey;
        String string2 = newKey;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RedisCacheUtils.renameKey_aroundBody8(this, string, string2, joinPoint);
    }

    public Long expireKeyIn(String key, int seconds) {
        String string = key;
        int n = seconds;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, Conversions.intObject((int)n), joinPoint};
            return (Long)MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
        }
        return RedisCacheUtils.expireKeyIn_aroundBody10(this, string, n, joinPoint);
    }

    public Long getTimeToLive(String key) {
        String string = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (Long)MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
        }
        return RedisCacheUtils.getTimeToLive_aroundBody12(this, string, joinPoint);
    }

    public void addFieldValue(String key, String field, String value) {
        String string = key;
        String string2 = field;
        String string3 = value;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
            MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure15(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        RedisCacheUtils.addFieldValue_aroundBody14(this, string, string2, string3, joinPoint);
    }

    public String getFieldValue(String key, String field) {
        String string = key;
        String string2 = field;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string, (Object)string2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, string2, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
        }
        return RedisCacheUtils.getFieldValue_aroundBody16(this, string, string2, joinPoint);
    }

    public void addMap(String key, Map<String, String> map) {
        String string = key;
        Map<String, String> map2 = map;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object)string, map2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, map2, joinPoint};
            MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure19(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RedisCacheUtils.addMap_aroundBody18(this, string, map2, joinPoint);
    }

    public Map<String, String> getMap(String key) {
        String string = key;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, joinPoint};
            return (Map)MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure21(objectArray).linkClosureAndJoinPoint(69648));
        }
        return RedisCacheUtils.getMap_aroundBody20(this, string, joinPoint);
    }

    public void addObject(String key, Object object) {
        String string = key;
        Object object2 = object;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)string, (Object)object2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, object2, joinPoint};
            MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RedisCacheUtils.addObject_aroundBody22(this, string, object2, joinPoint);
    }

    public Object getObject(String key, Class objectType) {
        String string = key;
        Class clazz = objectType;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)string, (Object)clazz);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, clazz, joinPoint};
            return MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
        }
        return RedisCacheUtils.getObject_aroundBody24(this, string, clazz, joinPoint);
    }

    public void stopRedisCacheSession() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_13, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new RedisCacheUtils$AjcClosure27(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        RedisCacheUtils.jedisPool.destroy();
    }

    static final /* synthetic */ void setValue_aroundBody0(RedisCacheUtils ajc$this, String key, String value, JoinPoint joinPoint) {
        Throwable throwable = null;
        Object var6_6 = null;
        try (Jedis jedis = jedisPool.getResource();){
            jedis.set(key, value);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static final /* synthetic */ String getValue_aroundBody2(RedisCacheUtils ajc$this, String key, JoinPoint joinPoint) {
        Throwable throwable = null;
        Object var5_5 = null;
        try (Jedis jedis = jedisPool.getResource();){
            return jedis.get(key);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static final /* synthetic */ boolean exists_aroundBody4(RedisCacheUtils ajc$this, String key, JoinPoint joinPoint) {
        Throwable throwable = null;
        Object var5_5 = null;
        try (Jedis jedis = jedisPool.getResource();){
            return jedis.exists(key);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static final /* synthetic */ Long deleteKey_aroundBody6(RedisCacheUtils ajc$this, String key, JoinPoint joinPoint) {
        Throwable throwable = null;
        Object var5_5 = null;
        try (Jedis jedis = jedisPool.getResource();){
            return jedis.del(key);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static final /* synthetic */ void renameKey_aroundBody8(RedisCacheUtils ajc$this, String oldKey, String newKey, JoinPoint joinPoint) {
        Throwable throwable = null;
        Object var6_6 = null;
        try (Jedis jedis = jedisPool.getResource();){
            jedis.rename(oldKey, newKey);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static final /* synthetic */ Long expireKeyIn_aroundBody10(RedisCacheUtils ajc$this, String key, int seconds, JoinPoint joinPoint) {
        Throwable throwable = null;
        Object var6_6 = null;
        try (Jedis jedis = jedisPool.getResource();){
            return jedis.expire(key, seconds);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static final /* synthetic */ Long getTimeToLive_aroundBody12(RedisCacheUtils ajc$this, String key, JoinPoint joinPoint) {
        Throwable throwable = null;
        Object var5_5 = null;
        try (Jedis jedis = jedisPool.getResource();){
            return jedis.ttl(key);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static final /* synthetic */ void addFieldValue_aroundBody14(RedisCacheUtils ajc$this, String key, String field, String value, JoinPoint joinPoint) {
        Throwable throwable = null;
        Object var7_7 = null;
        try (Jedis jedis = jedisPool.getResource();){
            jedis.hset(key, field, value);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static final /* synthetic */ String getFieldValue_aroundBody16(RedisCacheUtils ajc$this, String key, String field, JoinPoint joinPoint) {
        Throwable throwable = null;
        Object var6_6 = null;
        try (Jedis jedis = jedisPool.getResource();){
            return jedis.hget(key, field);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static final /* synthetic */ void addMap_aroundBody18(RedisCacheUtils ajc$this, String key, Map map, JoinPoint joinPoint) {
        Throwable throwable = null;
        Object var6_6 = null;
        try (Jedis jedis = jedisPool.getResource();){
            jedis.hset(key, map);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final /* synthetic */ Map getMap_aroundBody20(RedisCacheUtils ajc$this, String key, JoinPoint joinPoint) {
        Throwable throwable = null;
        Object var5_5 = null;
        try (Jedis jedis = jedisPool.getResource();){
            Map map = jedis.hgetAll(key);
            if (map.size() != 0) {
                return map;
            }
            return null;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    static final /* synthetic */ void addObject_aroundBody22(RedisCacheUtils ajc$this, String key, Object object, JoinPoint joinPoint) {
        try {
            Throwable throwable = null;
            Object var6_7 = null;
            try (Jedis jedis = jedisPool.getResource();){
                byte[] data = new ObjectMapper().writeValueAsBytes(object);
                jedis.set(key.getBytes(), data);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonProcessingException e) {
            log.error((Object)"Error while converting object to byte array", (Throwable)e);
        }
    }

    static final /* synthetic */ Object getObject_aroundBody24(RedisCacheUtils ajc$this, String key, Class objectType, JoinPoint joinPoint) {
        Jedis jedis;
        Throwable throwable;
        block18: {
            Object object;
            block19: {
                throwable = null;
                Object var6_9 = null;
                jedis = jedisPool.getResource();
                byte[] objectBytes = jedis.get(key.getBytes());
                if (objectBytes == null) break block18;
                object = new ObjectMapper().readValue(objectBytes, objectType);
                if (jedis == null) break block19;
                jedis.close();
            }
            return object;
        }
        if (jedis != null) {
            jedis.close();
        }
        try {
            return null;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    if (jedis != null) {
                        jedis.close();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    try {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                    catch (JsonParseException e) {
                        log.error((Object)"Error while parsing object from Redis Cache", (Throwable)e);
                    }
                }
            }
            catch (JsonMappingException e) {
                log.error((Object)("Error while mapping object to provided class type: " + objectType), (Throwable)e);
            }
            catch (IOException e) {
                log.error((Object)"Error while reading value from Redis Cache", (Throwable)e);
            }
        }
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RedisCacheUtils.java", RedisCacheUtils.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setValue", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String:java.lang.String", "key:value", "", "void"), 80);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getValue", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String", "key", "", "java.lang.String"), 93);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getMap", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String", "key", "", "java.util.Map"), 217);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addObject", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String:java.lang.Object", "key:object", "", "void"), 235);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String:java.lang.Class", "key:objectType", "", "java.lang.Object"), 251);
        ajc$tjp_13 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "stopRedisCacheSession", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "", "", "", "void"), 273);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "exists", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String", "key", "", "boolean"), 106);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteKey", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String", "key", "", "java.lang.Long"), 119);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "renameKey", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String:java.lang.String", "oldKey:newKey", "", "void"), 132);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "expireKeyIn", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String:int", "key:seconds", "", "java.lang.Long"), 147);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTimeToLive", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String", "key", "", "java.lang.Long"), 163);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addFieldValue", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String:java.lang.String:java.lang.String", "key:field:value", "", "void"), 177);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getFieldValue", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String:java.lang.String", "key:field", "", "java.lang.String"), 191);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addMap", "org.wso2.carbon.apimgt.gateway.utils.redis.RedisCacheUtils", "java.lang.String:java.util.Map", "key:map", "", "void"), 204);
    }
}

