/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.utils;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.synapse.Mediator;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.common.analytics.collectors.AnalyticsDataProvider;
import org.wso2.carbon.apimgt.common.analytics.collectors.impl.GenericRequestDataCollector;
import org.wso2.carbon.apimgt.common.analytics.exceptions.AnalyticsException;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.Utils;
import org.wso2.carbon.apimgt.gateway.handlers.streaming.webhook.WebhooksAnalyticsDataProvider;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils$AjcClosure9;
import org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto;
import org.wso2.carbon.apimgt.impl.dto.WebhooksDTO;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;
import org.wso2.carbon.apimgt.keymgt.SubscriptionDataHolder;
import org.wso2.carbon.apimgt.keymgt.model.entity.API;

public class WebhooksUtils {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    static {
        WebhooksUtils.ajc$preClinit();
        log = LogFactory.getLog(WebhooksUtils.class);
    }

    public static HttpResponse persistData(String jsonString, int retriesCount, String eventType) throws InterruptedException, IOException {
        String string = jsonString;
        int n = retriesCount;
        String string2 = eventType;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), string2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{string, Conversions.intObject((int)n), string2, joinPoint};
            return (HttpResponse)MethodTimeLogger.aspectOf().log(new WebhooksUtils$AjcClosure1(objectArray2).linkClosureAndJoinPoint(65536));
        }
        return WebhooksUtils.persistData_aroundBody0(string, n, string2, joinPoint);
    }

    public static EventHubConfigurationDto getEventHubConfiguration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{joinPoint};
            return (EventHubConfigurationDto)MethodTimeLogger.aspectOf().log(new WebhooksUtils$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536));
        }
        return WebhooksUtils.getEventHubConfiguration_aroundBody2(joinPoint);
    }

    public static String generateAPIKey(org.apache.synapse.MessageContext messageContext, String tenantDomain) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        String string = tenantDomain;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)messageContext2, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{messageContext2, string, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new WebhooksUtils$AjcClosure5(objectArray).linkClosureAndJoinPoint(65536));
        }
        return WebhooksUtils.generateAPIKey_aroundBody4(messageContext2, string, joinPoint);
    }

    public static List<WebhooksDTO> getSubscribersListFromInMemoryMap(org.apache.synapse.MessageContext messageContext) throws URISyntaxException {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, null, null, (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{messageContext2, joinPoint};
            return (List)MethodTimeLogger.aspectOf().log(new WebhooksUtils$AjcClosure7(objectArray).linkClosureAndJoinPoint(65536));
        }
        return WebhooksUtils.getSubscribersListFromInMemoryMap_aroundBody6(messageContext2, joinPoint);
    }

    public static boolean isThrottled(String resourceLevelThrottleKey, String subscriptionLevelThrottleKey, String applicationLevelThrottleKey) {
        String string = resourceLevelThrottleKey;
        String string2 = subscriptionLevelThrottleKey;
        String string3 = applicationLevelThrottleKey;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, null, null, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{string, string2, string3, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new WebhooksUtils$AjcClosure9(objectArray2).linkClosureAndJoinPoint(65536)));
        }
        return WebhooksUtils.isThrottled_aroundBody8(string, string2, string3, joinPoint);
    }

    public static void handleThrottleOutMessage(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, null, null, (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{messageContext2, joinPoint};
            MethodTimeLogger.aspectOf().log(new WebhooksUtils$AjcClosure11(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        WebhooksUtils.handleThrottleOutMessage_aroundBody10(messageContext2, joinPoint);
    }

    public static void sendFault(org.apache.synapse.MessageContext messageContext, int httpErrorCode) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        int n = httpErrorCode;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, null, null, (Object)messageContext2, (Object)Conversions.intObject((int)n));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{messageContext2, Conversions.intObject((int)n), joinPoint};
            MethodTimeLogger.aspectOf().log(new WebhooksUtils$AjcClosure13(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        WebhooksUtils.sendFault_aroundBody12(messageContext2, n, joinPoint);
    }

    public static void publishAnalyticsData(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, null, null, (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{messageContext2, joinPoint};
            MethodTimeLogger.aspectOf().log(new WebhooksUtils$AjcClosure15(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        WebhooksUtils.publishAnalyticsData_aroundBody14(messageContext2, joinPoint);
    }

    static final /* synthetic */ HttpResponse persistData_aroundBody0(String jsonString, int retriesCount, String eventType, JoinPoint joinPoint) {
        boolean retry;
        String url = WebhooksUtils.getEventHubConfiguration().getServiceUrl().concat("/internal/data/v1").concat("/notify");
        HttpPost method = new HttpPost(url);
        StringEntity stringEntity = new StringEntity(jsonString, ContentType.APPLICATION_JSON);
        method.setEntity((HttpEntity)stringEntity);
        byte[] credentials = Base64.encodeBase64((byte[])(String.valueOf(WebhooksUtils.getEventHubConfiguration().getUsername()) + ":" + WebhooksUtils.getEventHubConfiguration().getPassword()).getBytes(StandardCharsets.UTF_8));
        method.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
        method.setHeader("X-WSO2-KEY-MANAGER", eventType);
        URL eventHubURL = new URL(url);
        int eventHubPort = eventHubURL.getPort();
        String eventHubProtocol = eventHubURL.getProtocol();
        HttpClient httpClient = APIUtil.getHttpClient((int)eventHubPort, (String)eventHubProtocol);
        int retryCount = 0;
        HttpResponse httpResponse = null;
        do {
            try {
                httpResponse = httpClient.execute((HttpUriRequest)method);
                retry = false;
            }
            catch (IOException ex) {
                if (++retryCount < retriesCount) {
                    retry = true;
                    log.warn((Object)("Failed to persist subscription request to remote endpoint: " + ex.getMessage() + ". Retrying after " + retriesCount + " seconds..."));
                    Thread.sleep(retriesCount * 1000);
                    continue;
                }
                throw ex;
            }
        } while (retry);
        return httpResponse;
    }

    static final /* synthetic */ EventHubConfigurationDto getEventHubConfiguration_aroundBody2(JoinPoint joinPoint) {
        return ServiceReferenceHolder.getInstance().getAPIManagerConfiguration().getEventHubConfigurationDto();
    }

    static final /* synthetic */ String generateAPIKey_aroundBody4(org.apache.synapse.MessageContext messageContext, String tenantDomain, JoinPoint joinPoint) {
        String context = (String)messageContext.getProperty("REST_API_CONTEXT");
        String apiVersion = (String)messageContext.getProperty("SYNAPSE_REST_API_VERSION");
        API api = SubscriptionDataHolder.getInstance().getTenantSubscriptionStore(tenantDomain).getApiByContextAndVersion(context, apiVersion);
        return api.getUuid();
    }

    static final /* synthetic */ List getSubscribersListFromInMemoryMap_aroundBody6(org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        String tenantDomain = (String)messageContext.getProperty("tenant.info.domain");
        String apiKey = WebhooksUtils.generateAPIKey(messageContext, tenantDomain);
        String urlQueryParams = (String)((Axis2MessageContext)messageContext).getAxis2MessageContext().getProperty("TransportInURL");
        List queryParameter = URLEncodedUtils.parse((URI)new URI(urlQueryParams), (String)StandardCharsets.UTF_8.name());
        String topicName = null;
        for (NameValuePair nvPair : queryParameter) {
            if (!"topic".equals(nvPair.getName())) continue;
            topicName = nvPair.getValue();
        }
        String subscriptionKey = String.valueOf(apiKey) + "_" + topicName;
        messageContext.setProperty("SUBSCRIBER_TOPIC", (Object)topicName);
        return ServiceReferenceHolder.getInstance().getSubscriptionsDataService().getSubscriptionsList(subscriptionKey, tenantDomain);
    }

    static final /* synthetic */ boolean isThrottled_aroundBody8(String resourceLevelThrottleKey, String subscriptionLevelThrottleKey, String applicationLevelThrottleKey, JoinPoint joinPoint) {
        boolean isApiLevelThrottled = ServiceReferenceHolder.getInstance().getThrottleDataHolder().isAPIThrottled(resourceLevelThrottleKey);
        boolean isSubscriptionLevelThrottled = ServiceReferenceHolder.getInstance().getThrottleDataHolder().isThrottled(subscriptionLevelThrottleKey);
        boolean isApplicationLevelThrottled = ServiceReferenceHolder.getInstance().getThrottleDataHolder().isThrottled(applicationLevelThrottleKey);
        return isApiLevelThrottled || isApplicationLevelThrottled || isSubscriptionLevelThrottled;
    }

    static final /* synthetic */ void handleThrottleOutMessage_aroundBody10(org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        String errorMessage = "Message throttled out";
        String errorDescription = "You have exceeded your quota";
        int errorCode = 900808;
        int httpErrorCode = 429;
        messageContext.setProperty("ERROR_CODE", (Object)errorCode);
        messageContext.setProperty("ERROR_MESSAGE", (Object)errorMessage);
        messageContext.setProperty("ERROR_DETAIL", (Object)errorDescription);
        messageContext.setProperty("HTTP_RESPONSE_STATUS_CODE", (Object)httpErrorCode);
        Mediator sequence = messageContext.getSequence("_throttle_out_handler_");
        MessageContext axis2MC = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        axis2MC.setProperty("message.builder.invoked", (Object)Boolean.TRUE);
        try {
            RelayUtils.consumeAndDiscardMessage((MessageContext)axis2MC);
        }
        catch (AxisFault axisFault) {
            log.error((Object)"Error occurred while consuming and discarding the message", (Throwable)axisFault);
        }
        if (sequence != null && !sequence.mediate(messageContext)) {
            return;
        }
        WebhooksUtils.sendFault(messageContext, httpErrorCode);
    }

    static final /* synthetic */ void sendFault_aroundBody12(org.apache.synapse.MessageContext messageContext, int httpErrorCode, JoinPoint joinPoint) {
        Utils.sendFault(messageContext, httpErrorCode);
    }

    static final /* synthetic */ void publishAnalyticsData_aroundBody14(org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        MessageContext axisCtx = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        axisCtx.setProperty("SYNAPSE_ARTIFACT_TYPE", (Object)"WEBSUB");
        WebhooksAnalyticsDataProvider provider = new WebhooksAnalyticsDataProvider(messageContext);
        GenericRequestDataCollector dataCollector = new GenericRequestDataCollector((AnalyticsDataProvider)provider);
        try {
            dataCollector.collectData();
        }
        catch (AnalyticsException e) {
            log.error((Object)"Error occurred when collecting data", (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WebhooksUtils.java", WebhooksUtils.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "persistData", "org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils", "java.lang.String:int:java.lang.String", "jsonString:retriesCount:eventType", "java.lang.InterruptedException:java.io.IOException", "org.apache.http.HttpResponse"), 77);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getEventHubConfiguration", "org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils", "", "", "", "org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto"), 119);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "generateAPIKey", "org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils", "org.apache.synapse.MessageContext:java.lang.String", "messageContext:tenantDomain", "", "java.lang.String"), 129);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getSubscribersListFromInMemoryMap", "org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils", "org.apache.synapse.MessageContext", "messageContext", "java.net.URISyntaxException", "java.util.List"), 143);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "isThrottled", "org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils", "java.lang.String:java.lang.String:java.lang.String", "resourceLevelThrottleKey:subscriptionLevelThrottleKey:applicationLevelThrottleKey", "", "boolean"), 171);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "handleThrottleOutMessage", "org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils", "org.apache.synapse.MessageContext", "messageContext", "", "void"), 182);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "sendFault", "org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils", "org.apache.synapse.MessageContext:int", "messageContext:httpErrorCode", "", "void"), 214);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "publishAnalyticsData", "org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils", "org.apache.synapse.MessageContext", "messageContext", "", "void"), 218);
    }
}

