/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.throttling.util;

import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.throttling.ThrottleDataHolder;
import org.wso2.carbon.apimgt.gateway.throttling.util.KeyTemplateRetriever$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.throttling.util.KeyTemplateRetriever$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.throttling.util.KeyTemplateRetriever$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.throttling.util.KeyTemplateRetriever$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.throttling.util.KeyTemplateRetriever$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.throttling.util.KeyTemplateRetriever$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.utils.GatewayUtils;
import org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class KeyTemplateRetriever
extends TimerTask {
    private static final Log log;
    private static final int keyTemplateRetrievalTimeoutInSeconds = 15;
    private static final int keyTemplateRetrievalRetries = 15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        KeyTemplateRetriever.ajc$preClinit();
        log = LogFactory.getLog(KeyTemplateRetriever.class);
    }

    @Override
    public void run() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new KeyTemplateRetriever$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        KeyTemplateRetriever.run_aroundBody0(this, joinPoint);
    }

    private String[] retrieveKeyTemplateData() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (String[])MethodTimeLogger.aspectOf().log(new KeyTemplateRetriever$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return KeyTemplateRetriever.retrieveKeyTemplateData_aroundBody2(this, joinPoint);
    }

    protected EventHubConfigurationDto getEventHubConfiguration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (EventHubConfigurationDto)MethodTimeLogger.aspectOf().log(new KeyTemplateRetriever$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return KeyTemplateRetriever.getEventHubConfiguration_aroundBody4(this, joinPoint);
    }

    public void loadKeyTemplatesFromWebService() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new KeyTemplateRetriever$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        KeyTemplateRetriever.loadKeyTemplatesFromWebService_aroundBody6(this, joinPoint);
    }

    protected ThrottleDataHolder getThrottleDataHolder() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (ThrottleDataHolder)MethodTimeLogger.aspectOf().log(new KeyTemplateRetriever$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return KeyTemplateRetriever.getThrottleDataHolder_aroundBody8(this, joinPoint);
    }

    public void startKeyTemplateDataRetriever() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new KeyTemplateRetriever$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        KeyTemplateRetriever.startKeyTemplateDataRetriever_aroundBody10(this, joinPoint);
    }

    static final /* synthetic */ void run_aroundBody0(KeyTemplateRetriever ajc$this, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting web service based block condition data retrieving process.");
        }
        ajc$this.loadKeyTemplatesFromWebService();
    }

    static final /* synthetic */ String[] retrieveKeyTemplateData_aroundBody2(KeyTemplateRetriever ajc$this, JoinPoint joinPoint) {
        try {
            boolean retry;
            String url = ajc$this.getEventHubConfiguration().getServiceUrl().concat("/internal/data/v1").concat("/keyTemplates");
            byte[] credentials = Base64.encodeBase64((byte[])(String.valueOf(ajc$this.getEventHubConfiguration().getUsername()) + ":" + ajc$this.getEventHubConfiguration().getPassword()).getBytes(StandardCharsets.UTF_8));
            HttpGet method = new HttpGet(url);
            method.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
            URL keyMgtURL = new URL(url);
            int keyMgtPort = keyMgtURL.getPort();
            String keyMgtProtocol = keyMgtURL.getProtocol();
            HttpClient httpClient = APIUtil.getHttpClient((int)keyMgtPort, (String)keyMgtProtocol);
            HttpResponse httpResponse = null;
            int retryCount = 0;
            do {
                try {
                    httpResponse = httpClient.execute((HttpUriRequest)method);
                    retry = false;
                }
                catch (IOException ex) {
                    if (++retryCount < 15) {
                        retry = true;
                        log.warn((Object)("Failed retrieving throttling data from remote endpoint: " + ex.getMessage() + ". Retrying after " + 15 + " seconds..."));
                        Thread.sleep(15000L);
                        continue;
                    }
                    throw ex;
                }
            } while (retry);
            String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            if (responseString != null && !responseString.isEmpty()) {
                Object jsonObject = new JSONParser().parse(responseString);
                if (jsonObject instanceof JSONArray) {
                    JSONArray jsonArray = (JSONArray)new JSONParser().parse(responseString);
                    return (String[])jsonArray.toArray((Object[])new String[jsonArray.size()]);
                }
                log.error((Object)("Invalid throttling data response: " + responseString));
            }
        }
        catch (IOException | InterruptedException | ParseException e) {
            log.error((Object)"Exception when retrieving throttling data from remote endpoint ", e);
        }
        return null;
    }

    static final /* synthetic */ EventHubConfigurationDto getEventHubConfiguration_aroundBody4(KeyTemplateRetriever ajc$this, JoinPoint joinPoint) {
        return ServiceReferenceHolder.getInstance().getAPIManagerConfiguration().getEventHubConfigurationDto();
    }

    static final /* synthetic */ void loadKeyTemplatesFromWebService_aroundBody6(KeyTemplateRetriever ajc$this, JoinPoint joinPoint) {
        List<String> keyListMap = Arrays.asList(ajc$this.retrieveKeyTemplateData());
        ajc$this.getThrottleDataHolder().addKeyTemplateFromMap(GatewayUtils.generateMap(keyListMap));
    }

    static final /* synthetic */ ThrottleDataHolder getThrottleDataHolder_aroundBody8(KeyTemplateRetriever ajc$this, JoinPoint joinPoint) {
        return ServiceReferenceHolder.getInstance().getThrottleDataHolder();
    }

    static final /* synthetic */ void startKeyTemplateDataRetriever_aroundBody10(KeyTemplateRetriever ajc$this, JoinPoint joinPoint) {
        new Timer().schedule((TimerTask)ajc$this, ajc$this.getEventHubConfiguration().getInitDelay());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("KeyTemplateRetriever.java", KeyTemplateRetriever.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.wso2.carbon.apimgt.gateway.throttling.util.KeyTemplateRetriever", "", "", "", "void"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "retrieveKeyTemplateData", "org.wso2.carbon.apimgt.gateway.throttling.util.KeyTemplateRetriever", "", "", "", "[Ljava.lang.String;"), 65);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getEventHubConfiguration", "org.wso2.carbon.apimgt.gateway.throttling.util.KeyTemplateRetriever", "", "", "", "org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto"), 115);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "loadKeyTemplatesFromWebService", "org.wso2.carbon.apimgt.gateway.throttling.util.KeyTemplateRetriever", "", "", "", "void"), 121);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getThrottleDataHolder", "org.wso2.carbon.apimgt.gateway.throttling.util.KeyTemplateRetriever", "", "", "", "org.wso2.carbon.apimgt.gateway.throttling.ThrottleDataHolder"), 126);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "startKeyTemplateDataRetriever", "org.wso2.carbon.apimgt.gateway.throttling.util.KeyTemplateRetriever", "", "", "", "void"), 130);
    }
}

