/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.throttling.util;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.dto.BlockConditionsDTO;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.throttling.ThrottleDataHolder;
import org.wso2.carbon.apimgt.gateway.throttling.util.BlockingConditionRetriever$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.throttling.util.BlockingConditionRetriever$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.throttling.util.BlockingConditionRetriever$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.throttling.util.BlockingConditionRetriever$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.throttling.util.BlockingConditionRetriever$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.throttling.util.BlockingConditionRetriever$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.utils.GatewayUtils;
import org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto;
import org.wso2.carbon.apimgt.impl.utils.APIUtil;

public class BlockingConditionRetriever
extends TimerTask {
    private static final Log log;
    private static final int blockConditionsDataRetrievalTimeoutInSeconds = 15;
    private static final int blockConditionsDataRetrievalRetries = 15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    static {
        BlockingConditionRetriever.ajc$preClinit();
        log = LogFactory.getLog(BlockingConditionRetriever.class);
    }

    @Override
    public void run() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new BlockingConditionRetriever$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        BlockingConditionRetriever.run_aroundBody0(this, joinPoint);
    }

    private BlockConditionsDTO retrieveBlockConditionsData() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (BlockConditionsDTO)MethodTimeLogger.aspectOf().log(new BlockingConditionRetriever$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BlockingConditionRetriever.retrieveBlockConditionsData_aroundBody2(this, joinPoint);
    }

    protected EventHubConfigurationDto getEventHubConfiguration() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (EventHubConfigurationDto)MethodTimeLogger.aspectOf().log(new BlockingConditionRetriever$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BlockingConditionRetriever.getEventHubConfiguration_aroundBody4(this, joinPoint);
    }

    public void loadBlockingConditionsFromWebService() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new BlockingConditionRetriever$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        BlockingConditionRetriever.loadBlockingConditionsFromWebService_aroundBody6(this, joinPoint);
    }

    protected ThrottleDataHolder getThrottleDataHolder() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return (ThrottleDataHolder)MethodTimeLogger.aspectOf().log(new BlockingConditionRetriever$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return BlockingConditionRetriever.getThrottleDataHolder_aroundBody8(this, joinPoint);
    }

    public void startWebServiceThrottleDataRetriever() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            MethodTimeLogger.aspectOf().log(new BlockingConditionRetriever$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        BlockingConditionRetriever.startWebServiceThrottleDataRetriever_aroundBody10(this, joinPoint);
    }

    static final /* synthetic */ void run_aroundBody0(BlockingConditionRetriever ajc$this, JoinPoint joinPoint) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting web service based data retrieving process.");
        }
        ajc$this.loadBlockingConditionsFromWebService();
    }

    static final /* synthetic */ BlockConditionsDTO retrieveBlockConditionsData_aroundBody2(BlockingConditionRetriever ajc$this, JoinPoint joinPoint) {
        try {
            boolean retry;
            String url = ajc$this.getEventHubConfiguration().getServiceUrl().concat("/internal/data/v1").concat("/block");
            byte[] credentials = Base64.encodeBase64((byte[])(String.valueOf(ajc$this.getEventHubConfiguration().getUsername()) + ":" + ajc$this.getEventHubConfiguration().getPassword()).getBytes(StandardCharsets.UTF_8));
            HttpGet method = new HttpGet(url);
            method.setHeader("Authorization", "Basic " + new String(credentials, StandardCharsets.UTF_8));
            URL eventHubUrl = new URL(url);
            int keyMgtPort = eventHubUrl.getPort();
            String protocol = eventHubUrl.getProtocol();
            HttpClient httpClient = APIUtil.getHttpClient((int)keyMgtPort, (String)protocol);
            HttpResponse httpResponse = null;
            int retryCount = 0;
            do {
                try {
                    httpResponse = httpClient.execute((HttpUriRequest)method);
                    retry = false;
                }
                catch (IOException ex) {
                    if (++retryCount < 15) {
                        retry = true;
                        log.warn((Object)("Failed retrieving Blocking Conditions from remote endpoint: " + ex.getMessage() + ". Retrying after " + 15 + " seconds..."));
                        Thread.sleep(15000L);
                        continue;
                    }
                    throw ex;
                }
            } while (retry);
            String responseString = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8");
            if (responseString != null && !responseString.isEmpty()) {
                return (BlockConditionsDTO)new Gson().fromJson(responseString, BlockConditionsDTO.class);
            }
        }
        catch (IOException | InterruptedException e) {
            log.error((Object)"Exception when retrieving Blocking Conditions from remote endpoint ", (Throwable)e);
        }
        return null;
    }

    static final /* synthetic */ EventHubConfigurationDto getEventHubConfiguration_aroundBody4(BlockingConditionRetriever ajc$this, JoinPoint joinPoint) {
        return ServiceReferenceHolder.getInstance().getAPIManagerConfiguration().getEventHubConfigurationDto();
    }

    static final /* synthetic */ void loadBlockingConditionsFromWebService_aroundBody6(BlockingConditionRetriever ajc$this, JoinPoint joinPoint) {
        BlockConditionsDTO blockConditionsDTO = ajc$this.retrieveBlockConditionsData();
        if (blockConditionsDTO != null) {
            ajc$this.getThrottleDataHolder().addAPIBlockingConditionsFromMap(GatewayUtils.generateMap(blockConditionsDTO.getApi()));
            ajc$this.getThrottleDataHolder().addApplicationBlockingConditionsFromMap(GatewayUtils.generateMap(blockConditionsDTO.getApplication()));
            ajc$this.getThrottleDataHolder().addUserBlockingConditionsFromMap(GatewayUtils.generateMap(blockConditionsDTO.getUser()));
            ajc$this.getThrottleDataHolder().addIplockingConditionsFromMap(GatewayUtils.generateIpRangeMap(blockConditionsDTO.getIp()));
            ajc$this.getThrottleDataHolder().addSubscriptionBlockingConditionsFromMap(GatewayUtils.generateMap(blockConditionsDTO.getSubscription()));
        }
    }

    static final /* synthetic */ ThrottleDataHolder getThrottleDataHolder_aroundBody8(BlockingConditionRetriever ajc$this, JoinPoint joinPoint) {
        return ServiceReferenceHolder.getInstance().getThrottleDataHolder();
    }

    static final /* synthetic */ void startWebServiceThrottleDataRetriever_aroundBody10(BlockingConditionRetriever ajc$this, JoinPoint joinPoint) {
        new Timer().schedule((TimerTask)ajc$this, ajc$this.getEventHubConfiguration().getInitDelay());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("BlockingConditionRetriever.java", BlockingConditionRetriever.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "run", "org.wso2.carbon.apimgt.gateway.throttling.util.BlockingConditionRetriever", "", "", "", "void"), 48);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "retrieveBlockConditionsData", "org.wso2.carbon.apimgt.gateway.throttling.util.BlockingConditionRetriever", "", "", "", "org.wso2.carbon.apimgt.gateway.dto.BlockConditionsDTO"), 60);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getEventHubConfiguration", "org.wso2.carbon.apimgt.gateway.throttling.util.BlockingConditionRetriever", "", "", "", "org.wso2.carbon.apimgt.impl.dto.EventHubConfigurationDto"), 104);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "loadBlockingConditionsFromWebService", "org.wso2.carbon.apimgt.gateway.throttling.util.BlockingConditionRetriever", "", "", "", "void"), 109);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "getThrottleDataHolder", "org.wso2.carbon.apimgt.gateway.throttling.util.BlockingConditionRetriever", "", "", "", "org.wso2.carbon.apimgt.gateway.throttling.ThrottleDataHolder"), 125);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "startWebServiceThrottleDataRetriever", "org.wso2.carbon.apimgt.gateway.throttling.util.BlockingConditionRetriever", "", "", "", "void"), 130);
    }
}

