/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.throttling.publisher;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.throttling.publisher.DataProcessAndPublishingAgent;
import org.wso2.carbon.apimgt.gateway.throttling.publisher.ThrottleDataPublisher$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.throttling.publisher.ThrottleDataPublisher$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.throttling.publisher.ThrottleDataPublisher$DataPublisherThreadPoolExecutor$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.throttling.publisher.ThrottleDataPublisherPool;
import org.wso2.carbon.apimgt.impl.dto.ThrottleProperties;
import org.wso2.carbon.databridge.agent.DataPublisher;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAgentConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointAuthenticationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointConfigurationException;
import org.wso2.carbon.databridge.agent.exception.DataEndpointException;
import org.wso2.carbon.databridge.commons.exception.TransportException;

public class ThrottleDataPublisher {
    public static ThrottleDataPublisherPool dataPublisherPool;
    public static final Log log;
    private static volatile DataPublisher dataPublisher;
    Executor executor;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        ThrottleDataPublisher.ajc$preClinit();
        log = LogFactory.getLog(ThrottleDataPublisher.class);
        dataPublisher = null;
    }

    public static DataPublisher getDataPublisher() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{joinPoint};
            return (DataPublisher)MethodTimeLogger.aspectOf().log(new ThrottleDataPublisher$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
        }
        return ThrottleDataPublisher.dataPublisher;
    }

    public ThrottleDataPublisher() {
        ThrottleProperties.DataPublisher dataPublisherConfiguration;
        ThrottleProperties throttleProperties = ServiceReferenceHolder.getInstance().getThrottleProperties();
        if (throttleProperties != null && (dataPublisherConfiguration = ServiceReferenceHolder.getInstance().getThrottleProperties().getDataPublisher()) != null && dataPublisherConfiguration.isEnabled()) {
            dataPublisherPool = ThrottleDataPublisherPool.getInstance();
            ThrottleProperties.DataPublisherThreadPool dataPublisherThreadPoolConfiguration = ServiceReferenceHolder.getInstance().getThrottleProperties().getDataPublisherThreadPool();
            try {
                this.executor = new DataPublisherThreadPoolExecutor(dataPublisherThreadPoolConfiguration.getCorePoolSize(), dataPublisherThreadPoolConfiguration.getMaximumPoolSize(), dataPublisherThreadPoolConfiguration.getKeepAliveTime(), TimeUnit.SECONDS, new LinkedBlockingDeque<Runnable>(){});
                dataPublisher = new DataPublisher(dataPublisherConfiguration.getType(), dataPublisherConfiguration.getReceiverUrlGroup(), dataPublisherConfiguration.getAuthUrlGroup(), dataPublisherConfiguration.getUsername(), dataPublisherConfiguration.getPassword());
            }
            catch (DataEndpointAgentConfigurationException e) {
                log.error((Object)("Error in initializing binary data-publisher to send requests to global throttling engine " + e.getMessage()), (Throwable)e);
            }
            catch (DataEndpointException e) {
                log.error((Object)("Error in initializing binary data-publisher to send requests to global throttling engine " + e.getMessage()), (Throwable)e);
            }
            catch (DataEndpointConfigurationException e) {
                log.error((Object)("Error in initializing binary data-publisher to send requests to global throttling engine " + e.getMessage()), (Throwable)e);
            }
            catch (DataEndpointAuthenticationException e) {
                log.error((Object)("Error in initializing binary data-publisher to send requests to global throttling engine " + e.getMessage()), (Throwable)e);
            }
            catch (TransportException e) {
                log.error((Object)("Error in initializing binary data-publisher to send requests to global throttling engine " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void publishNonThrottledEvent(String applicationLevelThrottleKey, String applicationLevelTier, String apiLevelThrottleKey, String apiLevelTier, String subscriptionLevelThrottleKey, String subscriptionLevelTier, String resourceLevelThrottleKey, String resourceLevelTier, String authorizedUser, String apiContext, String apiVersion, String appTenant, String apiTenant, String appId, MessageContext messageContext, AuthenticationContext authenticationContext) {
        String string = applicationLevelThrottleKey;
        String string2 = applicationLevelTier;
        String string3 = apiLevelThrottleKey;
        String string4 = apiLevelTier;
        String string5 = subscriptionLevelThrottleKey;
        String string6 = subscriptionLevelTier;
        String string7 = resourceLevelThrottleKey;
        String string8 = resourceLevelTier;
        String string9 = authorizedUser;
        String string10 = apiContext;
        String string11 = apiVersion;
        String string12 = appTenant;
        String string13 = apiTenant;
        String string14 = appId;
        MessageContext messageContext2 = messageContext;
        AuthenticationContext authenticationContext2 = authenticationContext;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, messageContext2, authenticationContext2};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, messageContext2, authenticationContext2, joinPoint};
            MethodTimeLogger.aspectOf().log(new ThrottleDataPublisher$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        ThrottleDataPublisher.publishNonThrottledEvent_aroundBody2(this, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, string13, string14, messageContext2, authenticationContext2, joinPoint);
    }

    static final /* synthetic */ void publishNonThrottledEvent_aroundBody2(ThrottleDataPublisher ajc$this, String applicationLevelThrottleKey, String applicationLevelTier, String apiLevelThrottleKey, String apiLevelTier, String subscriptionLevelThrottleKey, String subscriptionLevelTier, String resourceLevelThrottleKey, String resourceLevelTier, String authorizedUser, String apiContext, String apiVersion, String appTenant, String apiTenant, String appId, MessageContext messageContext, AuthenticationContext authenticationContext, JoinPoint joinPoint) {
        try {
            if (dataPublisherPool != null) {
                DataProcessAndPublishingAgent agent = dataPublisherPool.get();
                agent.setDataReference(applicationLevelThrottleKey, applicationLevelTier, apiLevelThrottleKey, apiLevelTier, subscriptionLevelThrottleKey, subscriptionLevelTier, resourceLevelThrottleKey, resourceLevelTier, authorizedUser, apiContext, apiVersion, appTenant, apiTenant, appId, messageContext, authenticationContext);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Publishing throttle data from gateway to traffic-manager for: " + apiContext + " with ID: " + messageContext.getMessageID() + " started" + " at " + new SimpleDateFormat("[yyyy.MM.dd HH:mm:ss,SSS zzz]").format(new Date())));
                }
                ajc$this.executor.execute(agent);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Publishing throttle data from gateway to traffic-manager for: " + apiContext + " with ID: " + messageContext.getMessageID() + " ended" + " at " + new SimpleDateFormat("[yyyy.MM.dd HH:mm:ss,SSS zzz]").format(new Date())));
                }
            } else {
                log.debug((Object)"Throttle data publisher pool is not initialized.");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while publishing throttling events to global policy server", (Throwable)e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ThrottleDataPublisher.java", ThrottleDataPublisher.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "getDataPublisher", "org.wso2.carbon.apimgt.gateway.throttling.publisher.ThrottleDataPublisher", "", "", "", "org.wso2.carbon.databridge.agent.DataPublisher"), 52);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "publishNonThrottledEvent", "org.wso2.carbon.apimgt.gateway.throttling.publisher.ThrottleDataPublisher", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:org.apache.synapse.MessageContext:org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext", "applicationLevelThrottleKey:applicationLevelTier:apiLevelThrottleKey:apiLevelTier:subscriptionLevelThrottleKey:subscriptionLevelTier:resourceLevelThrottleKey:resourceLevelTier:authorizedUser:apiContext:apiVersion:appTenant:apiTenant:appId:messageContext:authenticationContext", "", "void"), 112);
    }

    private class DataPublisherThreadPoolExecutor
    extends ThreadPoolExecutor {
        private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

        public DataPublisherThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, LinkedBlockingDeque<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            Runnable runnable = r;
            Throwable throwable = t;
            JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)runnable, (Object)throwable);
            if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
                Object[] objectArray = new Object[]{this, runnable, throwable, joinPoint};
                MethodTimeLogger.aspectOf().log(new ThrottleDataPublisher$DataPublisherThreadPoolExecutor$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
                return;
            }
            DataPublisherThreadPoolExecutor.afterExecute_aroundBody0(this, runnable, throwable, joinPoint);
        }

        static {
            DataPublisherThreadPoolExecutor.ajc$preClinit();
        }

        static final /* synthetic */ void afterExecute_aroundBody0(DataPublisherThreadPoolExecutor ajc$this, Runnable r, Throwable t, JoinPoint joinPoint) {
            try {
                DataProcessAndPublishingAgent agent = (DataProcessAndPublishingAgent)r;
                dataPublisherPool.release(agent);
            }
            catch (Exception e) {
                log.error((Object)("Error while returning Throttle data publishing agent back to pool" + e.getMessage()));
            }
        }

        private static /* synthetic */ void ajc$preClinit() {
            Factory factory = new Factory("ThrottleDataPublisher.java", DataPublisherThreadPoolExecutor.class);
            ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("4", "afterExecute", "org.wso2.carbon.apimgt.gateway.throttling.publisher.ThrottleDataPublisher$DataPublisherThreadPoolExecutor", "java.lang.Runnable:java.lang.Throwable", "r:t", "", "void"), 166);
        }
    }
}

