/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.threatprotection.analyzer;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.threatprotection.APIMThreatAnalyzerException;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.APIMThreatAnalyzer;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer$AjcClosure13;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer$AjcClosure15;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer$AjcClosure17;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.threatprotection.configuration.JSONConfig;
import org.wso2.carbon.apimgt.gateway.threatprotection.configuration.XMLConfig;

public class JSONAnalyzer
implements APIMThreatAnalyzer {
    private static final String JSON_THREAT_PROTECTION_MSG_PREFIX = "Threat Protection-JSON: ";
    private JsonFactory factory = new JsonFactory();
    private boolean enabled = true;
    private int maxFieldCount = 0;
    private int maxStringLength = 0;
    private int maxArrayElementCount = 0;
    private int maxFieldLength = 0;
    private int maxJsonDepth = 0;
    private static /* synthetic */ int[] $SWITCH_TABLE$com$fasterxml$jackson$core$JsonToken;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;

    @Override
    public void configure(JSONConfig config) {
        JSONConfig jSONConfig = config;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)jSONConfig);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, jSONConfig, joinPoint};
            MethodTimeLogger.aspectOf().log(new JSONAnalyzer$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        JSONAnalyzer.configure_aroundBody0(this, jSONConfig, joinPoint);
    }

    @Override
    public boolean isEnabled() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new JSONAnalyzer$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return this.enabled;
    }

    @Override
    public void configure(XMLConfig config) {
        XMLConfig xMLConfig = config;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)xMLConfig);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, xMLConfig, joinPoint};
            MethodTimeLogger.aspectOf().log(new JSONAnalyzer$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        JSONAnalyzer.configure_aroundBody4(this, xMLConfig, joinPoint);
    }

    @Override
    public void analyze(InputStream in, String apiContext) throws APIMThreatAnalyzerException {
        InputStream inputStream = in;
        String string = apiContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)inputStream, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, inputStream, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new JSONAnalyzer$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        JSONAnalyzer.analyze_aroundBody6(this, inputStream, string, joinPoint);
    }

    public void analyzeDepth(int maxDepth, int currentDepth, String apiContext) throws APIMThreatAnalyzerException {
        int n = maxDepth;
        int n2 = currentDepth;
        String string = apiContext;
        Object[] objectArray = new Object[]{Conversions.intObject((int)n), Conversions.intObject((int)n2), string};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, Conversions.intObject((int)n), Conversions.intObject((int)n2), string, joinPoint};
            MethodTimeLogger.aspectOf().log(new JSONAnalyzer$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        JSONAnalyzer.analyzeDepth_aroundBody8(this, n, n2, string, joinPoint);
    }

    private void analyzeField(String field, int maxFieldCount, int currentFieldCount, int maxFieldLength) throws APIMThreatAnalyzerException {
        String string = field;
        int n = maxFieldCount;
        int n2 = currentFieldCount;
        int n3 = maxFieldLength;
        Object[] objectArray = new Object[]{string, Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.intObject((int)n3)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, string, Conversions.intObject((int)n), Conversions.intObject((int)n2), Conversions.intObject((int)n3), joinPoint};
            MethodTimeLogger.aspectOf().log(new JSONAnalyzer$AjcClosure11(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        JSONAnalyzer.analyzeField_aroundBody10(this, string, n, n2, n3, joinPoint);
    }

    private void analyzeString(String value, int maxLength) throws APIMThreatAnalyzerException {
        String string = value;
        int n = maxLength;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object)string, (Object)Conversions.intObject((int)n));
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, Conversions.intObject((int)n), joinPoint};
            MethodTimeLogger.aspectOf().log(new JSONAnalyzer$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        JSONAnalyzer.analyzeString_aroundBody12(this, string, n, joinPoint);
    }

    private void analyzeArray(JsonParser parser, int maxArrayElementCount, int maxStringLength) throws APIMThreatAnalyzerException {
        JsonParser jsonParser = parser;
        int n = maxArrayElementCount;
        int n2 = maxStringLength;
        Object[] objectArray = new Object[]{jsonParser, Conversions.intObject((int)n), Conversions.intObject((int)n2)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, jsonParser, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
            MethodTimeLogger.aspectOf().log(new JSONAnalyzer$AjcClosure15(objectArray2).linkClosureAndJoinPoint(69648));
            return;
        }
        JSONAnalyzer.analyzeArray_aroundBody14(this, jsonParser, n, n2, joinPoint);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$fasterxml$jackson$core$JsonToken() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, null, null);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{joinPoint};
            return (int[])MethodTimeLogger.aspectOf().log(new JSONAnalyzer$AjcClosure17(objectArray).linkClosureAndJoinPoint(65536));
        }
        return JSONAnalyzer.$SWITCH_TABLE$com$fasterxml$jackson$core$JsonToken_aroundBody16(joinPoint);
    }

    static {
        JSONAnalyzer.ajc$preClinit();
    }

    static final /* synthetic */ void configure_aroundBody0(JSONAnalyzer ajc$this, JSONConfig config, JoinPoint joinPoint) {
        ajc$this.enabled = config.isEnabled();
        ajc$this.maxFieldCount = config.getMaxPropertyCount();
        ajc$this.maxStringLength = config.getMaxStringLength();
        ajc$this.maxArrayElementCount = config.getMaxArrayElementCount();
        ajc$this.maxFieldLength = config.getMaxKeyLength();
        ajc$this.maxJsonDepth = config.getMaxJsonDepth();
    }

    static final /* synthetic */ void configure_aroundBody4(JSONAnalyzer ajc$this, XMLConfig config, JoinPoint joinPoint) {
        throw new UnsupportedOperationException("This method is not supported on this instance");
    }

    static final /* synthetic */ void analyze_aroundBody6(JSONAnalyzer ajc$this, InputStream in, String apiContext, JoinPoint joinPoint) {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JsonParser parser = ajc$this.factory.createParser((Reader)new InputStreamReader(in));){
                JsonToken token;
                int currentDepth = 0;
                int currentFieldCount = 0;
                while ((token = parser.nextToken()) != null) {
                    switch (JSONAnalyzer.$SWITCH_TABLE$com$fasterxml$jackson$core$JsonToken()[token.ordinal()]) {
                        case 2: {
                            ajc$this.analyzeDepth(ajc$this.maxJsonDepth, ++currentDepth, apiContext);
                            break;
                        }
                        case 3: {
                            --currentDepth;
                            break;
                        }
                        case 6: {
                            String name = parser.getCurrentName();
                            ajc$this.analyzeField(name, ajc$this.maxFieldCount, ++currentFieldCount, ajc$this.maxFieldLength);
                            break;
                        }
                        case 8: {
                            String value = parser.getText();
                            ajc$this.analyzeString(value, ajc$this.maxStringLength);
                            break;
                        }
                        case 4: {
                            ajc$this.analyzeArray(parser, ajc$this.maxArrayElementCount, ajc$this.maxStringLength);
                        }
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (JsonParseException e) {
            throw new APIMThreatAnalyzerException("Error occurred while parsing the JSON payload", e);
        }
        catch (IOException e) {
            throw new APIMThreatAnalyzerException("Error occurred while reading the JSON payload.", e);
        }
    }

    static final /* synthetic */ void analyzeDepth_aroundBody8(JSONAnalyzer ajc$this, int maxDepth, int currentDepth, String apiContext, JoinPoint joinPoint) {
        if (currentDepth > maxDepth) {
            throw new APIMThreatAnalyzerException(JSON_THREAT_PROTECTION_MSG_PREFIX + apiContext + " - Depth Limit [" + maxDepth + "] Reached");
        }
    }

    static final /* synthetic */ void analyzeField_aroundBody10(JSONAnalyzer ajc$this, String field, int maxFieldCount, int currentFieldCount, int maxFieldLength, JoinPoint joinPoint) {
        if (field == null) {
            return;
        }
        if (field.length() > maxFieldLength) {
            throw new APIMThreatAnalyzerException(" Max Key Length [" + maxFieldLength + "] Reached");
        }
        if (currentFieldCount > maxFieldCount) {
            throw new APIMThreatAnalyzerException("Max Property Count [" + maxFieldCount + "] Reached");
        }
    }

    static final /* synthetic */ void analyzeString_aroundBody12(JSONAnalyzer ajc$this, String value, int maxLength, JoinPoint joinPoint) {
        if (value == null) {
            return;
        }
        if (value.length() > maxLength) {
            throw new APIMThreatAnalyzerException("Max String Length [" + maxLength + "] Reached");
        }
    }

    static final /* synthetic */ void analyzeArray_aroundBody14(JSONAnalyzer ajc$this, JsonParser parser, int maxArrayElementCount, int maxStringLength, JoinPoint token) {
        try {
            JsonToken token2;
            int arrayElementCount = 0;
            while ((token2 = parser.nextToken()) != JsonToken.END_ARRAY) {
                if (token2 == JsonToken.VALUE_STRING) {
                    String value = parser.getText();
                    ajc$this.analyzeString(value, maxStringLength);
                }
                if (++arrayElementCount <= maxArrayElementCount) continue;
                throw new APIMThreatAnalyzerException(" Max Array Length [" + maxArrayElementCount + "] Reached");
            }
        }
        catch (IOException e) {
            throw new APIMThreatAnalyzerException("Array Parsing Error", e);
        }
    }

    static final /* synthetic */ int[] $SWITCH_TABLE$com$fasterxml$jackson$core$JsonToken_aroundBody16(JoinPoint joinPoint) {
        if ($SWITCH_TABLE$com$fasterxml$jackson$core$JsonToken != null) {
            return $SWITCH_TABLE$com$fasterxml$jackson$core$JsonToken;
        }
        int[] nArray = new int[JsonToken.values().length];
        try {
            nArray[JsonToken.END_ARRAY.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.END_OBJECT.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.FIELD_NAME.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.NOT_AVAILABLE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.START_ARRAY.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.START_OBJECT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.VALUE_EMBEDDED_OBJECT.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.VALUE_FALSE.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.VALUE_NULL.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.VALUE_NUMBER_FLOAT.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.VALUE_NUMBER_INT.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.VALUE_STRING.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[JsonToken.VALUE_TRUE.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$fasterxml$jackson$core$JsonToken = nArray;
        return nArray;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JSONAnalyzer.java", JSONAnalyzer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "configure", "org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer", "org.wso2.carbon.apimgt.gateway.threatprotection.configuration.JSONConfig", "config", "", "void"), 54);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "isEnabled", "org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer", "", "", "", "boolean"), 64);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "configure", "org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer", "org.wso2.carbon.apimgt.gateway.threatprotection.configuration.XMLConfig", "config", "", "void"), 69);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "analyze", "org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer", "java.io.InputStream:java.lang.String", "in:apiContext", "org.wso2.carbon.apimgt.gateway.threatprotection.APIMThreatAnalyzerException", "void"), 79);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "analyzeDepth", "org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer", "int:int:java.lang.String", "maxDepth:currentDepth:apiContext", "org.wso2.carbon.apimgt.gateway.threatprotection.APIMThreatAnalyzerException", "void"), 124);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "analyzeField", "org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer", "java.lang.String:int:int:int", "field:maxFieldCount:currentFieldCount:maxFieldLength", "org.wso2.carbon.apimgt.gateway.threatprotection.APIMThreatAnalyzerException", "void"), 140);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "analyzeString", "org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer", "java.lang.String:int", "value:maxLength", "org.wso2.carbon.apimgt.gateway.threatprotection.APIMThreatAnalyzerException", "void"), 160);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "analyzeArray", "org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer", "com.fasterxml.jackson.core.JsonParser:int:int", "parser:maxArrayElementCount:maxStringLength", "org.wso2.carbon.apimgt.gateway.threatprotection.APIMThreatAnalyzerException", "void"), 177);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1008", "$SWITCH_TABLE$com$fasterxml$jackson$core$JsonToken", "org.wso2.carbon.apimgt.gateway.threatprotection.analyzer.JSONAnalyzer", "", "", "", "[I"), 36);
    }
}

