/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.mediators.webhooks;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.util.EntityUtils;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityUtils;
import org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.mediators.webhooks.SubscribersPersistMediator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.mediators.webhooks.SubscribersPersistMediator$AjcClosure11;
import org.wso2.carbon.apimgt.gateway.mediators.webhooks.SubscribersPersistMediator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.mediators.webhooks.SubscribersPersistMediator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.mediators.webhooks.SubscribersPersistMediator$AjcClosure7;
import org.wso2.carbon.apimgt.gateway.mediators.webhooks.SubscribersPersistMediator$AjcClosure9;
import org.wso2.carbon.apimgt.gateway.utils.WebhooksUtils;

public class SubscribersPersistMediator
extends AbstractMediator {
    private static final int subscriptionDataPersisRetries = 15;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    public boolean mediate(org.apache.synapse.MessageContext messageContext) {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new SubscribersPersistMediator$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648)));
        }
        return SubscribersPersistMediator.mediate_aroundBody0(this, messageContext2, joinPoint);
    }

    private boolean isThrottled(String appID, String apiUUID, String tenantDomain) {
        String string = appID;
        String string2 = apiUUID;
        String string3 = tenantDomain;
        Object[] objectArray = new Object[]{string, string2, string3};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, string, string2, string3, joinPoint};
            return Conversions.booleanValue((Object)MethodTimeLogger.aspectOf().log(new SubscribersPersistMediator$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648)));
        }
        return SubscribersPersistMediator.isThrottled_aroundBody2(this, string, string2, string3, joinPoint);
    }

    private void handleResponse(HttpResponse httpResponse, org.apache.synapse.MessageContext messageContext) throws IOException {
        HttpResponse httpResponse2 = httpResponse;
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)httpResponse2, (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, httpResponse2, messageContext2, joinPoint};
            MethodTimeLogger.aspectOf().log(new SubscribersPersistMediator$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        SubscribersPersistMediator.handleResponse_aroundBody4(this, httpResponse2, messageContext2, joinPoint);
    }

    private void populateException(String errorMsg, org.apache.synapse.MessageContext messageContext) {
        String string = errorMsg;
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, string, messageContext2, joinPoint};
            MethodTimeLogger.aspectOf().log(new SubscribersPersistMediator$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
            return;
        }
        SubscribersPersistMediator.populateException_aroundBody6(this, string, messageContext2, joinPoint);
    }

    private Map<String, String> populateQueryParamData(org.apache.synapse.MessageContext messageContext) throws URISyntaxException {
        org.apache.synapse.MessageContext messageContext2 = messageContext;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this), (Object)messageContext2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{this, messageContext2, joinPoint};
            return (Map)MethodTimeLogger.aspectOf().log(new SubscribersPersistMediator$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
        }
        return SubscribersPersistMediator.populateQueryParamData_aroundBody8(this, messageContext2, joinPoint);
    }

    private String generateRequestBody(String callback, String topicName, String mode, String secret, String leaseSeconds, String apiUUID, String apiContext, String apiVersion, String applicationID, String tenantDomain, int tenantID, AuthenticationContext authContext) {
        String string = callback;
        String string2 = topicName;
        String string3 = mode;
        String string4 = secret;
        String string5 = leaseSeconds;
        String string6 = apiUUID;
        String string7 = apiContext;
        String string8 = apiVersion;
        String string9 = applicationID;
        String string10 = tenantDomain;
        int n = tenantID;
        AuthenticationContext authenticationContext = authContext;
        Object[] objectArray = new Object[]{string, string2, string3, string4, string5, string6, string7, string8, string9, string10, Conversions.intObject((int)n), authenticationContext};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray2 = new Object[]{this, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, Conversions.intObject((int)n), authenticationContext, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new SubscribersPersistMediator$AjcClosure11(objectArray2).linkClosureAndJoinPoint(69648));
        }
        return SubscribersPersistMediator.generateRequestBody_aroundBody10(this, string, string2, string3, string4, string5, string6, string7, string8, string9, string10, n, authenticationContext, joinPoint);
    }

    static {
        SubscribersPersistMediator.ajc$preClinit();
    }

    static final /* synthetic */ boolean mediate_aroundBody0(SubscribersPersistMediator ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        String applicationID;
        String apiVersion;
        String apiContext;
        String apiKey;
        int tenantID;
        String tenantDomain;
        AuthenticationContext authenticationContext;
        String leaseSeconds;
        String secret;
        String mode;
        String topicName;
        String callback;
        block9: {
            Map<String, String> queryParams = ajc$this.populateQueryParamData(messageContext);
            if (queryParams.isEmpty()) {
                ajc$this.populateException("Query params must present in the request", messageContext);
            }
            callback = queryParams.get("hub.callback");
            topicName = queryParams.get("hub.topic");
            mode = queryParams.get("hub.mode");
            secret = queryParams.get("hub.secret");
            leaseSeconds = queryParams.get("hub.lease_seconds");
            messageContext.setProperty("skip_default_metrics_publishing", (Object)true);
            MessageContext axisCtx = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
            axisCtx.setProperty("SYNAPSE_ARTIFACT_TYPE", (Object)"WEBSUB");
            if (StringUtils.isEmpty((CharSequence)callback)) {
                ajc$this.populateException("Callback URL cannot be empty", messageContext);
            }
            if (StringUtils.isEmpty((CharSequence)mode)) {
                ajc$this.populateException("Mode cannot be empty", messageContext);
            } else if (!"subscribe".equalsIgnoreCase(mode.trim()) && !"unsubscribe".equalsIgnoreCase(mode.trim())) {
                ajc$this.populateException("Invalid Entry for hub.mode", messageContext);
            }
            authenticationContext = APISecurityUtils.getAuthenticationContext(messageContext);
            tenantDomain = (String)messageContext.getProperty("tenant.info.domain");
            tenantID = (Integer)messageContext.getProperty("tenant.info.id");
            apiKey = WebhooksUtils.generateAPIKey(messageContext, tenantDomain);
            apiContext = (String)messageContext.getProperty("REST_API_CONTEXT");
            apiVersion = (String)messageContext.getProperty("SYNAPSE_REST_API_VERSION");
            applicationID = (String)messageContext.getProperty("api.ut.application.id");
            if (!"subscribe".equalsIgnoreCase(mode) || !ajc$this.isThrottled(applicationID, apiKey, tenantDomain)) break block9;
            WebhooksUtils.handleThrottleOutMessage(messageContext);
            return false;
        }
        try {
            String jsonString = ajc$this.generateRequestBody(callback, topicName, mode, secret, leaseSeconds, apiKey, apiContext, apiVersion, applicationID, tenantDomain, tenantID, authenticationContext);
            HttpResponse httpResponse = WebhooksUtils.persistData(jsonString, 15, "subscriptionEventType");
            ajc$this.handleResponse(httpResponse, messageContext);
        }
        catch (IOException | InterruptedException | URISyntaxException exception) {
            messageContext.setProperty("ERROR_CODE", (Object)500);
            messageContext.setProperty("ERROR_MESSAGE", (Object)"Error while persisting request");
            messageContext.setProperty("ERROR_DETAIL", (Object)"Error while persisting request");
            Mediator sequence = messageContext.getSequence("_backend_failure_handler_");
            if (sequence != null && !sequence.mediate(messageContext)) {
                return true;
            }
            WebhooksUtils.sendFault(messageContext, 500);
        }
        return true;
    }

    static final /* synthetic */ boolean isThrottled_aroundBody2(SubscribersPersistMediator ajc$this, String appID, String apiUUID, String tenantDomain, JoinPoint joinPoint) {
        return ServiceReferenceHolder.getInstance().getSubscriptionsDataService().getThrottleStatus(appID, apiUUID, tenantDomain);
    }

    static final /* synthetic */ void handleResponse_aroundBody4(SubscribersPersistMediator ajc$this, HttpResponse httpResponse, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        int statusCode = httpResponse.getStatusLine().getStatusCode();
        ((Axis2MessageContext)messageContext).getAxis2MessageContext().setProperty("HTTP_SC", (Object)statusCode);
        if (statusCode == 200 || statusCode == 201) {
            if (ajc$this.log.isDebugEnabled()) {
                ajc$this.log.debug((Object)("Successfully submitted the request for persist subscription with status code: " + statusCode));
            }
        } else {
            String response;
            if (ajc$this.log.isDebugEnabled()) {
                ajc$this.log.debug((Object)("Failed to submit the request for persist subscription with status code: " + statusCode));
            }
            if ((response = EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (String)"UTF-8")).contains("Throttle")) {
                WebhooksUtils.handleThrottleOutMessage(messageContext);
            }
            messageContext.setProperty("ERROR_CODE", (Object)statusCode);
            messageContext.setProperty("ERROR_MESSAGE", (Object)response);
            messageContext.setProperty("ERROR_DETAIL", (Object)response);
            Mediator sequence = messageContext.getSequence("_throttle_out_handler_");
            if (sequence != null && !sequence.mediate(messageContext)) {
                return;
            }
            WebhooksUtils.sendFault(messageContext, statusCode);
        }
    }

    static final /* synthetic */ void populateException_aroundBody6(SubscribersPersistMediator ajc$this, String errorMsg, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        messageContext.setProperty("ERROR_CODE", (Object)500);
        messageContext.setProperty("ERROR_MESSAGE", (Object)errorMsg);
        messageContext.setProperty("ERROR_DETAIL", (Object)errorMsg);
        throw new SynapseException(errorMsg);
    }

    static final /* synthetic */ Map populateQueryParamData_aroundBody8(SubscribersPersistMediator ajc$this, org.apache.synapse.MessageContext messageContext, JoinPoint joinPoint) {
        HashMap<String, String> queryData = new HashMap<String, String>();
        String urlQueryParams = (String)((Axis2MessageContext)messageContext).getAxis2MessageContext().getProperty("TransportInURL");
        if (StringUtils.isEmpty((CharSequence)urlQueryParams)) {
            ajc$this.handleException("Invalid subscription request: URL params are missing", messageContext);
        }
        List queryParameter = URLEncodedUtils.parse((URI)new URI(urlQueryParams), (String)StandardCharsets.UTF_8.name());
        for (NameValuePair nvPair : queryParameter) {
            queryData.put(nvPair.getName(), nvPair.getValue());
        }
        return queryData;
    }

    static final /* synthetic */ String generateRequestBody_aroundBody10(SubscribersPersistMediator ajc$this, String callback, String topicName, String mode, String secret, String leaseSeconds, String apiUUID, String apiContext, String apiVersion, String applicationID, String tenantDomain, int tenantID, AuthenticationContext authContext, JoinPoint joinPoint) {
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("apiUUID", apiUUID);
        node.put("apiContext", apiContext);
        node.put("apiVersion", apiVersion);
        node.put("apiName", authContext.getApiName());
        node.put("appID", applicationID);
        node.put("tenantDomain", tenantDomain);
        node.put("tenantId", tenantID);
        node.put("callback", callback);
        node.put("topic", topicName);
        node.put("mode", mode);
        node.put("secret", secret);
        node.put("leaseSeconds", leaseSeconds);
        node.put("tier", authContext.getTier());
        node.put("applicationTier", authContext.getApplicationTier());
        node.put("apiTier", authContext.getApiTier());
        node.put("subscriberName", authContext.getSubscriber());
        return node.toString();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SubscribersPersistMediator.java", SubscribersPersistMediator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "mediate", "org.wso2.carbon.apimgt.gateway.mediators.webhooks.SubscribersPersistMediator", "org.apache.synapse.MessageContext", "messageContext", "", "boolean"), 62);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "isThrottled", "org.wso2.carbon.apimgt.gateway.mediators.webhooks.SubscribersPersistMediator", "java.lang.String:java.lang.String:java.lang.String", "appID:apiUUID:tenantDomain", "", "boolean"), 116);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "handleResponse", "org.wso2.carbon.apimgt.gateway.mediators.webhooks.SubscribersPersistMediator", "org.apache.http.HttpResponse:org.apache.synapse.MessageContext", "httpResponse:messageContext", "java.io.IOException", "void"), 126);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "populateException", "org.wso2.carbon.apimgt.gateway.mediators.webhooks.SubscribersPersistMediator", "java.lang.String:org.apache.synapse.MessageContext", "errorMsg:messageContext", "", "void"), 157);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "populateQueryParamData", "org.wso2.carbon.apimgt.gateway.mediators.webhooks.SubscribersPersistMediator", "org.apache.synapse.MessageContext", "messageContext", "java.net.URISyntaxException", "java.util.Map"), 169);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "generateRequestBody", "org.wso2.carbon.apimgt.gateway.mediators.webhooks.SubscribersPersistMediator", "java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:java.lang.String:int:org.wso2.carbon.apimgt.gateway.handlers.security.AuthenticationContext", "callback:topicName:mode:secret:leaseSeconds:apiUUID:apiContext:apiVersion:applicationID:tenantDomain:tenantID:authContext", "", "java.lang.String"), 196);
    }
}

