/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.apimgt.gateway.mediators.oauth;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.json.simple.parser.ParseException;
import org.wso2.carbon.apimgt.api.APIManagementException;
import org.wso2.carbon.apimgt.gateway.MethodTimeLogger;
import org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException;
import org.wso2.carbon.apimgt.gateway.internal.ServiceReferenceHolder;
import org.wso2.carbon.apimgt.gateway.mediators.oauth.OAuthTokenGenerator$AjcClosure1;
import org.wso2.carbon.apimgt.gateway.mediators.oauth.OAuthTokenGenerator$AjcClosure3;
import org.wso2.carbon.apimgt.gateway.mediators.oauth.OAuthTokenGenerator$AjcClosure5;
import org.wso2.carbon.apimgt.gateway.mediators.oauth.TokenCache;
import org.wso2.carbon.apimgt.gateway.mediators.oauth.client.OAuthClient;
import org.wso2.carbon.apimgt.gateway.mediators.oauth.client.TokenResponse;
import org.wso2.carbon.apimgt.gateway.mediators.oauth.conf.OAuthEndpoint;

public class OAuthTokenGenerator {
    private static final Log log;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;

    static {
        OAuthTokenGenerator.ajc$preClinit();
        log = LogFactory.getLog(OAuthTokenGenerator.class);
    }

    public static void generateToken(OAuthEndpoint oAuthEndpoint, CountDownLatch latch) throws APISecurityException {
        OAuthEndpoint oAuthEndpoint2 = oAuthEndpoint;
        CountDownLatch countDownLatch = latch;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)oAuthEndpoint2, (Object)countDownLatch);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{oAuthEndpoint2, countDownLatch, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthTokenGenerator$AjcClosure1(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        OAuthTokenGenerator.generateToken_aroundBody0(oAuthEndpoint2, countDownLatch, joinPoint);
    }

    private static void addTokenToCache(OAuthEndpoint oAuthEndpoint, String refreshToken) throws IOException, APIManagementException, ParseException {
        OAuthEndpoint oAuthEndpoint2 = oAuthEndpoint;
        String string = refreshToken;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, null, null, (Object)oAuthEndpoint2, (Object)string);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{oAuthEndpoint2, string, joinPoint};
            MethodTimeLogger.aspectOf().log(new OAuthTokenGenerator$AjcClosure3(objectArray).linkClosureAndJoinPoint(65536));
            return;
        }
        OAuthTokenGenerator.addTokenToCache_aroundBody2(oAuthEndpoint2, string, joinPoint);
    }

    private static String getEndpointId(OAuthEndpoint oAuthEndpoint) {
        OAuthEndpoint oAuthEndpoint2 = oAuthEndpoint;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, null, null, (Object)oAuthEndpoint2);
        if (MethodTimeLogger.isConfigEnabled() && MethodTimeLogger.pointCutAll()) {
            Object[] objectArray = new Object[]{oAuthEndpoint2, joinPoint};
            return (String)MethodTimeLogger.aspectOf().log(new OAuthTokenGenerator$AjcClosure5(objectArray).linkClosureAndJoinPoint(65536));
        }
        return OAuthTokenGenerator.getEndpointId_aroundBody4(oAuthEndpoint2, joinPoint);
    }

    static final /* synthetic */ void generateToken_aroundBody0(OAuthEndpoint oAuthEndpoint, CountDownLatch latch, JoinPoint joinPoint) {
        try {
            TokenResponse previousResponse = null;
            if (ServiceReferenceHolder.getInstance().isRedisEnabled()) {
                Object previousResponseObject = ServiceReferenceHolder.getInstance().getRedisCacheUtils().getObject(oAuthEndpoint.getId(), TokenResponse.class);
                if (previousResponseObject != null) {
                    previousResponse = (TokenResponse)previousResponseObject;
                }
            } else {
                previousResponse = TokenCache.getInstance().getTokenMap().get(oAuthEndpoint.getId());
            }
            if (previousResponse != null) {
                long currentTimeInSeconds;
                long validTill = previousResponse.getValidTill();
                long timeDifference = validTill - (currentTimeInSeconds = System.currentTimeMillis() / 1000L);
                if (timeDifference <= 1L) {
                    if (previousResponse.getRefreshToken() != null) {
                        OAuthTokenGenerator.addTokenToCache(oAuthEndpoint, previousResponse.getRefreshToken());
                    } else {
                        OAuthTokenGenerator.addTokenToCache(oAuthEndpoint, null);
                    }
                }
            } else {
                OAuthTokenGenerator.addTokenToCache(oAuthEndpoint, null);
            }
        }
        catch (IOException e) {
            log.error((Object)("Error while generating OAuth Token" + OAuthTokenGenerator.getEndpointId(oAuthEndpoint)));
            throw new APISecurityException(900901, "Invalid Credentials", e);
        }
        catch (APIManagementException e) {
            log.error((Object)("Could not retrieve OAuth Token" + OAuthTokenGenerator.getEndpointId(oAuthEndpoint)));
            throw new APISecurityException(900900, "Error while retrieving OAuth token", e);
        }
        catch (ParseException e) {
            log.error((Object)("Could not retrieve OAuth Token" + OAuthTokenGenerator.getEndpointId(oAuthEndpoint)));
            throw new APISecurityException(900900, "Error while parsing OAuth Token endpoint response", e);
        }
        if (latch != null) {
            latch.countDown();
        }
    }

    static final /* synthetic */ void addTokenToCache_aroundBody2(OAuthEndpoint oAuthEndpoint, String refreshToken, JoinPoint joinPoint) {
        TokenResponse tokenResponse = OAuthClient.generateToken(oAuthEndpoint.getTokenApiUrl(), oAuthEndpoint.getClientId(), oAuthEndpoint.getClientSecret(), oAuthEndpoint.getUsername(), oAuthEndpoint.getPassword(), oAuthEndpoint.getGrantType(), oAuthEndpoint.getCustomParameters(), refreshToken);
        assert (tokenResponse != null);
        if (ServiceReferenceHolder.getInstance().isRedisEnabled()) {
            ServiceReferenceHolder.getInstance().getRedisCacheUtils().addObject(oAuthEndpoint.getId(), tokenResponse);
        } else {
            TokenCache.getInstance().getTokenMap().put(oAuthEndpoint.getId(), tokenResponse);
        }
    }

    static final /* synthetic */ String getEndpointId_aroundBody4(OAuthEndpoint oAuthEndpoint, JoinPoint joinPoint) {
        return "[url] " + oAuthEndpoint.getTokenApiUrl();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("OAuthTokenGenerator.java", OAuthTokenGenerator.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9", "generateToken", "org.wso2.carbon.apimgt.gateway.mediators.oauth.OAuthTokenGenerator", "org.wso2.carbon.apimgt.gateway.mediators.oauth.conf.OAuthEndpoint:java.util.concurrent.CountDownLatch", "oAuthEndpoint:latch", "org.wso2.carbon.apimgt.gateway.handlers.security.APISecurityException", "void"), 50);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "addTokenToCache", "org.wso2.carbon.apimgt.gateway.mediators.oauth.OAuthTokenGenerator", "org.wso2.carbon.apimgt.gateway.mediators.oauth.conf.OAuthEndpoint:java.lang.String", "oAuthEndpoint:refreshToken", "java.io.IOException:org.wso2.carbon.apimgt.api.APIManagementException:org.json.simple.parser.ParseException", "void"), 107);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "getEndpointId", "org.wso2.carbon.apimgt.gateway.mediators.oauth.OAuthTokenGenerator", "org.wso2.carbon.apimgt.gateway.mediators.oauth.conf.OAuthEndpoint", "oAuthEndpoint", "", "java.lang.String"), 129);
    }
}

